/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.CalcAggFieldsListener;
import com.borland.dx.dataset.CalcFieldsListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.ColumnPaintListener;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.EditListener;
import com.borland.dx.dataset.LoadEvent;
import com.borland.dx.dataset.LoadListener;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.OpenListener;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.Resolver;
import com.borland.dx.dataset.ResolverListener;
import com.borland.dx.dataset.ResolverResponse;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.RowFilterResponse;
import com.borland.dx.dataset.StatusEvent;
import com.borland.dx.dataset.StatusListener;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.SQLResolver;
import com.borland.jb.util.ErrorResponse;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DBEventMonitor
implements AccessListener,
ColumnChangeListener,
ColumnPaintListener,
DataChangeListener,
EditListener,
LoadListener,
NavigationListener,
OpenListener,
Designable,
StatusListener,
ComponentListener,
Serializable {
    private HashMap calcAggFieldsListeners = new HashMap(10);
    private HashMap innerCalcAggFieldsListeners = new HashMap(10);
    private HashMap calcFieldsListeners = new HashMap(10);
    private HashMap innerCalcFieldsListeners = new HashMap(10);
    private HashMap resolverListeners = new HashMap(10);
    private HashMap innerResolverListeners = new HashMap(10);
    private HashMap rowFilterListeners = new HashMap(10);
    private HashMap innerRowFilterListeners = new HashMap(10);
    private HashMap openListeners = new HashMap(10);
    private HashMap columnChangeListeners = new HashMap(30);
    private HashMap columnPaintListeners = new HashMap(30);
    private boolean enableAccessListener = true;
    private boolean enableCalcAggFieldsListener = false;
    private boolean enableCalcFieldsListener = false;
    private boolean enableColumnChangeListener = true;
    private boolean enableColumnPaintListener = false;
    private boolean enableDataChangeListener = true;
    private boolean enableEditListener = true;
    private boolean enableLoadListener = true;
    private boolean enableNavigationListener = true;
    private boolean enableOpenListener = true;
    private boolean enableResolverListener = true;
    private boolean enableRowFilterListener = false;
    private boolean enableStatusListener = true;
    private boolean enabled = true;
    private DataSet[] dataSets;
    private DataSet[] userSetDataSets;
    private Container container;
    private boolean registeredContainer = false;
    private DataSetAware[] userSetDataAwareComponents;
    private DataSetAware[] dataAwareComponents;
    private transient PrintStream out = System.out;

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public void setDataSets(DataSet[] userSetDataSets) {
        this.userSetDataSets = userSetDataSets;
        this.bindDataSets(userSetDataSets);
    }

    public DataSet[] getDataSets() {
        return this.userSetDataSets;
    }

    public void setDataAwareComponentContainer(Container container) {
        if (this.container != container && this.container != null) {
            this.container.removeComponentListener(this);
        }
        this.container = container;
        this.registeredContainer = false;
        if (container != null) {
            container.addComponentListener(this);
        } else {
            this.registerWithDataAwareComponents(null);
        }
    }

    public Container getDataAwareComponentContainer() {
        return this.container;
    }

    public void componentResized(ComponentEvent e2) {
    }

    public void componentMoved(ComponentEvent e2) {
    }

    public void componentHidden(ComponentEvent e2) {
    }

    public void componentShown(ComponentEvent e2) {
        if (!this.registeredContainer && e2.getID() == 102) {
            this.registerWithDataAwareComponents(DBUtilities.findDataAwareComponents(this.container));
            this.registeredContainer = true;
        }
    }

    public void setDataSetAwareComponents(DataSetAware[] dataAwareComponents) {
        this.userSetDataAwareComponents = dataAwareComponents;
        this.registerWithDataAwareComponents(this.userSetDataAwareComponents);
    }

    public DataSetAware[] getDataSetAwareComponents() {
        return this.userSetDataAwareComponents;
    }

    private void registerWithDataAwareComponents(DataSetAware[] dataAwareComponents) {
        if (this.dataAwareComponents != null) {
            for (int index = 0; index < this.dataAwareComponents.length; ++index) {
                DataSet dataSet;
                if (this.dataAwareComponents[index] == null || !(this.dataAwareComponents[index] instanceof ColumnAware) || (dataSet = ((ColumnAware)this.dataAwareComponents[index]).getDataSet()) == null) continue;
                String dataSetName = dataSet.getTableName();
                String columnName = ((ColumnAware)this.dataAwareComponents[index]).getColumnName();
                try {
                    Object listener;
                    Column column = dataSet.getColumn(columnName);
                    if (column.getColumnChangeListener() == this) {
                        column.removeColumnChangeListener(this);
                        listener = this.columnChangeListeners.get(column);
                        if (listener != null) {
                            try {
                                column.addColumnChangeListener((ColumnChangeListener)listener);
                            }
                            catch (Exception e2) {
                                this.out.println(Res.bundle.format(89, this.getEventLabel(), columnName, dataSetName));
                            }
                            this.columnChangeListeners.remove(column);
                        }
                    }
                    if (column.getColumnPaintListener() != this) continue;
                    column.removeColumnPaintListener(this);
                    listener = this.columnPaintListeners.get(column);
                    if (listener == null) continue;
                    try {
                        column.addColumnPaintListener((ColumnPaintListener)listener);
                    }
                    catch (Exception e3) {
                        this.out.println(Res.bundle.format(90, this.getEventLabel(), columnName, dataSetName));
                    }
                    this.columnPaintListeners.remove(column);
                    continue;
                }
                catch (DataSetException e4) {
                    this.out.println(Res.bundle.format(91, this.getEventLabel(), columnName, dataSetName));
                }
            }
        }
        this.dataAwareComponents = dataAwareComponents;
        HashSet<DataSet> uniqueDataSets = new HashSet<DataSet>(10);
        if (dataAwareComponents != null) {
            for (int index = 0; index < dataAwareComponents.length; ++index) {
                DataSet dataSet;
                if (dataAwareComponents[index] != null && dataAwareComponents[index] instanceof ColumnAware && (dataSet = ((ColumnAware)dataAwareComponents[index]).getDataSet()) != null) {
                    String dataSetName = dataSet.getTableName();
                    String columnName = ((ColumnAware)dataAwareComponents[index]).getColumnName();
                    if (columnName == null) continue;
                    try {
                        Column column = dataSet.getColumn(columnName);
                        ColumnChangeListener columnChangeListener = column.getColumnChangeListener();
                        if (columnChangeListener != null) {
                            this.columnChangeListeners.put(column, columnChangeListener);
                            column.removeColumnChangeListener(columnChangeListener);
                        }
                        try {
                            column.addColumnChangeListener(this);
                        }
                        catch (Exception e5) {
                            this.out.println(Res.bundle.format(92, this.getEventLabel(), columnName, dataSetName));
                        }
                        ColumnPaintListener paintListener = column.getColumnPaintListener();
                        if (paintListener != null) {
                            this.columnPaintListeners.put(column, paintListener);
                            column.removeColumnPaintListener(paintListener);
                        }
                        try {
                            column.addColumnPaintListener(this);
                        }
                        catch (Exception e6) {
                            this.out.println(Res.bundle.format(93, this.getEventLabel(), columnName, dataSetName));
                        }
                    }
                    catch (DataSetException e7) {
                        this.out.println(Res.bundle.format(94, this.getEventLabel(), columnName, dataSetName));
                    }
                }
                if (dataAwareComponents[index] == null || (dataSet = dataAwareComponents[index].getDataSet()) == null) continue;
                uniqueDataSets.add(dataSet);
            }
        }
        DataSet[] dataSets = new DataSet[uniqueDataSets.size()];
        Iterator iterator = uniqueDataSets.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            dataSets[index] = (DataSet)iterator.next();
            ++index;
        }
        this.bindDataSets(dataSets);
    }

    private void bindDataSets(DataSet[] dataSets) {
        CalcFieldsListener cfl;
        StorageDataSet sDataSet;
        String dataSetName;
        DataSet dataSet;
        int index;
        DataSet[] oldDataSets = this.dataSets;
        if (oldDataSets != null) {
            for (index = 0; index < oldDataSets.length; ++index) {
                dataSet = oldDataSets[index];
                if (dataSet == null) continue;
                dataSetName = dataSet.getTableName();
                sDataSet = null;
                if (dataSet instanceof StorageDataSet) {
                    sDataSet = (StorageDataSet)dataSet;
                }
                dataSet.removeAccessListener(this);
                dataSet.removeDataChangeListener(this);
                dataSet.removeNavigationListener(this);
                dataSet.removeStatusListener(this);
                if (((Boolean)this.openListeners.get(dataSet)).booleanValue()) {
                    dataSet.removeOpenListener(this);
                    this.openListeners.remove(dataSet);
                }
                try {
                    RowFilterListener rfl = (RowFilterListener)this.innerRowFilterListeners.get(dataSet);
                    if (dataSet.getRowFilterListener() == rfl && rfl != null) {
                        dataSet.removeRowFilterListener(rfl);
                        if (this.rowFilterListeners.get(dataSet) != null) {
                            dataSet.addRowFilterListener((RowFilterListener)this.rowFilterListeners.get(dataSet));
                            this.rowFilterListeners.remove(dataSet);
                            this.innerRowFilterListeners.remove(dataSet);
                        }
                    }
                }
                catch (Exception e2) {
                    this.out.println(Res.bundle.format(95, this.getEventLabel(), dataSetName));
                }
                if (sDataSet == null) continue;
                sDataSet.removeLoadListener(this);
                CalcAggFieldsListener cafl = (CalcAggFieldsListener)this.innerCalcAggFieldsListeners.get(sDataSet);
                if (sDataSet.getCalcAggFieldsListener() == cafl && cafl != null) {
                    try {
                        sDataSet.removeCalcAggFieldsListener(cafl);
                        if (this.calcAggFieldsListeners.get(sDataSet) != null) {
                            sDataSet.addCalcAggFieldsListener((CalcAggFieldsListener)this.calcAggFieldsListeners.get(sDataSet));
                            this.calcAggFieldsListeners.remove(sDataSet);
                            this.innerCalcAggFieldsListeners.remove(sDataSet);
                        }
                    }
                    catch (Exception e3) {
                        this.out.println(Res.bundle.format(96, this.getEventLabel(), dataSetName));
                    }
                }
                cfl = (CalcFieldsListener)this.innerCalcFieldsListeners.get(sDataSet);
                if (sDataSet.getCalcFieldsListener() == cfl && cfl != null) {
                    try {
                        sDataSet.removeCalcFieldsListener(cfl);
                        if (this.calcFieldsListeners.get(sDataSet) != null) {
                            sDataSet.addCalcFieldsListener((CalcFieldsListener)this.calcFieldsListeners.get(sDataSet));
                            this.calcFieldsListeners.remove(sDataSet);
                            this.innerCalcFieldsListeners.remove(sDataSet);
                        }
                    }
                    catch (Exception e4) {
                        this.out.println(Res.bundle.format(97, this.getEventLabel(), dataSetName));
                    }
                }
                try {
                    sDataSet.removeEditListener(this);
                }
                catch (IllegalArgumentException e4) {
                    // empty catch block
                }
                Resolver resolver = sDataSet.getResolver();
                if (!(resolver instanceof SQLResolver)) continue;
                SQLResolver sqlResolver = (SQLResolver)resolver;
                ResolverListener rl = (ResolverListener)this.innerResolverListeners.get(sDataSet);
                if (sqlResolver.fetchResolverListener() != rl || rl == null) continue;
                try {
                    sqlResolver.removeResolverListener(rl);
                    if (this.resolverListeners.get(sDataSet) == null) continue;
                    sqlResolver.addResolverListener((ResolverListener)this.resolverListeners.get(sDataSet));
                    this.resolverListeners.remove(sDataSet);
                    this.innerResolverListeners.remove(sDataSet);
                    continue;
                }
                catch (Exception e5) {
                    this.out.println(Res.bundle.format(98, this.getEventLabel(), dataSetName));
                }
            }
        }
        this.dataSets = dataSets;
        if (dataSets != null) {
            for (index = 0; index < dataSets.length; ++index) {
                dataSet = dataSets[index];
                if (dataSet == null) continue;
                dataSetName = dataSet.getTableName();
                sDataSet = null;
                if (dataSet instanceof StorageDataSet) {
                    sDataSet = (StorageDataSet)dataSet;
                }
                dataSet.addAccessListener(this);
                dataSet.addDataChangeListener(this);
                dataSet.addNavigationListener(this);
                dataSet.addStatusListener(this);
                try {
                    dataSet.addOpenListener(this);
                    this.openListeners.put(dataSet, Boolean.TRUE);
                }
                catch (Exception e6) {
                    this.out.println(Res.bundle.format(99, this.getEventLabel(), dataSetName));
                    this.openListeners.put(dataSet, Boolean.FALSE);
                }
                try {
                    RowFilterListener rowFilterListener = dataSet.getRowFilterListener();
                    if (rowFilterListener != null) {
                        this.rowFilterListeners.put(dataSet, rowFilterListener);
                        dataSet.removeRowFilterListener(rowFilterListener);
                    }
                    InnerRowFilterListener rfl = new InnerRowFilterListener(dataSet);
                    this.innerRowFilterListeners.put(dataSet, rfl);
                    dataSet.addRowFilterListener(rfl);
                }
                catch (Exception e7) {
                    this.out.println(Res.bundle.format(100, this.getEventLabel(), dataSetName));
                }
                if (sDataSet == null) continue;
                sDataSet.addLoadListener(this);
                try {
                    CalcAggFieldsListener calcAggFieldsListener = sDataSet.getCalcAggFieldsListener();
                    if (calcAggFieldsListener != null) {
                        this.calcAggFieldsListeners.put(sDataSet, calcAggFieldsListener);
                        sDataSet.removeCalcAggFieldsListener(calcAggFieldsListener);
                        InnerCalcAggFieldsListener cafl = new InnerCalcAggFieldsListener(sDataSet);
                        this.innerCalcAggFieldsListeners.put(sDataSet, cafl);
                        sDataSet.addCalcAggFieldsListener(cafl);
                    }
                }
                catch (Exception e8) {
                    this.out.println(Res.bundle.format(101, this.getEventLabel(), dataSetName));
                }
                try {
                    CalcFieldsListener calcFieldsListener = sDataSet.getCalcFieldsListener();
                    if (calcFieldsListener != null) {
                        this.calcFieldsListeners.put(sDataSet, calcFieldsListener);
                        sDataSet.removeCalcFieldsListener(calcFieldsListener);
                        cfl = new InnerCalcFieldsListener(sDataSet);
                        this.innerCalcFieldsListeners.put(sDataSet, cfl);
                        sDataSet.addCalcFieldsListener(cfl);
                    }
                }
                catch (Exception e9) {
                    this.out.println(Res.bundle.format(102, this.getEventLabel(), dataSetName));
                }
                try {
                    sDataSet.addEditListener(this);
                }
                catch (Exception e10) {
                    this.out.println(Res.bundle.format(103, this.getEventLabel(), dataSetName));
                }
                try {
                    Resolver resolver = sDataSet.getResolver();
                    if (!(resolver instanceof SQLResolver)) continue;
                    SQLResolver sqlResolver = (SQLResolver)resolver;
                    ResolverListener resolverListener = sqlResolver.fetchResolverListener();
                    if (resolverListener != null) {
                        this.resolverListeners.put(sDataSet, resolverListener);
                        sqlResolver.removeResolverListener(resolverListener);
                    }
                    InnerResolverListener rl = new InnerResolverListener(sDataSet);
                    this.innerResolverListeners.put(sDataSet, rl);
                    sqlResolver.addResolverListener(rl);
                    continue;
                }
                catch (Exception e11) {
                    this.out.println(Res.bundle.format(104, this.getEventLabel(), dataSetName));
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (!this.enabled || !this.enableAccessListener) {
            return;
        }
        DataSet dataSet = (DataSet)event.getSource();
        String reason = "";
        String reasonDetail = "";
        switch (event.getID()) {
            case 1: {
                reason = Res.bundle.format(107, "AccessEvent.OPEN");
                switch (event.getReason()) {
                    case 1: {
                        reasonDetail = "AccessEvent.UNSPECIFIED";
                        break;
                    }
                    case 2: {
                        reasonDetail = "AccessEvent.DATA_CHANGE";
                        break;
                    }
                    case 3: {
                        reasonDetail = Res.bundle.format(109, "AccessEvent.COLUMN_ADD", event.getNewColumn().getColumnName());
                        break;
                    }
                    case 4: {
                        reasonDetail = Res.bundle.format(110, "AccessEvent.COLUMN_DROP", event.getDropColumn().getColumnName());
                        break;
                    }
                    case 5: {
                        reasonDetail = Res.bundle.format(111, "AccessEvent.COLUMN_CHANGE", event.getOldColumn().getColumnName(), event.getNewColumn().getColumnName());
                        break;
                    }
                    case 6: {
                        reasonDetail = Res.bundle.format(111, "AccessEvent.COLUMN_MOVE", new Integer(event.getOldOrdinal()), new Integer(event.getNewOrdinal()));
                    }
                }
                break;
            }
            case 2: {
                reason = Res.bundle.format(107, "AccessEvent.CLOSE");
                switch (event.getReason()) {
                    case 7: {
                        reasonDetail = "AccessEvent.UNKNOWN";
                        break;
                    }
                    case 8: {
                        reasonDetail = "AccessEvent.STRUCTURE_CHANGE";
                        break;
                    }
                    case 9: {
                        reasonDetail = "AccessEvent.PROPERTY_CHANGE";
                    }
                }
                break;
            }
            default: {
                reason = Res._UnknownReason;
            }
        }
        this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(" AccessListener.accessChange() ").append(reason).append(", ").append(reasonDetail))));
    }

    public void validate(DataSet dataSet, Column column, Variant value) throws DataSetException, Exception {
        if (this.enabled && this.enableColumnChangeListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" ColumnChangeListener.validate(dataSet: ").append(dataSet.getTableName()).append(", column: ").append(column).append(", value: ").append(value))));
        }
        if (this.columnChangeListeners.get(column) != null) {
            try {
                ((ColumnChangeListener)this.columnChangeListeners.get(column)).validate(dataSet, column, value);
            }
            catch (Exception e2) {
                this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(this.getEventLabel())).concat(" source: ColumnChangeListener.validate()"), e2));
                throw e2;
            }
        }
    }

    public void changed(DataSet dataSet, Column column, Variant value) throws DataSetException {
        if (this.enabled && this.enableColumnChangeListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" ColumnChangeListener.changed(dataSet: ").append(dataSet.getTableName()).append(", column: ").append(column).append(", value: ").append(value))));
        }
        if (this.columnChangeListeners.get(column) != null) {
            try {
                ((ColumnChangeListener)this.columnChangeListeners.get(column)).changed(dataSet, column, value);
            }
            catch (DataSetException e2) {
                this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(this.getEventLabel())).concat(" source: ColumnChangeListener.changed()"), e2));
                throw e2;
            }
        }
    }

    public void painting(DataSet dataSet, Column column, int row, Variant value, CustomPaintSite paintSite) {
        if (this.enabled && this.enableColumnPaintListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" ColumnPaintListener.painting(dataSet: ").append(dataSet.getTableName()).append(", column: ").append(column).append(", row: ").append(row).append(", value: ").append(value).append(", paintSite: ").append(paintSite))));
        }
        if (this.columnPaintListeners.get(column) != null) {
            ((ColumnPaintListener)this.columnPaintListeners.get(column)).painting(dataSet, column, row, value, paintSite);
        }
    }

    public void editing(DataSet dataSet, Column column, CustomPaintSite paintSite) {
        if (this.enabled && this.enableColumnPaintListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" ColumnPaintListener.editing(dataSet: ").append(dataSet.getTableName()).append(", column: ").append(column).append(", paintSite: ").append(paintSite).append(")"))));
        }
        if (this.columnPaintListeners.get(column) != null) {
            ((ColumnPaintListener)this.columnPaintListeners.get(column)).editing(dataSet, column, paintSite);
        }
    }

    public void dataChanged(DataChangeEvent event) {
        if (!this.enabled || !this.enableDataChangeListener) {
            return;
        }
        DataSet dataSet = (DataSet)event.getSource();
        this.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append("source: ").append(dataSet.getTableName()).append(" DataChangeListener.dataChanged: "))));
        switch (event.getID()) {
            case 1: {
                this.out.println("DataChangeEvent.ROW_ADDED, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
                break;
            }
            case 2: {
                this.out.println("DataChangeEvent.ROW_DELETED, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
                break;
            }
            case 3: {
                this.out.println("DataChangeEvent.ROW_CHANGED, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
                break;
            }
            case 4: {
                this.out.println("DataChangeEvent.ROW_CHANGE_POSTED, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
                break;
            }
            case 5: {
                if (event.getRowAffected() == -1) {
                    this.out.println(Res.bundle.format(116, "DataChangeEvent.DATA_CHANGED"));
                    break;
                }
                this.out.println("DataChangeEvent.DATA_CHANGED, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
                break;
            }
            case 6: {
                this.out.println("DataChangeEvent.POST_ROW, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
                break;
            }
            default: {
                this.out.println(Res._DataChangeEventUnknown);
            }
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
        if (!this.enabled || !this.enableDataChangeListener) {
            return;
        }
        DataSet dataSet = (DataSet)event.getSource();
        this.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(" DataChangeListener.postRow(): "))));
        if (event.getID() == 6) {
            this.out.println("DataChangeEvent.POST_ROW, rowAffected: ".concat(String.valueOf(String.valueOf(event.getRowAffected()))));
        } else {
            this.out.println(Res._DataChangeEventUnknown);
        }
    }

    public void canceling(DataSet dataSet) throws Exception {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.canceling(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void updating(DataSet dataSet, ReadWriteRow newRow, ReadRow oldRow) throws Exception {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.updating(dataSet: ").append(dataSet.getTableName()).append(", newRow: ").append(newRow).append(", oldRow: ").append(oldRow).append(")"))));
        }
    }

    public void updated(DataSet dataSet) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.updated(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void adding(DataSet dataSet, ReadWriteRow newRow) throws Exception {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.adding(dataSet: ").append(dataSet.getTableName()).append(", newRow: ").append(newRow).append(")"))));
        }
    }

    public void added(DataSet dataSet) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.added(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void deleting(DataSet dataSet) throws Exception {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.deleting(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void deleted(DataSet dataSet) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.deleted(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void modifying(DataSet dataSet) throws Exception {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.modifying(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void inserting(DataSet dataSet) throws Exception {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.inserting(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void inserted(DataSet dataSet) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.inserted(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void editError(DataSet dataSet, Column column, Variant value, DataSetException ex, ErrorResponse response) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.editError(dataSet: ").append(dataSet.getTableName()).append(", column: ").append(column).append(", value: ").append(value).append(", dataSetException: ").append(ex).append(", response: ErrorResponse.ABORT)"))));
        }
        response.abort();
    }

    public void addError(DataSet dataSet, ReadWriteRow row, DataSetException ex, ErrorResponse response) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append("] EditListener.addError(dataSet: ").append(dataSet.getTableName()).append(", row: ").append(row).append(", dataSetException: ").append(ex).append(", response: ErrorResponse.ABORT)"))));
        }
        response.abort();
    }

    public void updateError(DataSet dataSet, ReadWriteRow row, DataSetException ex, ErrorResponse response) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.updateError(dataSet: ").append(dataSet.getTableName()).append(", row: ").append(row).append(", dataSetException: ").append(ex).append(", response: ErrorResponse.ABORT)"))));
        }
        response.abort();
    }

    public void deleteError(DataSet dataSet, DataSetException ex, ErrorResponse response) throws DataSetException {
        if (this.enabled && this.enableEditListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" EditListener.deleteError(dataSet: ").append(dataSet.getTableName()).append(", dataSetException: ").append(ex).append(", response: ErrorResponse.ABORT)"))));
        }
        response.abort();
    }

    public void dataLoaded(LoadEvent event) {
        if (this.enableLoadListener) {
            DataSet dataSet = (DataSet)event.getSource();
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(" LoadListener.dataLoaded()"))));
        }
    }

    public void navigated(NavigationEvent event) {
        if (this.enableNavigationListener) {
            DataSet dataSet = (DataSet)event.getSource();
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(", NavigateListener.navigated()"))));
        }
    }

    public void opening(DataSet dataSet) throws DataSetException {
        if (this.enableOpenListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" OpenListener.opening(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void opened(DataSet dataSet) throws DataSetException {
        if (this.enableOpenListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" OpenListener.opened(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void closing(DataSet dataSet) throws DataSetException {
        if (this.enableOpenListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" OpenListener.closing(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void closed(DataSet dataSet) throws DataSetException {
        if (this.enableOpenListener) {
            this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" OpenListener.closed(dataSet: ").append(dataSet.getTableName()).append(")"))));
        }
    }

    public void statusMessage(StatusEvent event) {
        if (!this.enableStatusListener) {
            return;
        }
        DataSet dataSet = (DataSet)event.getSource();
        this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(" StatusListener.statusMessage: "))));
        switch (event.getCode()) {
            case 1: {
                this.out.println("StatusEvent.LOADING_DATA, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 2: {
                this.out.println("StatusEvent.LOCATE_USE_ENTER, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 3: {
                this.out.println("StatusEvent.LOCATE_MATCH_FOUND, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 4: {
                this.out.println("StatusEvent.LOCATE_MATCH_NOT_FOUND, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 5: {
                this.out.println("StatusEvent.LOCATE_USE_MIXED_CASE, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 6: {
                this.out.println("StatusEvent.LOCATE_STRING, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 7: {
                this.out.println("StatusEvent.LOCATE_NON_STRING, message: ".concat(String.valueOf(String.valueOf(event.getMessage()))));
                break;
            }
            case 8: {
                this.out.println("StatusEvent.DATA_CHANGE");
                break;
            }
            case 9: {
                this.out.println("StatusEvent.EXCEPTION");
                break;
            }
            case 10: {
                this.out.println("StatusEvent.CLEAR");
                break;
            }
            case 11: {
                this.out.println(Res.bundle.format(115, "StatusEvent.EDIT_STARTED", "StatusEvent.SORTING"));
                break;
            }
            case 12: {
                this.out.println(Res.bundle.format(115, "StatusEvent.EDIT_CANCELED", "StatusEvent.RESTRUCTURING"));
                break;
            }
            case 15: {
                this.out.println("StatusEvent.CHECKING_DATASTORE");
                break;
            }
            default: {
                this.out.println(Res._StatusUnknown);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnableAccessListener(boolean enableAccessListener) {
        this.enableAccessListener = enableAccessListener;
    }

    public boolean isEnableAccessListener() {
        return this.enableAccessListener;
    }

    public void setEnableCalcAggFieldsListener(boolean enableCalcAggFieldsListener) {
        this.enableCalcAggFieldsListener = enableCalcAggFieldsListener;
    }

    public boolean isEnableCalcAggFieldsListener() {
        return this.enableCalcAggFieldsListener;
    }

    public void setEnableCalcFieldsListener(boolean enableCalcFieldsListener) {
        this.enableCalcFieldsListener = enableCalcFieldsListener;
    }

    public boolean isEnableCalcFieldsListener() {
        return this.enableCalcFieldsListener;
    }

    public void setEnableColumnChangeListener(boolean enableColumnChangeListener) {
        this.enableColumnChangeListener = enableColumnChangeListener;
    }

    public boolean isEnableColumnChangeListener() {
        return this.enableColumnChangeListener;
    }

    public void setEnableColumnPaintListener(boolean enableColumnPaintListener) {
        this.enableColumnPaintListener = enableColumnPaintListener;
    }

    public boolean isEnableColumnPaintListener() {
        return this.enableColumnPaintListener;
    }

    public void setEnableDataChangeListener(boolean enableDataChangeListener) {
        this.enableDataChangeListener = enableDataChangeListener;
    }

    public boolean isEnableDataChangeListener() {
        return this.enableDataChangeListener;
    }

    public void setEnableEditListener(boolean enableEditListener) {
        this.enableEditListener = enableEditListener;
    }

    public boolean isEnableEditListener() {
        return this.enableEditListener;
    }

    public void setEnableLoadListener(boolean enableLoadListener) {
        this.enableLoadListener = enableLoadListener;
    }

    public boolean isEnableLoadListener() {
        return this.enableLoadListener;
    }

    public void setEnableNavigationListener(boolean enableNavigationListener) {
        this.enableNavigationListener = enableNavigationListener;
    }

    public boolean isEnableNavigationListener() {
        return this.enableNavigationListener;
    }

    public void setEnableOpenListener(boolean enableOpenListener) {
        this.enableOpenListener = enableOpenListener;
    }

    public boolean isEnableOpenListener() {
        return this.enableOpenListener;
    }

    public void setEnableResolverListener(boolean enableResolverListener) {
        this.enableResolverListener = enableResolverListener;
    }

    public boolean isEnableResolverListener() {
        return this.enableResolverListener;
    }

    public void setEnableRowFilterListener(boolean enableRowFilterListener) {
        this.enableRowFilterListener = enableRowFilterListener;
    }

    public boolean isEnableRowFilterListener() {
        return this.enableRowFilterListener;
    }

    public void setEnableStatusListener(boolean enableStatusListener) {
        this.enableStatusListener = enableStatusListener;
    }

    public boolean isEnableStatusListener() {
        return this.enableStatusListener;
    }

    private String getEventLabel() {
        return String.valueOf(String.valueOf(new StringBuffer("DBEventMonitor[").append(new Date()).append("]")));
    }

    class InnerRowFilterListener
    implements RowFilterListener {
        DataSet dataSet;

        public InnerRowFilterListener(DataSet source) {
            this.dataSet = source;
        }

        public void filterRow(ReadRow row, RowFilterResponse response) throws DataSetException {
            if (DBEventMonitor.this.rowFilterListeners.get(this.dataSet) != null) {
                try {
                    ((RowFilterListener)DBEventMonitor.this.rowFilterListeners.get(this.dataSet)).filterRow(row, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.filterRow()"))), e2));
                    throw e2;
                }
            } else {
                response.add();
            }
            if (DBEventMonitor.this.enableRowFilterListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", RowFilterListener.filterRow(row: ").append(row).append(", response.").append(response.canAdd() ? "add" : "ignore").append("())"))));
            }
        }
    }

    class InnerResolverListener
    implements ResolverListener {
        DataSet dataSet;

        public InnerResolverListener(DataSet source) {
            this.dataSet = source;
        }

        public void insertingRow(ReadWriteRow row, ResolverResponse response) throws DataSetException {
            if (DBEventMonitor.this.resolverListeners.get(this.dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(this.dataSet)).insertingRow(row, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.insertingRow()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.insertingRow(row: ").append(row).append(", response.").append(response.isResolve() ? "isResolver" : (response.isSkip() ? "isSkip" : "isAbort")).append("())"))));
            }
        }

        public void deletingRow(ReadWriteRow row, ResolverResponse response) throws DataSetException {
            if (DBEventMonitor.this.resolverListeners.get(this.dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(this.dataSet)).deletingRow(row, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.deletingRow()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.deletingRow(row: ").append(row).append(", response.").append(response.isResolve() ? "isResolver" : (response.isSkip() ? "isSkip" : "isAbort")).append("())"))));
            }
        }

        public void updatingRow(ReadWriteRow row, ReadRow oldRow, ResolverResponse response) throws DataSetException {
            if (DBEventMonitor.this.resolverListeners.get(this.dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(this.dataSet)).updatingRow(row, oldRow, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.updatingRow()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.updatingRow(row: ").append(row).append(", oldRow: ").append(oldRow).append(", response.").append(response.isResolve() ? "isResolver" : (response.isSkip() ? "isSkip" : "isAbort")).append("())"))));
            }
        }

        public void insertedRow(ReadWriteRow row) throws DataSetException {
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.insertedRow(row: ").append(row))));
            }
            if (DBEventMonitor.this.resolverListeners.get(this.dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(this.dataSet)).insertedRow(row);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.insertedRow()"))), e2));
                    throw e2;
                }
            }
        }

        public void deletedRow(ReadWriteRow row) throws DataSetException {
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.deletedRow(row: ").append(row))));
            }
            if (DBEventMonitor.this.resolverListeners.get(this.dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(this.dataSet)).deletedRow(row);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.deletingRow()"))), e2));
                    throw e2;
                }
            }
        }

        public void updatedRow(ReadWriteRow row, ReadRow oldRow) throws DataSetException {
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.updatedRow(row: ").append(row).append(", oldRow: ").append(oldRow))));
            }
            if (DBEventMonitor.this.resolverListeners.get(this.dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(this.dataSet)).updatedRow(row, oldRow);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.updatedRow()"))), e2));
                    throw e2;
                }
            }
        }

        public void insertError(DataSet dataSet, ReadWriteRow row, DataSetException ex, ErrorResponse response) throws DataSetException {
            if (DBEventMonitor.this.resolverListeners.get(dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(dataSet)).insertError(dataSet, row, ex, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(113, new Object[]{String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel())).concat(" source: "), dataSet.getTableName(), "ResolverListener.insertError()", e2}));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.insertError(dataSet: ").append(dataSet.getTableName()).append(", row: ").append(row).append(", exception: ").append(ex).append(", response.").append(response.isAbort() ? "isAbort" : (response.isIgnore() ? "isIgnore" : "isRetry")).append("())"))));
            }
        }

        public void deleteError(DataSet dataSet, ReadWriteRow row, DataSetException ex, ErrorResponse response) throws DataSetException {
            if (DBEventMonitor.this.resolverListeners.get(dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(dataSet)).deleteError(dataSet, row, ex, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(", ResolverListener.deleteError()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.deleteError(dataSet: ").append(dataSet.getTableName()).append(", row: ").append(row).append(", exception: ").append(ex).append(", response.").append(response.isAbort() ? "isAbort" : (response.isIgnore() ? "isIgnore" : "isRetry")).append("())"))));
            }
        }

        public void updateError(DataSet dataSet, ReadWriteRow row, ReadRow oldRow, ReadWriteRow updRow, DataSetException ex, ErrorResponse response) throws DataSetException {
            if (DBEventMonitor.this.resolverListeners.get(dataSet) != null) {
                try {
                    ((ResolverListener)DBEventMonitor.this.resolverListeners.get(dataSet)).updateError(dataSet, row, oldRow, updRow, ex, response);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(dataSet.getTableName()).append(", ResolverListener.updatedError()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enableResolverListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", ResolverListener.updateError(dataSet: ").append(dataSet).append(", row: ").append(row).append(", oldRow: ").append(oldRow).append(", updateRow: ").append(updRow).append(", exception: ").append(ex).append(", response.").append(response.isAbort() ? "isAbort" : (response.isIgnore() ? "isIgnore" : "isRetry")).append("())"))));
            }
        }
    }

    class InnerCalcFieldsListener
    implements CalcFieldsListener {
        DataSet dataSet;

        public InnerCalcFieldsListener(DataSet source) {
            this.dataSet = source;
        }

        public void calcFields(ReadRow changedRow, DataRow calcRow, boolean isPosted) throws DataSetException {
            if (DBEventMonitor.this.enabled && DBEventMonitor.this.enableCalcFieldsListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", CalcFieldsListener.calcFields(changedRow: ").append(changedRow).append(", calcRow: ").append(calcRow).append(", isPosted: ").append(isPosted))));
            }
            if (DBEventMonitor.this.calcFieldsListeners.get(this.dataSet) != null) {
                try {
                    ((CalcFieldsListener)DBEventMonitor.this.calcFieldsListeners.get(this.dataSet)).calcFields(changedRow, calcRow, isPosted);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", CalcFieldsListener.calcFields()"))), e2));
                    throw e2;
                }
            }
        }
    }

    class InnerCalcAggFieldsListener
    implements CalcAggFieldsListener {
        DataSet dataSet;

        public InnerCalcAggFieldsListener(DataSet source) {
            this.dataSet = source;
        }

        public void calcAggAdd(ReadRow row, ReadWriteRow resultRow) throws DataSetException {
            if (DBEventMonitor.this.calcAggFieldsListeners.get(this.dataSet) != null) {
                try {
                    ((CalcAggFieldsListener)DBEventMonitor.this.calcAggFieldsListeners.get(this.dataSet)).calcAggAdd(row, resultRow);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", CalcAggFieldsListener.calcAggAdd()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enabled && DBEventMonitor.this.enableCalcAggFieldsListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", CalcAggFieldsListener.calcAggAdd(row: ").append(row).append(", resultRow: ").append(resultRow).append(")"))));
            }
        }

        public void calcAggDelete(ReadRow row, ReadWriteRow resultRow) throws DataSetException {
            if (DBEventMonitor.this.calcAggFieldsListeners.get(this.dataSet) != null) {
                try {
                    ((CalcAggFieldsListener)DBEventMonitor.this.calcAggFieldsListeners.get(this.dataSet)).calcAggDelete(row, resultRow);
                }
                catch (DataSetException e2) {
                    DBEventMonitor.this.out.println(Res.bundle.format(106, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", CalcAggFieldsListener.calcAggDelete()"))), e2));
                    throw e2;
                }
            }
            if (DBEventMonitor.this.enabled && DBEventMonitor.this.enableCalcAggFieldsListener) {
                DBEventMonitor.this.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(DBEventMonitor.this.getEventLabel()))).append(" source: ").append(this.dataSet.getTableName()).append(", CalcAggFieldsListener.calcAggDelete(row: ").append(row).append(", resultRow: ").append(resultRow).append(")"))));
            }
        }
    }
}

