/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.JdbTextArea;
import com.borland.dbswing.JdbToggleButton;
import com.borland.dbswing.RepeatButton;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Store;
import com.borland.dx.sql.dataset.Database;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.jb.util.ChainedException;
import com.borland.jb.util.ExceptionChain;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class DBExceptionDialog
extends JDialog
implements ActionListener,
KeyListener {
    private transient Vector exceptionVector = new Vector();
    private int exceptionPosition;
    private static int showCount;
    private transient Component returnFocusComponent;
    private boolean displayChains = true;
    private boolean enableStackTrace = true;
    private boolean allowExit = true;
    private boolean closeDataStores = true;
    private boolean closeConnections = true;
    private static boolean enableSecretKey;
    private boolean hiddenToggleState = false;
    private boolean hiddenChains;
    private boolean hiddenStack;
    private boolean hiddenExit;
    private RepeatButton okButton;
    private RepeatButton nextButton;
    private RepeatButton prevButton;
    private JdbToggleButton stackButton;
    private RepeatButton exitButton;
    private JdbTextArea messageArea = new JdbTextArea(this){

        public boolean isFocusTraversable() {
            return this.isEnablePopupMenu();
        }
    };
    private int messageAreaWidth;
    private int widestMessageLength = this.messageAreaWidth = 50;
    private JPanel buttonOuterPanel = new JPanel();
    private GridLayout buttonGridLayout = new GridLayout();
    private JPanel buttonPanel = new JPanel();
    private JLabel iconLabel = new JLabel();
    private Frame frame;
    private Icon messageIcon = UIManager.getIcon("OptionPane.informationIcon");
    private boolean dialogExpanded = false;
    private Dimension initialPackedSize;
    private JScrollPane pane;

    public DBExceptionDialog(Frame frame, String title, Throwable ex) {
        this(frame, title, ex, false);
    }

    public DBExceptionDialog(Frame frame, String title, Throwable ex, Component c2) {
        this(frame, title, ex, false);
        this.returnFocusComponent = c2;
    }

    public DBExceptionDialog(Frame frame, String title, Throwable ex, boolean modal, Component c2) {
        this(frame, title, ex, modal);
        this.returnFocusComponent = c2;
    }

    public DBExceptionDialog(Frame frame, String title, Throwable exception, boolean modal) {
        super(frame, title, modal);
        this.makeExceptionList(exception);
        this.frame = frame;
    }

    public void addNotify() {
        super.addNotify();
        if (UIManager.getLookAndFeel().getID().equals("Motif")) {
            this.okButton.setBorder(this.stackButton.getBorder());
            this.prevButton.setBorder(this.stackButton.getBorder());
            this.nextButton.setBorder(this.stackButton.getBorder());
            this.exitButton.setBorder(this.stackButton.getBorder());
        }
    }

    public void show() {
        Throwable exception = (Throwable)this.exceptionVector.elementAt(0);
        String messageString = exception.getMessage();
        if (messageString == null || messageString.length() < 1) {
            messageString = exception.getClass().getName();
        }
        this.messageArea.setRows(this.widestMessageLength / this.messageAreaWidth + 2);
        this.messageArea.setColumns(this.messageAreaWidth);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setText(messageString);
        this.messageArea.setEditable(false);
        this.messageArea.getCaret().setSelectionVisible(false);
        this.messageArea.setBackground(UIManager.getColor("OptionPane.background"));
        this.messageArea.setForeground(UIManager.getColor("OptionPane.foreground"));
        this.messageArea.setFont(this.getFont());
        this.messageArea.setEnablePopupMenu(false);
        this.pane = new JScrollPane(this.messageArea);
        this.pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.pane, "Center");
        if (this.messageIcon != null) {
            this.iconLabel.setIcon(this.messageIcon);
        }
        this.iconLabel.setVerticalAlignment(1);
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.iconLabel, "West");
        this.okButton = new RepeatButton(Res._OKBtn);
        this.okButton.setRepeat(false);
        this.okButton.addActionListener(this);
        this.okButton.setDefaultButton(true);
        this.buttonPanel.add(this.okButton);
        this.prevButton = new RepeatButton(Res._PrevBtn);
        this.prevButton.setRepeat(false);
        this.prevButton.setToolTipText(Res._PrevTip);
        this.prevButton.addActionListener(this);
        this.nextButton = new RepeatButton(Res._NextBtn);
        this.nextButton.setRepeat(false);
        this.nextButton.setToolTipText(Res._NextTip);
        this.nextButton.addActionListener(this);
        this.stackButton = new JdbToggleButton(Res._StackBtn);
        this.stackButton.setToolTipText(Res._StackTip);
        this.stackButton.addActionListener(this);
        this.exitButton = new RepeatButton(Res._ExitBtn);
        this.exitButton.setRepeat(false);
        this.exitButton.setToolTipText(Res._ExitTip);
        this.exitButton.addActionListener(this);
        if (enableSecretKey) {
            this.addKeyListener(this);
        } else {
            this.removeKeyListener(this);
        }
        this.updateButtons();
        this.buttonGridLayout.setRows(1);
        this.buttonGridLayout.setHgap(5);
        this.buttonPanel.setLayout(this.buttonGridLayout);
        this.buttonOuterPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)this.buttonOuterPanel, "South");
        this.setBackground(UIManager.getColor("OptionPane.background"));
        this.setForeground(UIManager.getColor("OptionPane.foreground"));
        this.buttonPanel.invalidate();
        this.pack();
        this.initialPackedSize = this.getSize();
        this.setLocationRelativeTo(this.frame);
        ++showCount;
        super.show();
    }

    void updateButtons() {
        int buttonCount = 1;
        if (this.prevButton.getParent() == this.buttonPanel) {
            this.buttonPanel.remove(this.prevButton);
        }
        if (this.nextButton.getParent() == this.buttonPanel) {
            this.buttonPanel.remove(this.nextButton);
        }
        if (this.stackButton.getParent() == this.buttonPanel) {
            this.buttonPanel.remove(this.stackButton);
        }
        if (this.exitButton.getParent() == this.buttonPanel) {
            this.buttonPanel.remove(this.exitButton);
        }
        Throwable exception = (Throwable)this.exceptionVector.elementAt(this.exceptionPosition);
        if (this.displayChains && exception instanceof ChainedException && ((ChainedException)((Object)exception)).getExceptionChain() != null) {
            this.prevButton.setEnabled(this.exceptionPosition > 0);
            this.buttonPanel.add(this.prevButton);
            ++buttonCount;
            this.nextButton.setEnabled(this.exceptionPosition < this.exceptionVector.size() - 1);
            this.buttonPanel.add(this.nextButton);
            ++buttonCount;
        }
        if (this.enableStackTrace) {
            this.buttonPanel.add(this.stackButton);
            ++buttonCount;
        }
        if (this.allowExit) {
            this.buttonPanel.add(this.exitButton);
            ++buttonCount;
        }
        this.buttonGridLayout.setColumns(buttonCount);
        this.buttonPanel.invalidate();
        this.pack();
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.exitButton) {
            if (this.closeDataStores || this.closeConnections) {
                Frame[] frames = Frame.getFrames();
                for (int i2 = 0; i2 < frames.length; ++i2) {
                    DataSetAware dataSetAware;
                    DataSetAware[] dataSetAwares = DBUtilities.findDataAwareChildren(frames[i2]);
                    for (int j2 = 0; j2 < dataSetAwares.length; ++j2) {
                        dataSetAware = dataSetAwares[j2];
                        this.close(dataSetAware);
                    }
                    Window[] windows = frames[i2].getOwnedWindows();
                    for (int j3 = 0; j3 < windows.length; ++j3) {
                        dataSetAwares = DBUtilities.findDataAwareChildren(windows[j3]);
                        for (int k2 = 0; k2 < dataSetAwares.length; ++k2) {
                            dataSetAware = dataSetAwares[k2];
                            this.close(dataSetAware);
                        }
                    }
                }
            }
            this.dispose();
            System.exit(0);
        } else if (e2.getSource() == this.okButton) {
            --showCount;
            this.dispose();
            if (this.returnFocusComponent != null) {
                this.returnFocusComponent.requestFocus();
                this.returnFocusComponent = null;
            }
        } else if (e2.getSource() == this.nextButton) {
            if (this.exceptionPosition < this.exceptionVector.size() - 1) {
                this.displayException(++this.exceptionPosition);
            }
        } else if (e2.getSource() == this.prevButton) {
            if (this.exceptionPosition > 0) {
                this.displayException(--this.exceptionPosition);
            }
        } else if (e2.getSource() == this.stackButton) {
            this.displayException(this.exceptionPosition);
            if (!this.dialogExpanded) {
                this.dialogExpanded = true;
                this.pack();
            }
        }
    }

    private void close(DataSetAware dataSetAware) {
        block4: {
            DataSet dataSet = dataSetAware.getDataSet();
            if (dataSet == null) break block4;
            try {
                Database database;
                Method isOpenMethod;
                boolean isOpen;
                Store store;
                if (this.closeDataStores && dataSet.getStorageDataSet() instanceof StorageDataSet && (store = dataSet.getStorageDataSet().getStore()) != null && store.getClass().getName().equals("com.borland.datastore.DataStore") && (isOpen = ((Boolean)(isOpenMethod = store.getClass().getMethod("isOpen", null)).invoke((Object)store, null)).booleanValue())) {
                    Method closeMethod = store.getClass().getMethod("close", null);
                    closeMethod.invoke((Object)store, null);
                }
                if (this.closeConnections && dataSet != null && dataSet.getStorageDataSet() instanceof QueryDataSet && (database = ((QueryDataSet)dataSet.getStorageDataSet()).getDatabase()) != null && database.isOpen()) {
                    database.closeConnection();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        if (e2.getKeyCode() == 68 && e2.isControlDown() && e2.isAltDown() && e2.isShiftDown()) {
            if (!this.hiddenToggleState) {
                this.hiddenChains = this.isDisplayChainedExceptions();
                this.hiddenStack = this.isDisplayStackTraces();
                this.hiddenExit = this.isAllowExit();
                this.setDisplayChainedExceptions(true);
                this.setDisplayStackTraces(true);
                this.setAllowExit(true);
            } else {
                this.setDisplayChainedExceptions(this.hiddenChains);
                this.setDisplayStackTraces(this.hiddenStack);
                this.setAllowExit(this.hiddenExit);
            }
            this.hiddenToggleState = !this.hiddenToggleState;
            this.updateButtons();
        }
    }

    private void displayException(int pos) {
        if (this.displayChains) {
            this.prevButton.setEnabled(pos > 0);
            this.nextButton.setEnabled(pos < this.exceptionVector.size() - 1);
        }
        Throwable ex = (Throwable)this.exceptionVector.elementAt(pos);
        if (this.stackButton.isSelected()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
            PrintStream printStream = new PrintStream(byteStream);
            ex.printStackTrace(printStream);
            printStream.flush();
            this.messageArea.setLineWrap(false);
            this.messageArea.getCaret().setSelectionVisible(true);
            this.messageArea.setText(byteStream.toString());
            if (this.getSize().equals(this.initialPackedSize)) {
                this.messageArea.setRows(10);
            } else {
                this.dialogExpanded = true;
            }
            this.messageArea.setBackground(UIManager.getColor("TextArea.background"));
            this.messageArea.setForeground(UIManager.getColor("TextArea.foreground"));
            this.messageArea.setCaretPosition(0);
            this.messageArea.setEnablePopupMenu(true);
            this.pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLoweredBevelBorder()));
            this.iconLabel.setIcon(null);
        } else {
            String messageString = ex.getMessage();
            if (messageString == null || messageString.length() < 1) {
                messageString = ex.getClass().getName();
            }
            this.messageArea.setRows(this.widestMessageLength / this.messageAreaWidth + 2);
            this.messageArea.setColumns(this.messageAreaWidth);
            this.messageArea.setLineWrap(true);
            this.messageArea.getCaret().setSelectionVisible(false);
            this.messageArea.setText(messageString);
            this.messageArea.setBackground(UIManager.getColor("OptionPane.background"));
            this.messageArea.setForeground(UIManager.getColor("OptionPane.foreground"));
            if (this.messageIcon != null) {
                this.iconLabel.setIcon(this.messageIcon);
            }
            this.pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.messageArea.setEnablePopupMenu(false);
        }
    }

    private void makeExceptionList(Throwable ex) {
        this.exceptionVector.addElement(ex);
        int length = this.widestMessageLength;
        String msg = ex.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        if ((length = msg.length()) > this.widestMessageLength) {
            this.widestMessageLength = length;
        }
        if (ex instanceof ChainedException) {
            for (ExceptionChain chain = ((ChainedException)((Object)ex)).getExceptionChain(); chain != null; chain = chain.getNext()) {
                ex = chain.getException();
                if (this.isDisplayChainedExceptions()) {
                    msg = ex.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = ex.getClass().getName();
                    }
                    if ((length = msg.length()) > this.widestMessageLength) {
                        this.widestMessageLength = length;
                    }
                }
                this.exceptionVector.addElement(ex);
            }
        }
        this.exceptionPosition = 0;
    }

    public static int getShowCount() {
        return showCount;
    }

    public void setMessageIcon(Icon messageIcon) {
        this.messageIcon = messageIcon;
    }

    public Icon getMessageIcon() {
        return this.messageIcon;
    }

    public void setDisplayChainedExceptions(boolean displayChains) {
        this.displayChains = displayChains;
    }

    public boolean isDisplayChainedExceptions() {
        return this.displayChains;
    }

    public void setDisplayStackTraces(boolean enableStackTrace) {
        this.enableStackTrace = enableStackTrace;
    }

    public boolean isDisplayStackTraces() {
        return this.enableStackTrace;
    }

    public void setAllowExit(boolean allowExit) {
        this.allowExit = allowExit;
    }

    public boolean isAllowExit() {
        return this.allowExit;
    }

    public void setCloseDataStoresOnExit(boolean closeDataStores) {
        this.closeDataStores = closeDataStores;
    }

    public boolean isCloseDataStoresOnExit() {
        return this.closeDataStores;
    }

    public void setCloseConnectionsOnExit(boolean closeConnections) {
        this.closeConnections = closeConnections;
    }

    public boolean isCloseConnectionsOnExit() {
        return this.closeConnections;
    }

    public void setEnableSecretDebugKey(boolean enableSecretKey) {
        DBExceptionDialog.enableSecretKey = enableSecretKey;
    }

    public boolean isEnableSecretDebugKey() {
        return enableSecretKey;
    }

    static {
        enableSecretKey = true;
    }
}

