/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.JdbLabel;
import com.borland.dbswing.Platform;
import com.borland.dbswing.RepeatButton;
import com.borland.dbswing.Res;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DBPasswordDialog
extends JDialog
implements ActionListener,
FocusListener,
KeyListener {
    JPanel panel1 = new JPanel();
    JTextField userNameField = new JTextField();
    JdbLabel userNameLabel = new JdbLabel();
    JdbLabel passwordLabel = new JdbLabel();
    JPasswordField passwordField = new JPasswordField();
    RepeatButton okButton = new RepeatButton();
    RepeatButton cancelButton = new RepeatButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel buttonPanel = new JPanel();
    private boolean firstFocus = true;
    private boolean okPressed = false;
    private boolean autoDispose = true;
    private boolean userNameRequired = true;
    private boolean passwordRequired = true;

    public DBPasswordDialog(Frame frame, String title) {
        super((Frame)null, title, true);
        this.init();
    }

    public DBPasswordDialog(String title, Frame frame) {
        super(frame, title, true);
        this.init();
    }

    public DBPasswordDialog(Dialog dialog, String title) {
        super(dialog, title, true);
        this.init();
    }

    public DBPasswordDialog(String title) {
        this((Frame)null, title);
    }

    public DBPasswordDialog() {
        super((Frame)null, (String)null, true);
        this.init();
    }

    void init() {
        try {
            this.jbInit();
            this.pack();
            this.setDefaultCloseOperation(2);
            this.userNameField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e2) {
                    DBPasswordDialog.this.updateButtons();
                }

                public void insertUpdate(DocumentEvent e2) {
                    DBPasswordDialog.this.updateButtons();
                }

                public void removeUpdate(DocumentEvent e2) {
                    DBPasswordDialog.this.updateButtons();
                }
            });
            this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e2) {
                    DBPasswordDialog.this.updateButtons();
                }

                public void insertUpdate(DocumentEvent e2) {
                    DBPasswordDialog.this.updateButtons();
                }

                public void removeUpdate(DocumentEvent e2) {
                    DBPasswordDialog.this.updateButtons();
                }
            });
        }
        catch (Exception ex) {
            DBExceptionHandler.handleException(ex);
        }
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.userNameLabel.setTextWithMnemonic(Res._UserName);
        this.userNameLabel.setLabelFor(this.userNameField);
        this.userNameField.setColumns(30);
        this.userNameField.addFocusListener(this);
        this.userNameField.addKeyListener(this);
        this.userNameField.requestDefaultFocus();
        this.passwordLabel.setTextWithMnemonic(Res._Password);
        this.passwordLabel.setLabelFor(this.passwordField);
        this.passwordField.setColumns(30);
        this.passwordField.addActionListener(this);
        this.okButton.setEnabled(false);
        this.okButton.setRepeat(false);
        this.okButton.setTextWithMnemonic(Res._OKBtn);
        this.okButton.addActionListener(this);
        this.cancelButton.setTextWithMnemonic(Res._CancelBtn);
        this.cancelButton.setRepeat(false);
        this.cancelButton.setDefaultButton(true);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.panel1.add((Component)this.userNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.userNameField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.panel1.add((Component)this.passwordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.passwordField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(8, 4, 0, 0), 0, 0));
        this.panel1.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        GridBagConstraints firstButton = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints secondButton = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0);
        this.buttonPanel.add((Component)this.okButton, Platform.isMacLAF() ? secondButton : firstButton);
        this.buttonPanel.add((Component)this.cancelButton, Platform.isMacLAF() ? firstButton : secondButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                DBPasswordDialog.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.userNameField || e2.getSource() == this.passwordField) {
            if (this.okButton.isEnabled()) {
                this.okButton.doClick();
            } else {
                this.cancelButton.doClick();
            }
        } else if (e2.getSource() == this.okButton || e2.getSource() == this.cancelButton) {
            boolean bl = this.okPressed = e2.getSource() == this.okButton;
            if (this.autoDispose) {
                this.dispose();
            }
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 10 && this.passwordRequired) {
            FocusManager.getCurrentManager().focusNextComponent(this.userNameField);
            e2.consume();
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void focusGained(FocusEvent e2) {
        if (this.firstFocus && this.userNameField.getText().length() > 0) {
            this.firstFocus = false;
            this.passwordField.requestFocus();
        }
    }

    public void focusLost(FocusEvent e2) {
    }

    void updateButtons() {
        boolean okState;
        boolean bl = okState = !(this.userNameRequired && this.userNameField.getText().length() <= 0 || this.passwordRequired && this.passwordField.getPassword().length <= 0);
        if (this.userNameRequired || this.passwordRequired) {
            if (okState != this.okButton.isEnabled()) {
                this.okButton.setEnabled(okState);
            }
        } else {
            this.okButton.setEnabled(true);
        }
        if (okState) {
            this.cancelButton.setDefaultButton(false);
            this.okButton.setDefaultButton(true);
        } else {
            this.okButton.setDefaultButton(false);
            this.cancelButton.setDefaultButton(true);
        }
    }

    public void setUserName(String userName) {
        this.userNameField.setText(userName);
        this.updateButtons();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public void setPassword(String password) {
        this.passwordField.setText(password);
        this.updateButtons();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setUserNameRequired(boolean userNameRequired) {
        this.userNameRequired = userNameRequired;
        this.updateButtons();
    }

    public boolean isUserNameRequired() {
        return this.userNameRequired;
    }

    public void setPasswordRequired(boolean passwordRequired) {
        this.passwordRequired = passwordRequired;
        this.updateButtons();
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }
}

