/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import javax.swing.table.AbstractTableModel;

public class DBTableModel
extends AbstractTableModel
implements DataChangeListener,
AccessListener,
DataSetAware,
Designable {
    DataSet dataSet;
    private Variant value = new Variant();
    private int columnCount;
    private String[] captionNames;
    private Class[] columnClasses;
    private int[] lookupTypes;
    private boolean[] isEditable;
    private int[] columnMap;
    private boolean propertyChange;
    private boolean dataSetEventsEnabled = true;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public DBTableModel() {
        this(null);
    }

    public DBTableModel(DataSet dataSet) {
        this.setDataSet(dataSet);
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != dataSet) {
            if (this.dataSet != null) {
                this.dataSet.removeAccessListener(this);
                this.dataSet.removeDataChangeListener(this);
            }
            this.dataSet = dataSet;
            if (dataSet != null) {
                dataSet.addAccessListener(this);
                dataSet.addDataChangeListener(this);
            }
            this.updateModel();
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void updateModel() {
        if (this.isValidDataSetState()) {
            try {
                int totalColumns = this.dataSet.getColumnCount();
                this.captionNames = new String[totalColumns];
                this.columnClasses = new Class[totalColumns];
                this.lookupTypes = new int[totalColumns];
                this.isEditable = new boolean[totalColumns];
                this.columnMap = new int[totalColumns];
                this.columnCount = 0;
                for (int colNo = 0; colNo < totalColumns; ++colNo) {
                    Column column = this.dataSet.getColumn(colNo);
                    if (!this.dataSet.columnIsVisible(column.getColumnName())) continue;
                    this.captionNames[this.columnCount] = column.getCaption();
                    this.isEditable[this.columnCount] = column.isEditable() && !column.isReadOnly() && this.dataSet.isEditable();
                    this.lookupTypes[this.columnCount] = -1;
                    PickListDescriptor pickListDescriptor = column.getPickList();
                    if (pickListDescriptor == null) {
                        this.columnClasses[this.columnCount] = DBTableModel.getJavaClass(column.getDataType());
                    } else {
                        DataSet pickListDataSet = pickListDescriptor.getPickListDataSet();
                        if (pickListDataSet == null) continue;
                        String lookupColumnName = pickListDescriptor.getLookupDisplayColumn();
                        if (lookupColumnName == null) {
                            this.columnClasses[this.columnCount] = DBTableModel.getJavaClass(column.getDataType());
                        } else {
                            Column lookupColumn = pickListDataSet.hasColumn(lookupColumnName);
                            if (lookupColumn == null) continue;
                            this.columnClasses[this.columnCount] = DBTableModel.getJavaClass(lookupColumn.getDataType());
                            this.lookupTypes[this.columnCount] = lookupColumn.getDataType();
                        }
                    }
                    this.columnMap[this.columnCount] = colNo;
                    ++this.columnCount;
                }
            }
            catch (DataSetException e2) {
                this.handleException(e2);
                return;
            }
        }
    }

    static Class getJavaClass(int variantType) {
        switch (variantType) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = DBTableModel.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            case 3: {
                return class$java$lang$Short == null ? (class$java$lang$Short = DBTableModel.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DBTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = DBTableModel.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 6: {
                return class$java$lang$Float == null ? (class$java$lang$Float = DBTableModel.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 7: {
                return class$java$lang$Double == null ? (class$java$lang$Double = DBTableModel.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 10: {
                return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DBTableModel.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
            }
            case 11: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DBTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case 12: {
                return class$java$lang$Object == null ? (class$java$lang$Object = DBTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            case 13: {
                return class$java$sql$Date == null ? (class$java$sql$Date = DBTableModel.class$("java.sql.Date")) : class$java$sql$Date;
            }
            case 14: {
                return class$java$sql$Time == null ? (class$java$sql$Time = DBTableModel.class$("java.sql.Time")) : class$java$sql$Time;
            }
            case 15: {
                return class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DBTableModel.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
            }
            case 16: {
                return class$java$lang$String == null ? (class$java$lang$String = DBTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 17: {
                return class$java$lang$Object == null ? (class$java$lang$Object = DBTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            case 18: {
                return class$java$lang$Object == null ? (class$java$lang$Object = DBTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
        }
        return null;
    }

    protected boolean isValidDataSetState() {
        return this.dataSet != null && this.dataSet.isOpen();
    }

    public int getRowCount() {
        if (this.isValidDataSetState()) {
            try {
                int n2 = this.dataSet.getRowCount();
                return n2;
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return 0;
    }

    public int getColumnCount() {
        if (this.isValidDataSetState()) {
            return this.columnCount;
        }
        return 0;
    }

    public String getColumnName(int columnIndex) {
        if (this.isValidDataSetState() && columnIndex >= 0 && columnIndex < this.captionNames.length) {
            return this.captionNames[columnIndex];
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        if (this.isValidDataSetState()) {
            return this.columnClasses[columnIndex];
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.isValidDataSetState()) {
            return this.isEditable[columnIndex];
        }
        return false;
    }

    public Object getValueAt(int row, int columnIndex) {
        if (this.isValidDataSetState()) {
            try {
                this.dataSet.getDisplayVariant(this.columnMap[columnIndex], row, this.value);
                Object object = this.value.getAsObject();
                return object;
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isValidDataSetState()) return;
        try {
            block10: {
                if (aValue != null) {
                    this.checkValue(aValue, rowIndex, columnIndex);
                } else {
                    this.value.setAssignedNull();
                }
                if (rowIndex != this.dataSet.getRow()) {
                    boolean moved = true;
                    try {
                        try {
                            moved = this.dataSet.goToRow(rowIndex);
                        }
                        catch (Exception e2) {
                            moved = false;
                            Object var7_7 = null;
                            if (!moved) {
                                throw new Exception(Res.bundle.format(28, Integer.toString(this.dataSet.getRow())));
                            }
                            break block10;
                        }
                        Object var7_6 = null;
                        if (moved) break block10;
                        throw new Exception(Res.bundle.format(28, Integer.toString(this.dataSet.getRow())));
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (moved) throw throwable;
                        throw new Exception(Res.bundle.format(28, Integer.toString(this.dataSet.getRow())));
                    }
                }
            }
            this.dataSet.setDisplayVariant(this.columnMap[columnIndex], this.value);
            return;
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void checkValue(Object aValue, int rowIndex, int columnIndex) throws Exception {
        block7: {
            Column column = this.dataSet.getColumn(this.columnMap[columnIndex]);
            if (aValue instanceof String) {
                try {
                    int lookupType = this.lookupTypes[columnIndex];
                    if (lookupType == -1) {
                        this.value.setFromString(column.getDataType(), (String)aValue);
                        break block7;
                    }
                    this.value.setFromString(lookupType, (String)aValue);
                }
                catch (Exception e2) {
                    ValidationException.invalidFormat(e2, column.getColumnName(), null);
                }
            } else if (aValue instanceof Variant) {
                this.value.setVariant((Variant)aValue);
            } else {
                this.value.setAsObject(aValue, column.getDataType());
            }
        }
    }

    public boolean isValidValue(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isValidDataSetState()) {
            return false;
        }
        try {
            this.checkValue(aValue, rowIndex, columnIndex);
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void handleException(Exception ex) {
        DBExceptionHandler.getInstance();
        DBExceptionHandler.handleException(this.dataSet, ex);
    }

    public void dataChanged(DataChangeEvent e2) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        if (e2.multiRowChange()) {
            this.fireTableDataChanged();
        } else {
            int row = e2.getRowAffected();
            switch (e2.getID()) {
                case 1: {
                    this.fireTableRowsInserted(row, row);
                    break;
                }
                case 2: {
                    this.fireTableRowsDeleted(row, row);
                    break;
                }
                case 3: {
                    this.fireTableRowsUpdated(row, this.getRowCount());
                    break;
                }
                default: {
                    this.fireTableDataChanged();
                }
            }
        }
    }

    public void postRow(DataChangeEvent e2) throws Exception {
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
            }
            if (event.getReason() == 7) {
                this.fireTableStructureChanged();
                this.fireTableDataChanged();
            } else if (event.getReason() == 9) {
                this.propertyChange = true;
            }
        } else {
            this.dataSetEventsEnabled = true;
            switch (event.getReason()) {
                case 1: {
                    this.updateModel();
                    this.fireTableStructureChanged();
                    if (!this.propertyChange) {
                        this.fireTableDataChanged();
                    }
                    this.propertyChange = false;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.updateModel();
                    this.fireTableStructureChanged();
                    break;
                }
                case 2: {
                    this.dataSetEventsEnabled = true;
                    this.fireTableDataChanged();
                }
            }
        }
    }

    public Column getColumn(int columnIndex) {
        try {
            if (this.isValidDataSetState()) {
                Column column = this.dataSet.getColumn(this.columnMap[columnIndex]);
                return column;
            }
        }
        catch (DataSetException e2) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

