/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBNavComboBoxModel;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.plaf.metal.MetalJdbComboBoxUI;
import com.borland.dbswing.plaf.motif.MotifJdbComboBoxUI;
import com.borland.dbswing.plaf.windows.WindowsJdbComboBoxUI;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import java.awt.FontMetrics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.UIResource;

public class JdbNavComboBox
extends JComboBox
implements AccessListener,
ColumnAware,
Serializable,
FocusListener {
    private int dropDownWidth = -1;
    private int cellHeight = -1;
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public JdbNavComboBox() {
        this.setModel(new DBNavComboBoxModel());
    }

    public JdbNavComboBox(DataSet dataSet, String columnName) {
        this.setDataSet(dataSet);
        this.setColumnName(columnName);
        this.setModel(new DBNavComboBoxModel(dataSet, columnName));
    }

    public void updateUI() {
        String currentLookAndFeel = UIManager.getLookAndFeel().getID();
        if (currentLookAndFeel.equals("Motif")) {
            this.setUI(MotifJdbComboBoxUI.createUI(this));
        } else if (currentLookAndFeel.equals("Metal")) {
            this.setUI(MetalJdbComboBoxUI.createUI(this));
        } else {
            this.setUI(WindowsJdbComboBoxUI.createUI(this));
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            this.openDataSet();
        }
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.getModel() instanceof DBNavComboBoxModel) {
            ((DBNavComboBoxModel)this.getModel()).setSelectedIndex(selectedIndex);
        } else {
            super.setSelectedIndex(selectedIndex);
        }
    }

    public int getSelectedIndex() {
        if (this.getModel() instanceof DBNavComboBoxModel) {
            return ((DBNavComboBoxModel)this.getModel()).getSelectedIndex();
        }
        return super.getSelectedIndex();
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.removeFocusListener(this);
        }
        this.dataSet = dataSet;
        if (dataSet != null) {
            dataSet.addAccessListener(this);
            this.addFocusListener(this);
        }
        if (this.getModel() instanceof DBNavComboBoxModel) {
            ((DBNavComboBoxModel)this.getModel()).setDataSet(dataSet);
        }
        this.openDataSet();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
        if (this.getModel() instanceof DBNavComboBoxModel) {
            ((DBNavComboBoxModel)this.getModel()).setColumnName(columnName);
        }
        this.openDataSet();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDropDownWidth(int dropDownWidth) {
        int oldWidth = this.dropDownWidth;
        this.dropDownWidth = dropDownWidth;
        this.firePropertyChange("dropDownWidth", oldWidth, dropDownWidth);
    }

    public int getDropDownWidth() {
        return this.dropDownWidth;
    }

    public void setFixedCellHeight(int cellHeight) {
        int oldCellHeight = this.cellHeight;
        this.cellHeight = cellHeight;
        this.firePropertyChange("fixedCellHeight", oldCellHeight, cellHeight);
    }

    public int getFixedCellHeight() {
        return this.cellHeight;
    }

    public void contentsChanged(ListDataEvent e2) {
        block9: {
            block8: {
                if (!DBUtilities.islpt4()) break block8;
                super.contentsChanged(e2);
                break block9;
            }
            ComboBoxModel mod = this.getModel();
            Object newSelectedItem = mod.getSelectedItem();
            if (this.selectedItemReminder == null) {
                if (newSelectedItem != null) {
                    this.selectedItemChanged();
                }
            } else if (!this.selectedItemReminder.equals(newSelectedItem)) {
                this.selectedItemChanged();
            }
            if (this.isEditable() || newSelectedItem == null) break block9;
            boolean shouldResetSelectedItem = true;
            Object selectedItem = mod.getSelectedItem();
            int c2 = mod.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                Object o2 = mod.getElementAt(i2);
                if (o2 == null || !o2.equals(selectedItem)) continue;
                shouldResetSelectedItem = false;
                break;
            }
            if (shouldResetSelectedItem) {
                if (mod.getSize() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this.setSelectedItem(null);
                }
            }
        }
    }

    private void openDataSet() {
        if (this.addNotifyCalled && this.dataSet != null && this.columnName != null) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(this.dataSet, this, ex);
                }
            } else {
                this.bindColumnProperties();
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (this.rebindColumnProperties || event.getReason() == 1 || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        } else {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
            }
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        }
    }

    public void focusGained(FocusEvent e2) {
        DBUtilities.updateCurrentDataSet(this, this.dataSet);
    }

    public void focusLost(FocusEvent e2) {
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        Column column;
        if (this.addNotifyCalled && this.dataSet != null && this.columnName != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            if (this.isDefaultProperty(this.getBackground()) && column.getBackground() != null) {
                this.setBackground(column.getBackground());
            }
            if (this.isDefaultProperty(this.getForeground()) && column.getForeground() != null) {
                this.setForeground(column.getForeground());
            }
            if (this.isDefaultProperty(this.getFont()) && column.getFont() != null) {
                this.setFont(column.getFont());
            }
            if (this.cellHeight == -1 && column.getDataType() == 16) {
                FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.getFont());
                this.setFixedCellHeight(fontMetrics.getHeight());
            }
            this.rebindColumnProperties = false;
        }
    }
}

