/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBListNavModel;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class JdbNavList
extends JList
implements NavigationListener,
AccessListener,
ListSelectionListener,
ColumnAware,
Serializable {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled;
    private boolean ignoreNavigation;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public JdbNavList() {
        this.setModel(new DBListNavModel());
    }

    public JdbNavList(DataSet dataSet, String columnName) {
        this.setDataSet(dataSet);
        this.setColumnName(columnName);
        this.setModel(new DBListNavModel(dataSet, columnName));
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeAccessListener(this);
            this.getSelectionModel().removeListSelectionListener(this);
        }
        this.dataSet = dataSet;
        if (dataSet != null) {
            dataSet.addNavigationListener(this);
            dataSet.addAccessListener(this);
            this.getSelectionModel().addListSelectionListener(this);
            if (this.getModel() instanceof DBListNavModel) {
                ((DBListNavModel)this.getModel()).setDataSet(dataSet);
            }
        }
        this.openDataSet();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
        if (this.getModel() instanceof DBListNavModel) {
            ((DBListNavModel)this.getModel()).setColumnName(columnName);
        }
        this.openDataSet();
    }

    public String getColumnName() {
        return this.columnName;
    }

    private void openDataSet() {
        if (this.addNotifyCalled && this.dataSet != null && this.columnName != null) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(this.dataSet, this, ex);
                    return;
                }
            } else {
                this.bindColumnProperties();
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            this.openDataSet();
        }
    }

    public void valueChanged(ListSelectionEvent e2) {
        if (!this.ignoreNavigation && !e2.getValueIsAdjusting()) {
            int index = this.getSelectedIndex();
            try {
                if (this.dataSet != null && index > -1 && index < this.dataSet.getRowCount() && this.dataSet.getRow() != index) {
                    this.dataSet.goToRow(index);
                }
            }
            catch (DataSetException ex) {
                DBExceptionHandler.handleException(this.dataSet, this, ex);
            }
        }
    }

    public void navigated(NavigationEvent e2) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int row = this.dataSet.getRow();
        if (this.getSelectedIndex() != row) {
            this.ignoreNavigation = true;
            this.setSelectedIndex(row);
            this.ignoreNavigation = false;
        }
        this.ensureIndexIsVisible(row);
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            this.dataSetEventsEnabled = true;
            if (this.rebindColumnProperties || event.getReason() == 1 || event.getReason() == 2) {
                this.bindColumnProperties();
                this.setSelectedIndex(this.dataSet.getRow());
            }
        } else {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            this.getSelectionModel().clearSelection();
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        }
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        Column column;
        if (this.addNotifyCalled && this.dataSet != null && this.columnName != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            if (this.isDefaultProperty(this.getBackground()) && column.getBackground() != null) {
                this.setBackground(column.getBackground());
            }
            if (this.isDefaultProperty(this.getForeground()) && column.getForeground() != null) {
                this.setForeground(column.getForeground());
            }
            if (this.isDefaultProperty(this.getFont()) && column.getFont() != null) {
                this.setFont(column.getFont());
            }
            this.setSelectionMode(0);
            this.setPrototype(column.getWidth());
            this.rebindColumnProperties = false;
        }
    }

    private void setPrototype(int charWidth) {
        StringBuffer sb = new StringBuffer(charWidth);
        for (int index = 0; index < charWidth; ++index) {
            sb.append('M');
        }
        this.setPrototypeCellValue(sb.toString());
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != 0) {
            throw new IllegalArgumentException(Res._UnsupSelMode);
        }
        super.setSelectionMode(selectionMode);
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (ps == null || ps.width < 5 || ps.height < 5) {
            ps = ps != null ? ps : new Dimension(100, 100);
            ps.width = ps.width > 100 ? ps.width : 100;
            ps.height = ps.height > 100 ? ps.height : 100;
        }
        return ps;
    }
}

