/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus;

import edu.iastate.utils.Utility;
import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.gui.LabelledItemPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;

public class AboutBoxDialog
extends JDialog {
    static String info;
    private JTabbedPane _tabPnl;
    private SystemPanel _systemPnl;
    private final JButton _closeBtn = new JButton("Close");

    public AboutBoxDialog(String info, String title) {
        AboutBoxDialog.info = info;
        this.createGUI();
        this.setTitle(title);
    }

    public AboutBoxDialog(JFrame frame, String info, String title) {
        super(frame);
        AboutBoxDialog.info = info;
        this.createGUI();
        this.setTitle(title);
    }

    public void showAboutBox() throws IllegalArgumentException {
        this.setVisible(true);
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        long start = 0L;
        this._tabPnl = new JTabbedPane();
        this._tabPnl.add("About", new AboutPanel());
        this._systemPnl = new SystemPanel();
        this._tabPnl.add("System", this._systemPnl);
        contentPane.add((Component)this._tabPnl, "Center");
        contentPane.add((Component)this.createButtonBar(), "South");
        this.getRootPane().setDefaultButton(this._closeBtn);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                AboutBoxDialog.this._systemPnl._memoryPnl.startTimer();
            }

            public void windowDeactivated(WindowEvent evt) {
                AboutBoxDialog.this._systemPnl._memoryPnl.stopTimer();
            }
        });
        this.setResizable(true);
        this.setSize(400, 400);
        this.pack();
        GUIUtils.centerWithinParent(this);
    }

    private JPanel createButtonBar() {
        this._closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutBoxDialog.this.setVisible(false);
            }
        });
        JPanel p2 = new JPanel();
        p2.add(this._closeBtn);
        return p2;
    }

    public static void main(String[] args) {
        AboutBoxDialog dlg = new AboutBoxDialog("<html>Test <b>Dlg<b>,\n<li>You can use HTML</li><li>Customize info and title</li></html>", "Test");
        dlg.showAboutBox();
    }

    private static class MemoryPanel
    extends LabelledItemPanel
    implements ActionListener {
        private final JTextField _totalMemoryLbl = new JTextField();
        private final JTextField _usedMemoryLbl = new JTextField();
        private final JTextField _freeMemoryLbl = new JTextField();
        private Timer _timer;

        MemoryPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.addItem("Heap Size", (JComponent)this._totalMemoryLbl);
            this.addItem("Used Heap", (JComponent)this._usedMemoryLbl);
            this.addItem("Free Heap", (JComponent)this._freeMemoryLbl);
            this._totalMemoryLbl.setEditable(false);
            this._usedMemoryLbl.setEditable(false);
            this._freeMemoryLbl.setEditable(false);
        }

        public void removeNotify() {
            super.removeNotify();
            this.stopTimer();
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateMemoryStatus();
        }

        synchronized void startTimer() {
            if (this._timer == null) {
                this.updateMemoryStatus();
                this._timer = new Timer(2000, this);
                this._timer.start();
            }
        }

        synchronized void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
        }

        private void updateMemoryStatus() {
            Runtime rt = Runtime.getRuntime();
            long totalMemory = rt.totalMemory();
            long freeMemory = rt.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            this._totalMemoryLbl.setText(Utility.formatSize(totalMemory, 2));
            this._usedMemoryLbl.setText(Utility.formatSize(usedMemory, 2));
            this._freeMemoryLbl.setText(Utility.formatSize(freeMemory, 2));
        }
    }

    private static final class SystemPanel
    extends JPanel {
        private MemoryPanel _memoryPnl;

        SystemPanel() {
            this.setLayout(new BorderLayout());
            this._memoryPnl = new MemoryPanel();
            this.add((Component)this._memoryPnl, "Center");
            JButton gcBtn = new JButton(new String("Garbge Collect"));
            gcBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.gc();
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            buttonPanel.add(gcBtn);
            this.add((Component)buttonPanel, "South");
        }
    }

    private static final class AboutPanel
    extends JPanel {
        AboutPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton infoArea = new JButton(info);
            infoArea.setBackground(Color.yellow);
            infoArea.setEnabled(false);
            this.setBackground(Color.white);
            this.add((Component)infoArea, "Center");
        }
    }
}

