/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus;

import edu.iastate.utils.gui.GUIUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;

public class IndusConstants {
    private static String PROJECT_FILE = "edu/iastate/anthill/indus/IndusMain.class";
    public static String TIME = "2005-04-07";
    public static String VER = "1.2.1";
    public static String NAME = "Indus Environment";
    public static final String DSSERVER = "localhost";
    public static final String INDUS_PORT = "9090";
    public static final int DSPORT = 2009;
    public static final String HOST = "http://localhost:9090/wikiont/";
    public static final String imageBasisURL = "http://localhost:9090/wikiont/images/";
    public static final String typeBasisURL = "http://localhost:9090/wikiont/type/";
    public static final String schemaBasisURL = "http://localhost:9090/wikiont/schema/";
    public static final String mappingBasisURL = "http://localhost:9090/wikiont/mapping/";
    public static String SUBCLASS = "rdfs:subclassOf";
    public static ImageIcon iconDbTree = IndusConstants.loadImageIcon("dbtree.gif");
    public static ImageIcon iconDbSet = IndusConstants.loadImageIcon("dbset.gif");
    public static ImageIcon iconUndo = IndusConstants.loadImageIcon("undo.gif");
    public static ImageIcon iconRedo = IndusConstants.loadImageIcon("redo.gif");
    public static ImageIcon iconRename = IndusConstants.loadImageIcon("rename.gif");
    public static ImageIcon iconComment = IndusConstants.loadImageIcon("comment.gif");
    public static ImageIcon iconAddSup = IndusConstants.loadImageIcon("addsup.gif");
    public static ImageIcon iconAddSub = IndusConstants.loadImageIcon("addsub.gif");
    public static ImageIcon iconDelete = IndusConstants.loadImageIcon("delete.gif");
    public static ImageIcon iconDeleteSub = IndusConstants.loadImageIcon("deletesub.gif");
    public static ImageIcon iconDeleteSup = IndusConstants.loadImageIcon("deletesup.gif");
    public static ImageIcon iconRoot = IndusConstants.loadImageIcon("root.gif");
    public static ImageIcon iconPackage = IndusConstants.loadImageIcon("package.gif");
    public static ImageIcon iconClass = IndusConstants.loadImageIcon("class.gif");
    public static ImageIcon iconProperty = IndusConstants.loadImageIcon("property.gif");
    public static ImageIcon iconInstance = IndusConstants.loadImageIcon("instance.gif");
    public static ImageIcon iconAllClasses = IndusConstants.loadImageIcon("allclass.gif");
    public static ImageIcon iconAllProperties = IndusConstants.loadImageIcon("allproperty.gif");
    public static ImageIcon iconAllInstances = IndusConstants.loadImageIcon("allinstance.gif");
    public static ImageIcon iconEqu = IndusConstants.loadImageIcon("equ.gif");
    public static ImageIcon iconUnequ = IndusConstants.loadImageIcon("unequ.gif");
    public static ImageIcon iconInto = IndusConstants.loadImageIcon("into.gif");
    public static ImageIcon iconOnto = IndusConstants.loadImageIcon("onto.gif");
    public static ImageIcon iconComp = IndusConstants.loadImageIcon("comp.gif");
    public static ImageIcon iconIncomp = IndusConstants.loadImageIcon("incomp.gif");
    public static ImageIcon iconUser = IndusConstants.loadImageIcon("user.gif");
    public static ImageIcon iconDatatype = IndusConstants.loadImageIcon("datatype.gif");
    public static ImageIcon iconNumber = IndusConstants.loadImageIcon("number.gif");
    public static ImageIcon iconString = IndusConstants.loadImageIcon("string.gif");
    public static ImageIcon iconTreetype = IndusConstants.loadImageIcon("treetype.gif");
    public static ImageIcon iconSchema = IndusConstants.loadImageIcon("schema.gif");
    public static ImageIcon iconAVHValue = IndusConstants.loadImageIcon("tree.gif");
    public static ImageIcon iconDB = IndusConstants.loadImageIcon("db.gif");
    public static ImageIcon iconTable = IndusConstants.loadImageIcon("table.gif");
    public static ImageIcon iconTree = IndusConstants.loadImageIcon("tree.gif");
    public static String infoAbout = "<html><font color=\"#FF0099\"><b>INDUS Data Integration Environment</b></font><br>Version " + VER + "<br>" + "<br><b>Jie Bao</b><br>Mar 2005<br>" + "Iowa State University<br><a href=\"mailto:baojie@iastate.edu\">" + "baojie@iastate.edu</a><br><a href=\"http://www.cs.iastate.edu/~baojie\">" + "http://www.cs.iastate.edu/~baojie</a><br>" + "</html>";
    public static final String dbURL = "jdbc:postgresql://localhost/indus";
    public static final String dbCacheURL = "jdbc:postgresql://localhost/indus-data";
    public static final String dbLocalURL = "jdbc:postgresql://localhost/indus-local";
    public static final String dbUsr = "indus";
    public static final String dbPwd = "indus";
    public static final String dbDriver = "org.postgresql.Driver";

    public static String format(long time) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-d HH:mm:ss");
        return fmt.format(new Date(time));
    }

    static String getModifiedTime() {
        try {
            URL fileURL = ClassLoader.getSystemClassLoader().getResource(PROJECT_FILE);
            File file = new File(new URI(fileURL.toString()));
            long modifiedTime = file.lastModified();
            return IndusConstants.format(modifiedTime);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static ImageIcon loadImageIcon(String name) {
        return (ImageIcon)GUIUtils.loadIcon("images/" + name);
    }
}

