/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus.datasource.type;

import edu.iastate.anthill.indus.datasource.Configable;
import edu.iastate.utils.string.SimpleXMLParser;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class DataType
implements Configable {
    public boolean modified = false;
    public boolean readOnly = false;
    public static final String DEFAULT_TYPES = "integer;float;string;boolean;AVH";
    String name = null;
    String supertype = null;

    public static boolean isLegalName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0) {
            return false;
        }
        return name.matches("[a-zA-Z][\\s\\w\\-._]*");
    }

    public static boolean isString(String type, String supertype) {
        if (type.equals("string")) {
            return true;
        }
        if (supertype == null) {
            return false;
        }
        return supertype.equals("string");
    }

    public static String[] getPredefinedTypes() {
        return DEFAULT_TYPES.split(";");
    }

    public static boolean isNumber(String type, String supertype) {
        if (type.equals("integer") || type.equals("float")) {
            return true;
        }
        if (supertype == null) {
            return false;
        }
        return supertype.equals("integer") || supertype.equals("float");
    }

    public String getSupertype() {
        return this.supertype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String typeName) {
        this.name = typeName;
    }

    public static boolean isPredefinedType(String typName) {
        return DEFAULT_TYPES.indexOf(typName) != -1;
    }

    public static String parseSupertype(String datatypeinXML) {
        Vector vec = SimpleXMLParser.getNestedBlock("subTypeOf", datatypeinXML, false);
        if (vec.size() > 0) {
            return (String)vec.elementAt(0);
        }
        return null;
    }

    public abstract JPanel getEditorPane();

    public abstract String print();

    public abstract String toString();

    public abstract String getInformation();
}

