/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.agent;

import edu.iastate.ato.agent.Buddy;
import edu.iastate.ato.agent.ChatListener;
import edu.iastate.ato.agent.ChatPanel;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MoAgent
extends Thread {
    static String enc = "GB2312";
    int port;
    String ip;
    public String myName = "Anonymous";
    int counter = 0;
    Map<String, Buddy> myBuddyList = new HashMap<String, Buddy>();
    Map<String, ChatPanel> chatWindows = new HashMap<String, ChatPanel>();
    public static String WHO_ARE_YOU = "WhoAreYou!";
    public static String I_ADDED_YOU = "I_added_you_as_buddy";
    ChatListener messageListener;
    public static String YOUR_ID = ">>your_id=";
    static String OK = "ok";
    static String FAIL = ">>fail";
    static String UNKNOWN = "Unknown Command";
    static String HELLO = "HiNihaoTHisISSOMESTRANGEWORDTHATWILLNEVERBESENTBYUSERS";
    static String MSG = "indus://";
    static String USER = "user=";
    static String CONTENT = "content=";
    static String HOST = "host=";
    static String PORT = "port=";
    static String START = ">>>>>>";

    public MoAgent(String myName) {
        this.myName = myName;
    }

    public ChatPanel getChatWindow(Buddy b2) {
        ChatPanel window = this.chatWindows.get(b2.id);
        if (window != null) {
            return window;
        }
        window = new ChatPanel(b2);
        this.chatWindows.put(b2.id, window);
        return window;
    }

    public String sendWhoAreYou(String buddyHost, String buddyPort) {
        String cmd = WHO_ARE_YOU;
        return MoAgent.sendToServer(cmd, buddyHost, buddyPort);
    }

    public String addBuddy(String buddyHost, String buddyPort) {
        String buddyName = this.sendWhoAreYou(buddyHost, buddyPort);
        MoAgent.sendToServer(I_ADDED_YOU + this.myName + ":" + this.ip + ":" + this.port, buddyHost, buddyPort);
        return buddyName;
    }

    public void handleAddBuddy(DataOutputStream outToClient, String msg) throws IOException {
        if (this.messageListener != null && msg.startsWith(I_ADDED_YOU)) {
            String str = msg.substring(I_ADDED_YOU.length());
            String[] s2 = str.split(":", 3);
            String buddyName = s2[0];
            String buddyHost = s2[1];
            String buddyPort = s2[2];
            this.messageListener.onBeAddedAsBuddy(buddyName, buddyHost, buddyPort);
        }
        outToClient.writeBytes(OK + "\n");
    }

    public void addMessageListener(ChatListener messageListener) {
        this.messageListener = messageListener;
    }

    public Buddy sendID(String myID, String buddyName, String buddyHost, String buddyPort) {
        String buddyID = this.counter++ + "";
        String cmd = YOUR_ID + myID + ":" + buddyID;
        String res = MoAgent.sendToServer(cmd, buddyHost, buddyPort);
        if (OK.equals(res)) {
            Buddy b2 = new Buddy();
            b2.id = buddyID;
            b2.name = buddyName;
            b2.myID = myID;
            b2.host = buddyHost;
            b2.port = buddyPort;
            return b2;
        }
        return null;
    }

    public void handleYourID(DataOutputStream outToClient, String msg) throws IOException {
        if (msg.startsWith(YOUR_ID)) {
            String str = msg.substring(YOUR_ID.length());
            String[] s2 = str.split(":", 2);
            String senderID = s2[0];
            String myID = s2[1];
            Buddy b2 = this.myBuddyList.get(senderID);
            b2.myID = myID;
            outToClient.writeBytes(OK + "\n");
        }
    }

    public void run() {
        try {
            ServerSocket welcomeSocket = new ServerSocket(0);
            this.port = welcomeSocket.getLocalPort();
            InetAddress thisIp = InetAddress.getLocalHost();
            this.ip = thisIp.getHostAddress();
            System.out.println("\nMOEditor Agent starts " + new Date().toString());
            System.out.println("Port: " + this.port);
            System.out.println("Host: " + this.ip);
            while (true) {
                Socket connectionSocket = welcomeSocket.accept();
                BufferedReader inFromClient = new BufferedReader(new InputStreamReader(connectionSocket.getInputStream()));
                DataOutputStream outToClient = new DataOutputStream(connectionSocket.getOutputStream());
                String clientSentence = inFromClient.readLine();
                try {
                    clientSentence = URLDecoder.decode(clientSentence, enc);
                }
                catch (UnsupportedEncodingException ex1) {
                    // empty catch block
                }
                System.out.println(clientSentence);
                if (clientSentence.equals(HELLO)) {
                    this.sendToClient(outToClient, OK);
                    continue;
                }
                if (clientSentence.startsWith(WHO_ARE_YOU)) {
                    this.sendToClient(outToClient, this.myName);
                    continue;
                }
                if (clientSentence.startsWith(MSG)) {
                    this.handleMessage(outToClient, clientSentence);
                    continue;
                }
                if (clientSentence.startsWith(START)) {
                    this.handleStartSession(outToClient, clientSentence);
                    continue;
                }
                if (clientSentence.startsWith(YOUR_ID)) {
                    this.handleYourID(outToClient, clientSentence);
                    continue;
                }
                if (clientSentence.startsWith(I_ADDED_YOU)) {
                    this.handleAddBuddy(outToClient, clientSentence);
                    continue;
                }
                this.sendToClient(outToClient, UNKNOWN);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static boolean isServerOn(String serverHost, String serverPort) {
        String res = MoAgent.sendToServer(HELLO, serverHost, serverPort);
        return OK.equals(res);
    }

    public void sendToClient(DataOutputStream outToClient, String msg) throws IOException {
        System.out.println("Send back: " + msg);
        outToClient.writeBytes(msg + "\n");
    }

    public String startSession(String myHost, String myPort, String myName, String buddyHost, String buddyPort) {
        String str = START + myName + "@" + myHost + ":" + myPort;
        return MoAgent.sendToServer(str, buddyHost, buddyPort);
    }

    public void handleStartSession(DataOutputStream outToClient, String msg) throws IOException {
        if (msg.startsWith(START)) {
            String buddyLabel = msg.substring(START.length());
            String[] s2 = buddyLabel.split("@", 2);
            String name = s2[0];
            s2 = s2[1].split(":", 2);
            String host = s2[0];
            String port = s2[1];
            String buddyID = this.counter++ + "";
            Buddy b2 = new Buddy();
            b2.id = buddyID;
            b2.name = name;
            b2.host = host;
            b2.port = port;
            this.myBuddyList.put(buddyID, b2);
            outToClient.writeBytes(buddyID + "\n");
        }
    }

    public static String sendMessage(String msg, Buddy buddy) {
        String str = MSG + buddy.myID + ":" + msg;
        return MoAgent.sendToServer(str, buddy.host, buddy.port);
    }

    public void handleMessage(DataOutputStream outToClient, String msg) throws IOException {
        if (msg.startsWith(MSG)) {
            String str = msg.substring(MSG.length());
            String[] s2 = str.split(":", 2);
            String client_id = s2[0];
            String content = s2[1];
            this.sendToClient(outToClient, OK);
            Buddy b2 = this.myBuddyList.get(client_id);
            if (b2 != null) {
                ChatPanel window = this.getChatWindow(b2);
                window.append(b2.name, content);
                window.showMe();
            }
        }
    }

    public static String sendToServer(String cmd, String serverHost, String serverPort) {
        String str = cmd;
        try {
            str = URLEncoder.encode(cmd, enc);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        System.out.println(str);
        try {
            return MoAgent.sendToServer(str, serverHost, Integer.parseInt(serverPort));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String sendToServer(String cmd, String serverHost, int serverPort) {
        try {
            Socket clientSocket = new Socket(serverHost, serverPort);
            DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());
            BufferedReader inFromServer = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            outToServer.writeBytes(cmd + '\n');
            String res = inFromServer.readLine();
            clientSocket.close();
            return res;
        }
        catch (Exception ex) {
            return FAIL;
        }
    }

    public static void main(String[] args) {
        MoAgent server = new MoAgent("bob");
        server.start();
        for (int i2 = 0; i2 < 999999999; ++i2) {
        }
        String res = MoAgent.sendToServer("Hello 1", server.ip, server.port);
        System.out.println(res);
        res = MoAgent.sendToServer("Hello 2", server.ip, server.port);
        System.out.println(res);
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public ChatPanel startChat(String buddyHost, String buddyPort) {
        String buddyName = this.sendWhoAreYou(buddyHost, buddyPort);
        if (buddyName == null) {
            return null;
        }
        return this.startChat(buddyName, buddyHost, buddyPort);
    }

    public ChatPanel startChat(String buddyName, String buddyHost, String buddyPort) {
        if (!MoAgent.isServerOn(buddyHost, buddyPort)) {
            return null;
        }
        Buddy b2 = this.myBuddyList.get(buddyName);
        if (b2 == null) {
            String myID = this.startSession(this.ip, this.port + "", this.myName, buddyHost, buddyPort);
            if (myID == null) {
                return null;
            }
            b2 = this.sendID(myID, buddyName, buddyHost, buddyPort);
            if (b2 == null) {
                return null;
            }
            this.myBuddyList.put(b2.id, b2);
        }
        return this.getChatWindow(b2);
    }
}

