/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.utils.log.Config;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class MOEditorConfig
extends Config {
    private static final String tagConfig = "Config";
    Element root;
    private final String SELECTED_ONT = "SelectedOntology";
    private final String ALL_ONTOLOGIES = "AllOntologies";

    public MOEditorConfig(String filename) {
        super(filename, false);
        try {
            this.root = (Element)XPathAPI.selectSingleNode(this.configXML, tagConfig);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    protected void createNew() {
        this.createBlankNew();
        this.root = (Element)this.addChildTag(this.configXML, tagConfig);
    }

    protected void objToXML(Object obj) {
        MOEditor agent = (MOEditor)obj;
        if (this.root != null) {
            this.root.getParentNode().removeChild(this.root);
        }
        this.root = (Element)this.addChildTag(this.configXML, tagConfig);
        String selected = agent.selectedServer == null ? "" : agent.selectedServer.name;
        MOEditorConfig.setProperty(this.root, "SelectedOntology", selected);
        Element allOnt = (Element)this.addChildTag(this.root, "AllOntologies");
        Iterator i$ = agent.serverList.iterator();
        while (i$.hasNext()) {
            OntologyServerInfo info = (OntologyServerInfo)i$.next();
            Element oneOntNode = info.toXML(allOnt);
            allOnt.appendChild(oneOntNode);
        }
    }

    protected void xmlToObj(Object obj) {
        MOEditor agent = (MOEditor)obj;
        agent.serverList.clear();
        try {
            NodeList nodelist;
            String selected = MOEditorConfig.getProperty(this.root, "SelectedOntology");
            Element allBBSNode = (Element)XPathAPI.selectSingleNode(this.root, "AllOntologies");
            if (allBBSNode != null && (nodelist = XPathAPI.selectNodeList(allBBSNode, "Ontology")) != null) {
                for (int i2 = 0; i2 < nodelist.getLength(); ++i2) {
                    Element oneOntNode = (Element)nodelist.item(i2);
                    OntologyServerInfo info = new OntologyServerInfo();
                    info.fromXML(oneOntNode);
                    agent.serverList.add(info);
                    if (info.name.compareTo(selected) != 0) continue;
                    agent.selectedServer = info;
                }
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

