/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.dialog;

import com.borland.dx.dataset.Column;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.po.UserManager;
import edu.iastate.utils.Debug;
import edu.iastate.utils.sql.DBViewer;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PrivilegeEditor
extends DBViewer {
    String package_oid;
    String packageName;
    Vector<String> alluser;

    public PrivilegeEditor(JFrame parent, OntologyServerInfo info, String package_oid, String packageName) {
        super(parent, false, "Who can edit package '" + packageName + "'?", info.url, info.user, info.password, false, info.driver);
        this.alluser = UserManager.getAllUsers(this.db, "pkgadmin");
        this.package_oid = package_oid;
        this.packageName = packageName;
        this.query.setMetaDataUpdate(0);
        this.jbInit();
    }

    public void jbInit() {
        String sql = "SELECT pid AS from, user_id AS user, rights FROM privilege, package  WHERE (package_oid IN (SELECT p2 FROM bj_super_pkg('" + this.package_oid + "', 'nest_in')) " + "OR package_oid = '" + this.package_oid + "') AND package.oid = privilege.package_oid";
        System.out.println(sql);
        this.setSQL(sql);
        this.query.executeQuery();
        Column[] cols = this.query.getColumns();
        System.out.println(this.query.getColumnCount());
        for (int i2 = 0; i2 < cols.length; ++i2) {
            System.out.println(cols[i2].getColumnName());
            this.query.setRowId(cols[i2].getColumnName(), true);
        }
        this.dbNavToolbar.setButtonStateDitto(4);
        this.datasourceList.setVisible(false);
        this.dataTable.setEditable(true);
        this.dataTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                PrivilegeEditor.this.onTableMouseClick(evt);
            }
        });
    }

    private void onTableMouseClick(MouseEvent evt) {
        Object[] values;
        Object selectedValue;
        int row = this.dataTable.rowAtPoint(evt.getPoint());
        int col = this.dataTable.columnAtPoint(evt.getPoint());
        Object value = this.dataTable.getValueAt(row, col);
        String colName = this.dataTable.getColumnName(col).toLowerCase();
        if (colName.equals("rights")) {
            Object[] roles = new String[]{"r", "w", "rw"};
            Object selectedValue2 = JOptionPane.showInputDialog(null, "Choose one", "Privileges", 1, null, roles, value);
            if (selectedValue2 != null) {
                this.dataTable.setValueAt(selectedValue2, row, col);
            }
        } else if (colName.equals("user") && (selectedValue = JOptionPane.showInputDialog(null, "Choose User", "Users", 1, null, values = this.alluser.toArray(), value)) != null) {
            this.dataTable.setValueAt(selectedValue, row, col);
        }
    }

    public void afterToolebarAction(ActionEvent e2) {
        JButton btnInsert = this.dbNavToolbar.getInsertButton();
        if (e2.getSource() == btnInsert) {
            int row = this.dataTable.getSelectedRow();
            int col = this.dataTable.getColumnModel().getColumnIndex("rights");
            this.dataTable.setValueAt("rw", row, col);
            col = this.dataTable.getColumnModel().getColumnIndex("from");
            this.dataTable.setValueAt(this.packageName, row, col);
        }
    }

    public boolean beforeToolebarAction(ActionEvent e2) {
        int rightscol = this.dataTable.getColumnModel().getColumnIndex("rights");
        int usercol = this.dataTable.getColumnModel().getColumnIndex("user");
        int pkgcol = this.dataTable.getColumnModel().getColumnIndex("from");
        JButton btnPost = this.dbNavToolbar.getPostButton();
        JButton btnSave = this.dbNavToolbar.getSaveButton();
        if (e2.getSource() == btnPost || e2.getSource() == btnSave) {
            for (int row = 0; row < this.dataTable.getRowCount(); ++row) {
                String pkg = (String)this.dataTable.getValueAt(row, pkgcol);
                if (!pkg.equals(this.packageName)) continue;
                String user = (String)this.dataTable.getValueAt(row, usercol);
                String rights = (String)this.dataTable.getValueAt(row, rightscol);
                UserManager.addPrivilege(this.db, user, this.package_oid, rights);
            }
            return false;
        }
        if (e2.getSource() == this.dbNavToolbar.getDeleteButton()) {
            int row = this.dataTable.getSelectedRow();
            String user = (String)this.dataTable.getValueAt(row, usercol);
            String rights = (String)this.dataTable.getValueAt(row, rightscol);
            String pkg = (String)this.dataTable.getValueAt(row, pkgcol);
            if (!pkg.equals(this.packageName)) {
                Debug.trace("You can delete user rights for package '" + this.packageName + "' only");
                return false;
            }
            UserManager.deletePrivilege(this.db, user, this.package_oid, rights);
            this.refresh();
            return false;
        }
        if (e2.getSource() == this.dbNavToolbar.getRefreshButton()) {
            this.refresh();
            return false;
        }
        return true;
    }

    public boolean isTableCellEditable(int row, int col) {
        int pkgcol = this.dataTable.getColumnModel().getColumnIndex("from");
        return col != pkgcol;
    }
}

