/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.dialog;

import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.utils.Debug;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import edu.iastate.utils.sql.JDBCConfigPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingPanel
extends JDBCConfigPanel
implements MessageHandler {
    protected JButton btnSave = new JButton("Save Setting");
    protected JButton btnDelete = new JButton("Delete Setting");
    protected JButton btnNew = new JButton("New Setting");
    JComboBox ontList = new JComboBox();
    public OntologyServerInfo selectedOnt;

    public SettingPanel(Set<OntologyServerInfo> ontologies, OntologyServerInfo selected) {
        try {
            this.useName = true;
            for (OntologyServerInfo ont : ontologies) {
                this.ontList.addItem(ont);
            }
            if (selected != null) {
                this.selectedOnt = selected;
                this.ontList.setSelectedItem(this.selectedOnt);
            } else if (this.ontList.getItemCount() > 0) {
                this.ontList.setSelectedIndex(0);
                this.selectedOnt = (OntologyServerInfo)this.ontList.getItemAt(0);
                System.out.println(new StringBuffer().append(this.selectedOnt).append(" is self-given").toString());
            }
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void jbInit() throws Exception {
        this.messageMap();
        this.myContentPane.addItem("Ontology list", (JComponent)this.ontList);
        MyItemListener actionListener = new MyItemListener();
        this.ontList.addItemListener(actionListener);
        this.updateUI(this.selectedOnt);
        this.paneButton.add((Component)this.btnNew, null);
        this.paneButton.add((Component)this.btnSave, null);
        this.paneButton.add((Component)this.btnDelete, null);
        super.jbInit();
    }

    @Override
    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnTest, this, "onTest");
            MessageMap.mapAction(this.btnSave, this, "onSave");
            MessageMap.mapAction(this.btnDelete, this, "onDelete");
            MessageMap.mapAction(this.btnNew, this, "onNew");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onNew(ActionEvent evt) {
        this.clearUI();
        this.selectedOnt = new OntologyServerInfo();
        this.ontList.setSelectedItem(null);
    }

    public void onDelete(ActionEvent evt) {
        if (this.selectedOnt != null) {
            this.ontList.removeItem(this.selectedOnt);
        }
    }

    public Set<OntologyServerInfo> getOntologyConfigs() {
        HashSet<OntologyServerInfo> s2 = new HashSet<OntologyServerInfo>();
        int size = this.ontList.getItemCount();
        for (int i2 = 0; i2 < size; ++i2) {
            OntologyServerInfo ont = (OntologyServerInfo)this.ontList.getItemAt(i2);
            s2.add(ont);
        }
        return s2;
    }

    public void onSave(ActionEvent evt) {
        if (this.selectedOnt != null) {
            String name = this.dbName.getText();
            String url = this.dbMachineURL.getText();
            String user = this.dbUserID.getText();
            String password = new String(this.dbUserPwd.getPassword());
            String driver = this.dbJdbcDriver.getText();
            String type = (String)this.dbType.getSelectedItem();
            if (name == null || name.trim().length() == 0) {
                Debug.trace("Name cannot be empty");
                return;
            }
            int size = this.ontList.getItemCount();
            for (int i2 = 0; i2 < size; ++i2) {
                OntologyServerInfo ont = (OntologyServerInfo)this.ontList.getItemAt(i2);
                if (!ont.name.equals(name) || ont == this.selectedOnt) continue;
                Debug.trace("The name is already used");
                return;
            }
            if (url == null || url.trim().length() == 0 || user == null || user.trim().length() == 0 || password == null || password.trim().length() == 0 || driver == null || driver.trim().length() == 0 || type == null || type.trim().length() == 0) {
                Debug.trace("You should fill out all fields");
                return;
            }
            this.selectedOnt.name = name;
            this.selectedOnt.url = url;
            this.selectedOnt.user = user;
            this.selectedOnt.password = password;
            this.selectedOnt.driver = driver;
            this.selectedOnt.type = type;
            if (this.ontList.getSelectedItem() == null) {
                this.ontList.addItem(this.selectedOnt);
                this.ontList.setSelectedItem(this.selectedOnt);
            }
        }
    }

    void clearUI() {
        this.dbName.setText(null);
        this.dbMachineURL.setText(null);
        this.dbUserID.setText(null);
        this.dbUserPwd.setText(null);
        this.dbJdbcDriver.setText(null);
        this.dbType.setSelectedItem(null);
    }

    void updateUI(OntologyServerInfo info) {
        if (info != null) {
            this.dbName.setText(info.name);
            this.dbMachineURL.setText(info.url);
            this.dbUserID.setText(info.user);
            this.dbUserPwd.setText(info.password);
            this.dbJdbcDriver.setText(info.driver);
            this.dbType.setSelectedItem(info.type);
        }
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            JComboBox cb2 = (JComboBox)evt.getSource();
            Object item = evt.getItem();
            if (cb2 == SettingPanel.this.ontList && evt.getStateChange() == 1 && item instanceof OntologyServerInfo) {
                if (item == SettingPanel.this.selectedOnt) {
                    return;
                }
                SettingPanel.this.selectedOnt = (OntologyServerInfo)item;
                if (SettingPanel.this.selectedOnt != null) {
                    SettingPanel.this.updateUI(SettingPanel.this.selectedOnt);
                }
            }
        }
    }
}

