/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageTree
extends TypedTree {
    Connection db;

    public PackageTree(Connection db2) {
        this.db = db2;
    }

    public void AddTerm(String oid) {
        String pkg_oid = OntologyQuerier.getHomePackage(this.db, oid);
        if (pkg_oid == null) {
            pkg_oid = OntologyQuerier.getPackageOid(this.db, "Global");
        }
        PackageNode home = null;
        Vector<PackageNode> allPkg = this.getAllPackage();
        for (PackageNode pkg : allPkg) {
            if (!pkg.getOid().equals(pkg_oid)) continue;
            home = pkg;
            break;
        }
        if (home == null) {
            return;
        }
        if (home.expanded) {
            Vector<DbTermNode> terms = PackageTree.getTermsInPackage(home);
            for (DbTermNode t2 : terms) {
                if (!t2.getOid().equals(oid)) continue;
                this.expandNode(t2);
                this.setSelectionPath(PackageTree.getPath(t2));
                break;
            }
        }
    }

    ATOTreeNode findChildByValue(ATOTreeNode node, String value) {
        Enumeration<TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            ATOTreeNode n2 = (ATOTreeNode)e2.nextElement();
            if (!n2.getLocalName().equals(value)) continue;
            if (n2 instanceof DBTermCloneNode) {
                return ((DBTermCloneNode)n2).sourceNode;
            }
            return n2;
        }
        return null;
    }

    public void cancelEditing(Vector<String> package_oid) {
        Vector<PackageNode> e2 = this.getAllPackage();
        for (PackageNode n2 : e2) {
            if (!package_oid.contains(n2.getOid()) && n2.getOid() != null) continue;
            n2.setReadOnly(true);
            this.getModel().reload(n2);
            MOEditor.theInstance.paneDetails.switchPropertyEditor(n2);
        }
    }

    public PackageNode moveBranch(DbTermNode selected, ATOTreeNode dropTarget) {
        PackageNode newPackage = null;
        if (dropTarget instanceof PackageNode) {
            newPackage = (PackageNode)dropTarget;
        } else if (dropTarget instanceof DbTermNode) {
            newPackage = ((DbTermNode)dropTarget).getHomePackageNode();
        }
        Enumeration<TreeNode> en = selected.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DbTermNode term = (DbTermNode)en.nextElement();
            term.status = 1;
            term.setHomePackageNode(newPackage);
        }
        TypedNode oldParent = (TypedNode)selected.getParent();
        dropTarget.add(selected);
        selected.status = 1;
        if (oldParent instanceof DbTermNode) {
            DBTermCloneNode clone = this.addClone(selected, (DbTermNode)oldParent);
            clone.status = (short)3;
        }
        this.getModel().reload(selected);
        return newPackage;
    }

    public void movePackage(PackageNode selected, PackageNode dropTarget) {
        this.getModel().removeNodeFromParent(selected);
        this.getModel().insertNodeInto(selected, dropTarget, 0);
        selected.status = 1;
        this.getModel().reload(selected);
    }

    public void moveTerm(DbTermNode selected, DbTermNode dropTarget) {
        TypedNode oldParent = (TypedNode)selected.getParent();
        this.getModel().removeNodeFromParent(selected);
        this.getModel().insertNodeInto(selected, dropTarget, 0);
        selected.status = 1;
        if (oldParent instanceof DbTermNode) {
            DBTermCloneNode clone = this.addClone(selected, (DbTermNode)oldParent);
            clone.status = (short)3;
        }
        this.getModel().reload(selected);
        this.getModel().reload(oldParent);
    }

    public DBTermCloneNode addClone(DbTermNode selected, DbTermNode dropTarget) {
        DBTermCloneNode newNode = new DBTermCloneNode(selected);
        newNode.showPackageInformation = true;
        newNode.setHomePackageNode(dropTarget.getHomePackageNode());
        this.getModel().insertNodeInto(newNode, dropTarget, 0);
        newNode.status = 1;
        this.getModel().reload(newNode);
        return newNode;
    }

    public Vector<PackageNode> getAllPackage() {
        Vector<PackageNode> allnode = new Vector<PackageNode>();
        allnode.add((PackageNode)this.getTop());
        this.getPackages((PackageNode)this.getTop(), allnode);
        return allnode;
    }

    private void getPackages(PackageNode node, Vector<PackageNode> allnode) {
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            if (!(node.getChildAt(i2) instanceof PackageNode)) continue;
            allnode.add((PackageNode)node.getChildAt(i2));
            this.getPackages((PackageNode)node.getChildAt(i2), allnode);
        }
    }

    public static Vector<DbTermNode> getTermsInPackage(PackageNode pkg) {
        Vector<DbTermNode> allnode = new Vector<DbTermNode>();
        for (int i2 = 0; i2 < pkg.getChildCount(); ++i2) {
            if (!(pkg.getChildAt(i2) instanceof DbTermNode)) continue;
            allnode.add((DbTermNode)pkg.getChildAt(i2));
            PackageTree.getTerms((DbTermNode)pkg.getChildAt(i2), allnode);
        }
        return allnode;
    }

    private static void getTerms(DbTermNode node, Vector<DbTermNode> allnode) {
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            if (!(node.getChildAt(i2) instanceof DbTermNode) || node.getChildAt(i2) instanceof DBTermCloneNode) continue;
            allnode.add((DbTermNode)node.getChildAt(i2));
            PackageTree.getTerms((DbTermNode)node.getChildAt(i2), allnode);
        }
    }

    public void mergeTerm(DbTermNode selected, DbTermNode dropTarget) {
        selected.status = (short)4;
        try {
            selected.setMergedWith(dropTarget);
            this.getModel().reload(selected);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

