/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.DragDropListener;
import java.sql.Connection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class PackageTreeDargDropListener
extends DragDropListener {
    PackageTree tree;
    Connection db;

    public PackageTreeDargDropListener(Connection db2, PackageTree tree) {
        this.db = db2;
        this.tree = tree;
    }

    public boolean canDrop(TreeNode selected, TreeNode dropTarget) {
        if (dropTarget instanceof DBTermCloneNode) {
            return false;
        }
        ATOTreeNode source = (ATOTreeNode)selected;
        ATOTreeNode target = (ATOTreeNode)dropTarget;
        if (source.isReadOnly() || target.isReadOnly()) {
            return false;
        }
        if (target.isDeleted() || target.isMerged()) {
            return false;
        }
        if (source instanceof DbTermNode) {
            DbTermNode theTerm = (DbTermNode)source;
            Iterator<DBTermCloneNode> i$ = theTerm.cloned.iterator();
            while (i$.hasNext()) {
                DBTermCloneNode c2 = i$.next();
                if (!target.isNodeChild(c2)) continue;
                Debug.trace("A clone of the selected node is already the child of the target.\nYou can't drop the selected node here.");
                return false;
            }
        }
        return true;
    }

    public void onDrop(TreeNode selected, TreeNode dropTarget) {
        if (!this.canDrop(selected, dropTarget)) {
            return;
        }
        if (selected instanceof DbTermNode) {
            if (selected.getParent() == dropTarget) {
                return;
            }
            if (dropTarget instanceof DbTermNode) {
                this.moveTermToTerm((DbTermNode)selected, (DbTermNode)dropTarget);
            } else if (dropTarget instanceof PackageNode) {
                this.moveBranch((DbTermNode)selected, (PackageNode)dropTarget);
            }
        } else if (selected instanceof PackageNode && dropTarget instanceof PackageNode) {
            PackageNode sourcePkg = (PackageNode)selected;
            PackageNode targetPkg = (PackageNode)dropTarget;
            this.movePackageToPackage(sourcePkg, targetPkg);
        }
    }

    private void movePackageToPackage(PackageNode sourcePkg, PackageNode targetPkg) {
        if (sourcePkg.getViewMode().equals(targetPkg.getViewMode())) {
            int answer = JOptionPane.showConfirmDialog(null, "Move here (NO to merge)? ");
            if (answer == 0) {
                this.tree.movePackage(sourcePkg, targetPkg);
            } else {
                for (int i2 = 0; i2 < sourcePkg.getChildCount(); ++i2) {
                    ATOTreeNode n2 = (ATOTreeNode)sourcePkg.getChildAt(i2);
                    if (n2 instanceof PackageNode) {
                        this.tree.getModel().removeNodeFromParent(n2);
                        this.tree.getModel().insertNodeInto(n2, targetPkg, 0);
                        n2.status = 1;
                        continue;
                    }
                    if (!(n2 instanceof DbTermNode)) continue;
                    this.tree.moveBranch((DbTermNode)n2, targetPkg);
                }
                sourcePkg.status = (short)2;
            }
        }
    }

    private void moveTermToTerm(DbTermNode selected, DbTermNode dropTarget) {
        if (selected.getHomePackageNode() == dropTarget.getHomePackageNode()) {
            String MOVE = "Move as sub term";
            String CLONE = "Add a relation to this term";
            String MERGE = "Merge with this term";
            Object[] possibleValues = new Object[]{MOVE, CLONE, MERGE};
            Object selectedValue = JOptionPane.showInputDialog(null, "Choose one", "Input", 1, null, possibleValues, possibleValues[0]);
            if (MOVE.equals(selectedValue)) {
                this.tree.moveTerm(selected, dropTarget);
            } else if (CLONE.equals(selectedValue)) {
                DBTermCloneNode newNode = this.tree.addClone(selected, dropTarget);
                newNode.showPackageInformation = false;
            } else if (MERGE.equals(selectedValue)) {
                this.tree.mergeTerm(selected, dropTarget);
            }
        } else {
            int answer = JOptionPane.showConfirmDialog(null, "Move the branch to new package? (NO to clone the selected node only)? ");
            if (answer == 0) {
                this.moveBranch(selected, dropTarget);
            } else {
                this.tree.addClone(selected, dropTarget);
            }
        }
    }

    void moveBranch(DbTermNode selected, ATOTreeNode target) {
        String oldPackage = selected.getHomePackageNode().getLocalName();
        boolean same = selected.getHomePackageNode().getViewMode().equals(target.getViewMode());
        if (!same) {
            Debug.trace("The two package have different hierarchy view mode, cannot move the selected branch");
            return;
        }
        PackageNode newPackage = this.tree.moveBranch(selected, target);
        Debug.trace("You move the branch under " + selected.getLocalName() + " from package " + oldPackage + " to package " + newPackage.getLocalName());
    }

    public boolean canDrag(TreeNode selected) {
        ATOTreeNode source = (ATOTreeNode)selected;
        boolean readOnly = source.isReadOnly();
        boolean isDeleted = source.isDeleted();
        boolean isMerged = source.isMerged();
        return !readOnly && !isDeleted && !isMerged;
    }
}

