/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.TypedTreePanel;
import edu.iastate.ato.gui.packageview.Package2Tree;
import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.gui.packageview.PackageTreeDargDropListener;
import edu.iastate.ato.gui.packageview.PackageTreeEditor;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.ATOTreeRender;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.MetaTreeNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.ato.tree.Term2Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class PackageView
extends TypedTreePanel {
    Connection db;
    public ATOTreeRender treeRender;
    public PackageTreeEditor treeEditor;
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();

    public PackageView(Connection db2) {
        try {
            this.db = db2;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        Package2Tree mm = new Package2Tree(this.db);
        this.treeOntology = mm.getTree(null, -1);
        this.treeRender = new ATOTreeRender();
        this.treeOntology.setCellRenderer(this.treeRender);
        this.treeEditor = new PackageTreeEditor((PackageTree)this.treeOntology, this.db);
        this.treeOntology.addMouseListener(this.treeEditor);
        this.treeOntology.addMouseListener(new TreeClickListener(this.treeOntology));
        this.treeOntology.enableDragDrop = true;
        PackageTreeDargDropListener l2 = new PackageTreeDargDropListener(this.db, (PackageTree)this.treeOntology);
        this.treeOntology.addDrageDropListener(l2);
        this.jScrollPane1.getViewport().add(this.treeOntology);
    }

    public void onExpand() {
        TypedNode selected = (TypedNode)this.treeOntology.getSelectedNode();
        if (selected instanceof PackageNode) {
            this.expandPackage((PackageNode)selected);
            this.treeOntology.getModel().reload(selected);
        } else if (selected instanceof MetaTreeNode) {
            PackageNode pkg = (PackageNode)selected.getParent();
            pkg.treeLoader.addObsoleteTerms(selected, pkg);
        }
    }

    public void expandPackage(PackageNode thePackage) {
        this.treeEditor.expandPackage(thePackage);
    }

    class TreeClickListener
    extends MouseAdapter {
        TypedTree tree;

        public TreeClickListener(TypedTree tree) {
            this.tree = tree;
        }

        public void mouseClicked(MouseEvent e2) {
            TreePath selPath = this.tree.getPathForLocation(e2.getX(), e2.getY());
            if (selPath == null) {
                return;
            }
            ATOTreeNode selectedNode = (ATOTreeNode)selPath.getLastPathComponent();
            this.tree.setSelectionPath(selPath);
            if (e2.getClickCount() == 1) {
                MOEditor.theInstance.paneDetails.update(selectedNode);
            } else if (e2.getClickCount() == 2) {
                this.onDoubleClick(selectedNode);
            }
        }

        private void onDoubleClick(ATOTreeNode selectedNode) {
            if (selectedNode instanceof PackageNode) {
                PackageNode thePackage = (PackageNode)selectedNode;
                if (!thePackage.expanded) {
                    int answer = JOptionPane.showConfirmDialog(null, "Reload from database? ");
                    if (answer == 0) {
                        PackageView.this.expandPackage(thePackage);
                    }
                } else {
                    PackageView.this.expandPackage(thePackage);
                }
            } else if (selectedNode instanceof DBTermCloneNode) {
                DbTermNode source = ((DBTermCloneNode)selectedNode).sourceNode;
                this.tree.expandNode(source);
                this.tree.setSelectionPath(TypedTree.getPath(source));
            } else if (selectedNode instanceof DbTermNode) {
                DbTermNode theTerm = (DbTermNode)selectedNode;
                if (theTerm.hasMore) {
                    PackageNode hp = theTerm.getHomePackageNode();
                    Term2Tree treeLoader = hp.treeLoader;
                    treeLoader.buildDAG(1, theTerm, hp);
                }
            }
        }
    }
}

