/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.panel;

import edu.iastate.ato.gui.panel.NavigationPanel;
import edu.iastate.ato.gui.panel.StatisticsPanel;
import edu.iastate.ato.gui.panel.TermPropertyPanel;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.gui.HolderPanel;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailsPane2
extends HolderPanel
implements MessageHandler {
    Connection db;
    JLabel labelNodeName = new JLabel();
    JPanel buttonPane = new JPanel();
    JButton btnLine = new JButton("Line Panels");
    JButton btnTile = new JButton("Tile Panels");
    JButton btnShowAll = new JButton("Show All");
    HolderPanel allDetails = new HolderPanel();
    NavigationPanel paneSub;
    NavigationPanel paneSuper;
    TermPropertyPanel paneProperty;
    StatisticsPanel paneStat;
    JButton lastCaller = this.btnTile;

    public DetailsPane2() {
        this.messageMap();
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                DetailsPane2.this.onResize();
            }
        });
        this.buttonPane.add(this.btnLine);
        this.buttonPane.add(this.btnTile);
        this.buttonPane.add(this.btnShowAll);
    }

    public void close() {
        this.allDetails.removeAll();
        this.removeAll();
        this.db = null;
    }

    public void rebuild(Connection db2) {
        try {
            this.close();
            this.db = db2;
            this.jbInit();
            this.onTile(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private void jbInit() throws Exception {
        try {
            this.labelNodeName.setHorizontalAlignment(0);
            this.labelNodeName.setText(" ");
            this.add((Component)this.labelNodeName, "North");
            this.add((Component)this.allDetails, "Center");
            this.paneStat = new StatisticsPanel(this.db);
            this.allDetails.addPane(this.paneStat, "Node Statistics");
            this.paneSub = new NavigationPanel(this.db, true);
            this.allDetails.addPane(this.paneSub, "Sub Classes");
            this.paneSuper = new NavigationPanel(this.db, false);
            this.allDetails.addPane(this.paneSuper, "Super Classes");
            this.paneProperty = new TermPropertyPanel(this.db);
            this.allDetails.addPane(this.paneProperty, "Properties");
            this.add((Component)this.buttonPane, "South");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onResize() {
        if (this.lastCaller == this.btnLine) {
            this.onLine(null);
        } else if (this.lastCaller == this.btnTile) {
            this.onTile(null);
        }
    }

    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnLine, this, "onLine");
            MessageMap.mapAction(this.btnTile, this, "onTile");
            MessageMap.mapAction(this.btnShowAll, this, "onShowAll");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onShowAll(ActionEvent evt) {
        this.allDetails.showAll();
        this.onResize();
    }

    public void onLine(ActionEvent evt) {
        if (this.allDetails != null) {
            this.lastCaller = this.btnLine;
            this.allDetails.line();
        }
    }

    public void onTile(ActionEvent evt) {
        if (this.allDetails != null) {
            this.lastCaller = this.btnTile;
            this.allDetails.tile();
        }
    }

    public void update(ATOTreeNode selectedNode) {
        this.labelNodeName.setText(selectedNode.getLocalName());
        if (selectedNode instanceof DbTermNode) {
            ((DbTermNode)selectedNode).getThisTerm().print();
            this.paneSub.update(selectedNode);
            this.paneSuper.update(selectedNode);
            this.makePropertyPane((DbTermNode)selectedNode);
            this.makeStatisticsPane((DbTermNode)selectedNode);
        } else if (selectedNode instanceof PackageNode) {
            this.paneSub.update((ATOTreeNode)null);
            this.paneSuper.update((ATOTreeNode)null);
            this.paneStat.updatePanel((PackageNode)selectedNode);
            this.makePropertyPane(null);
        }
    }

    public void makeStatisticsPane(DbTermNode selectedNode) {
        this.paneStat.updatePanel(selectedNode);
    }

    public void makePropertyPane(DbTermNode selectedNode) {
        this.paneProperty.updatePanel(selectedNode);
    }

    public boolean switchPropertyEditor(ATOTreeNode thePackageNode) {
        if (this.paneProperty.selectedNode != null) {
            boolean enabled = this.paneProperty.selectedNode.getHomePackageNode() != thePackageNode;
            this.paneProperty.enableEditing(enabled);
            return enabled;
        }
        return false;
    }
}

