/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.panel;

import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.gui.LabelledItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class StatisticsPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    Connection db;
    LabelledItemPanel paneForPackageNode = new LabelledItemPanel(3);
    LabelledItemPanel paneForTermNode = new LabelledItemPanel(3);
    JScrollPane termModeView = new JScrollPane();
    JScrollPane packageModeView = new JScrollPane();
    Map<String, JTextField> attributeEditors = new HashMap<String, JTextField>();
    String NAME = "Term";
    String PKG_NAME = "Package";
    String HOME = "Home Package";
    String STATUS = "Status";
    String PKG_STATUS = "Package Status";
    String SLM = "Visiblity";
    String SUBCLASS_NUM = "Direct Subclasses";
    String SUPERCLASS_NUM = "Direct Superclasses";
    String AUTHOR = "Author";
    String PKG_AUTHOR = "Package Author";
    String MODIFIED = "Modified";
    String PKG_MODIFIED = "PAckage Modified";

    public StatisticsPanel(Connection db2) {
        try {
            this.db = db2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.makeTermModeView();
        this.makePackageModeView();
    }

    private void makePackageModeView() {
        Vector<String> pkgStatistics = new Vector<String>();
        pkgStatistics.add(this.PKG_NAME);
        pkgStatistics.add(this.PKG_STATUS);
        pkgStatistics.add(this.PKG_AUTHOR);
        pkgStatistics.add(this.PKG_MODIFIED);
        Iterator i$ = pkgStatistics.iterator();
        while (i$.hasNext()) {
            String property = (String)i$.next();
            JTextField tf = new JTextField();
            this.attributeEditors.put(property, tf);
            this.paneForPackageNode.addItem(property, (JComponent)tf);
            tf.setEditable(false);
        }
        this.packageModeView.getViewport().add(this.paneForPackageNode);
    }

    private void makeTermModeView() {
        Vector<String> termStatistics = new Vector<String>();
        termStatistics.add(this.NAME);
        termStatistics.add(this.HOME);
        termStatistics.add(this.STATUS);
        termStatistics.add(this.SLM);
        termStatistics.add(this.SUBCLASS_NUM);
        termStatistics.add(this.SUPERCLASS_NUM);
        termStatistics.add(this.AUTHOR);
        termStatistics.add(this.MODIFIED);
        Iterator i$ = termStatistics.iterator();
        while (i$.hasNext()) {
            String property = (String)i$.next();
            JTextField tf = new JTextField();
            this.attributeEditors.put(property, tf);
            this.paneForTermNode.addItem(property, (JComponent)tf);
            tf.setEditable(false);
        }
        this.termModeView.getViewport().add(this.paneForTermNode);
    }

    public void updatePanel(PackageNode selectedNode) {
        this.removeAll();
        this.add((Component)this.packageModeView, "Center");
        String oid = selectedNode.getOid();
        this.setProperty(this.PKG_NAME, selectedNode.getLocalName());
        this.repaint();
        String status_str = selectedNode.status2string();
        this.setProperty(this.PKG_STATUS, status_str);
        String str = selectedNode.getThisPackage().author;
        this.setProperty(this.PKG_AUTHOR, str);
        str = selectedNode.getThisPackage().modified;
        this.setProperty(this.PKG_MODIFIED, str);
    }

    public void updatePanel(DbTermNode selectedNode) {
        String count;
        String relation;
        this.removeAll();
        this.add((Component)this.termModeView, "Center");
        String term_oid = selectedNode.getThisTerm().oid;
        Vector allRelations = OntologySchema.getPartialOrders(this.db);
        this.setProperty(this.NAME, selectedNode.getThisTerm().id);
        String pkg_oid = selectedNode.getThisTerm().package_oid;
        DbPackage pkg = DbPackage.read(this.db, pkg_oid);
        this.setProperty(this.HOME, pkg.pid);
        String status_str = selectedNode.status2string();
        this.setProperty(this.STATUS, status_str);
        String slm = ATOTreeNode.type2slm(selectedNode.getType());
        this.setProperty(this.SLM, slm);
        String str = "";
        Iterator i$ = allRelations.iterator();
        while (i$.hasNext()) {
            relation = (String)i$.next();
            count = OntologyQuerier.getDirectSubclassCount(this.db, term_oid, relation);
            str = str + count + "(" + relation + "), ";
        }
        this.setProperty(this.SUBCLASS_NUM, str.substring(0, str.length() - 2));
        str = "";
        i$ = allRelations.iterator();
        while (i$.hasNext()) {
            relation = (String)i$.next();
            count = OntologyQuerier.getDirectSuperclassCount(this.db, term_oid, relation);
            str = str + count + "(" + relation + "), ";
        }
        this.setProperty(this.SUPERCLASS_NUM, str.substring(0, str.length() - 2));
        str = selectedNode.getThisTerm().author;
        this.setProperty(this.AUTHOR, str);
        str = selectedNode.getThisTerm().modified;
        this.setProperty(this.MODIFIED, str);
        this.repaint();
    }

    void setProperty(String attr, String value) {
        JTextField tf = this.attributeEditors.get(attr);
        tf.setText(value);
    }
}

