/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.panel;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.po.TagValuePair;
import edu.iastate.ato.shared.IconLib;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.LabelledItemPanel;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import edu.iastate.utils.sql.LocalDBConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TermPropertyPanel
extends JPanel
implements MessageHandler {
    public DbTermNode selectedNode;
    Connection db;
    JButton btnConfirm = new JButton();
    JButton btnCancel = new JButton();
    JButton btnAdd = new JButton("Add");
    LabelledItemPanel mainPane = new LabelledItemPanel(3);
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel paneButton = new JPanel();
    Vector<String> tp;
    Map<JTextArea, JComponent> allItem = new HashMap<JTextArea, JComponent>();

    public JComboBox makeComboBox() {
        return new JComboBox<String>(this.tp);
    }

    public JTextArea addNewProperty(String attr) {
        JComboBox cb2 = this.makeComboBox();
        cb2.setEditable(false);
        if (attr != null) {
            cb2.setSelectedItem(attr);
        } else if (cb2.getItemCount() > 0) {
            cb2.setSelectedIndex(0);
        }
        JTextArea v2 = new JTextArea();
        this.mainPane.addItem(cb2, (JComponent)v2);
        this.allItem.put(v2, cb2);
        return v2;
    }

    public JTextArea addProperty(String attr, String value) {
        JLabel label = new JLabel(attr);
        JTextArea v2 = new JTextArea(value);
        this.mainPane.addItem(label, (JComponent)v2);
        this.allItem.put(v2, label);
        return v2;
    }

    public String getLabel(JTextArea v2) {
        JComponent label = this.allItem.get(v2);
        if (label instanceof JLabel) {
            return ((JLabel)label).getText();
        }
        if (label instanceof JComboBox) {
            return ((JComboBox)label).getSelectedItem().toString();
        }
        return null;
    }

    public TermPropertyPanel(Connection db2) {
        try {
            this.db = db2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.messageMap();
        this.setLayout(new BorderLayout());
        this.tp = OntologySchema.getTermProperties(this.db);
        this.btnAdd.setToolTipText("Add New Property");
        this.paneButton.add(this.btnAdd);
        this.btnConfirm.setIcon(IconLib.iconOK);
        this.btnConfirm.setToolTipText("Confirm");
        this.paneButton.add(this.btnConfirm);
        this.btnCancel.setIcon(IconLib.iconCancel);
        this.btnCancel.setToolTipText("Cancel");
        this.paneButton.add(this.btnCancel);
        this.jScrollPane1.getViewport().add(this.mainPane);
        this.add((Component)this.paneButton, "South");
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void updatePanel(DbTermNode selectedNode) {
        this.mainPane.clear();
        this.allItem.clear();
        if (selectedNode != null) {
            this.selectedNode = selectedNode;
            String term_oid = selectedNode.getOid();
            boolean readonly = selectedNode.isReadOnly();
            Vector<TagValuePair> all = OntologyQuerier.getTermAllProperty(this.db, term_oid);
            Iterator<TagValuePair> i$ = all.iterator();
            while (i$.hasNext()) {
                TagValuePair pair = i$.next();
                this.addProperty(pair.tag, pair.value);
            }
            this.enableEditing(!readonly);
        }
        this.mainPane.validate();
        this.mainPane.invalidate();
        this.mainPane.repaint();
    }

    public void enableEditing(boolean enabled) {
        Iterator<JTextArea> i$ = this.allItem.keySet().iterator();
        while (i$.hasNext()) {
            JTextArea item = i$.next();
            item.setEditable(enabled);
        }
        this.btnConfirm.setEnabled(enabled);
    }

    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnConfirm, this, "onConfirm");
            MessageMap.mapAction(this.btnCancel, this, "onCancel");
            MessageMap.mapAction(this.btnAdd, this, "onAdd");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onAdd(ActionEvent e2) {
        if (this.tp.size() == 0) {
            Debug.trace("No property available, please edit ontology schema\nMenu: " + MOEditor.theInstance.menuOntologySchema.getText());
            return;
        }
        this.addNewProperty(null);
        this.mainPane.invalidate();
        this.mainPane.validate();
        System.out.println("add new");
    }

    public void onConfirm(ActionEvent e2) {
        String term_oid = this.selectedNode.getOid();
        Iterator<JTextArea> i$ = this.allItem.keySet().iterator();
        while (i$.hasNext()) {
            JTextArea item = i$.next();
            String value = item.getText();
            if (value == null || value.length() <= 0) continue;
            String attr = this.getLabel(item);
            OntologyEdit.addTermProperty(this.db, term_oid, attr, value, MOEditor.user.name);
            this.allItem.get(item).setEnabled(false);
        }
    }

    public void onCancel(ActionEvent e2) {
        this.updatePanel(this.selectedNode);
    }

    public void test() {
        JFrame frame = new JFrame();
        frame.setSize(800, 600);
        JScrollPane scr = new JScrollPane(this);
        frame.getContentPane().add(scr);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        LocalDBConnection conn = MOEditor.getConnection(OntologyServerInfo.getAtoOntology());
        if (conn.connect()) {
            TermPropertyPanel p2 = new TermPropertyPanel(conn.db);
            p2.test();
        } else {
            Debug.trace("Cannot connect to database");
        }
    }
}

