/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.relationview;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.TypedTreePanel;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.tree.ATOTreeRender;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.MetaTreeNode;
import edu.iastate.ato.tree.Term2Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class RelationView
extends TypedTreePanel {
    String relation;
    Connection db;
    MetaTreeNode isolated;
    MetaTreeNode obsolete;
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    Term2Tree treeLoader;

    public RelationView(Connection db2, String relation) {
        try {
            this.db = db2;
            this.relation = relation;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add(this.treeOntology);
        TypedNode root = new TypedNode("Ontology", 1000, this.relation + " hierarchy of the ontology");
        this.isolated = new MetaTreeNode((Object)"Isolated Terms", "Terms have no parents or children is this relation");
        root.add(this.isolated);
        int n2 = OntologyQuerier.getObsoleteTermCount(this.db, null);
        this.obsolete = new MetaTreeNode((Object)("Obsolete(" + n2 + ")"), null);
        root.add(this.obsolete);
        this.treeOntology.setTop(root);
        ATOTreeRender treeRender = new ATOTreeRender();
        this.treeOntology.setCellRenderer(treeRender);
        this.treeOntology.addMouseListener(new TreeClickListener(this.treeOntology));
        this.treeLoader = new Term2Tree(this.db, this.relation, true);
        this.treeLoader.showPackageInformation = false;
    }

    void makeTree() {
        Term2Tree tt = new Term2Tree(this.db, this.relation, true);
        tt.makeDagFromRoots(this.treeOntology.getTop(), 1, false, null);
    }

    public void onExpand() {
        TypedNode selectedNode = (TypedNode)this.treeOntology.getSelectedNode();
        this.expand(selectedNode);
    }

    public void expand(TypedNode selectedNode) {
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof DbTermNode) {
            if (selectedNode instanceof DBTermCloneNode) {
                DbTermNode source = ((DBTermCloneNode)selectedNode).sourceNode;
                this.treeOntology.expandNode(source);
                this.treeOntology.setSelectionPath(TypedTree.getPath(source));
                return;
            }
            if (selectedNode.getChildCount() == 0) {
                this.treeLoader.buildDAG(1, (DbTermNode)selectedNode, null);
            }
        } else if (selectedNode.getType() == 1000) {
            if (selectedNode.getChildCount() == 1) {
                this.treeLoader.makeDagFromRoots(selectedNode, 0, false, null);
            }
        } else if (selectedNode == this.isolated) {
            selectedNode.removeAllChildren();
            this.treeLoader.addIsolatedTerms(selectedNode);
        } else if (selectedNode == this.obsolete) {
            selectedNode.removeAllChildren();
            this.treeLoader.addObsoleteTerms(this.obsolete, null);
        }
        this.treeOntology.getModel().reload(selectedNode);
    }

    class TreeClickListener
    extends MouseAdapter {
        TypedTree tree;

        public TreeClickListener(TypedTree tree) {
            this.tree = tree;
        }

        public void mouseClicked(MouseEvent e2) {
            TreePath selPath = this.tree.getPathForLocation(e2.getX(), e2.getY());
            if (selPath == null) {
                return;
            }
            this.tree.setSelectionPath(selPath);
            TypedNode selectedNode = (TypedNode)selPath.getLastPathComponent();
            if (e2.getClickCount() == 1 && selectedNode instanceof DbTermNode) {
                MOEditor.theInstance.paneDetails.update((DbTermNode)selectedNode);
            }
            if (e2.getClickCount() == 2) {
                RelationView.this.expand(selectedNode);
            }
        }
    }
}

