/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.wizard;

import edu.iastate.ato.gui.wizard.P04_Initialize;
import edu.iastate.ato.gui.wizard.SeverBuilder;
import edu.iastate.ato.po.OntologyServerBuilder;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.LabelledItemPanel;
import edu.iastate.utils.gui.wizard.WizardPanel;
import edu.iastate.utils.sql.JDBCUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class P03_CreateDB
extends WizardPanel {
    SeverBuilder parent;
    Connection superUserConn;
    P04_Initialize next;
    LabelledItemPanel myContentPane = new LabelledItemPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    private JTextField ontologyServerName = new JTextField();
    private JTextField publicUser = new JTextField();
    private JPasswordField password1 = new JPasswordField();
    private JPasswordField password2 = new JPasswordField();
    private JCheckBox existedDB = new JCheckBox();
    private JCheckBox existedUser = new JCheckBox();

    public P03_CreateDB(SeverBuilder parent, Connection db2) {
        try {
            this.parent = parent;
            this.superUserConn = db2;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void update(Connection db2) {
        this.superUserConn = db2;
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        String pattern = "[a-zA-Z][\\s\\w\\-._]*";
        String on = this.ontologyServerName.getText();
        String user = this.publicUser.getText();
        String p1 = new String(this.password1.getPassword());
        String p2 = new String(this.password2.getPassword());
        boolean oldDB = this.existedDB.isSelected();
        boolean oldUser = this.existedUser.isSelected();
        boolean good = true;
        if (on == null || !on.matches(pattern)) {
            list.add("Ontology server name is not legal");
            good = false;
        }
        if (user == null || !user.matches(pattern)) {
            list.add("User is not legal");
            good = false;
        }
        if (p1 == null || p1.trim().length() == 0) {
            list.add("Password cannot be null");
            good = false;
        } else if (!p1.equals(p2)) {
            list.add("Password and its retype don't match");
            good = false;
        }
        if (good) {
            String message;
            if (!oldUser) {
                message = OntologyServerBuilder.createUser(this.superUserConn, user, p1);
                if (!JDBCUtils.isOK(message)) {
                    list.add(message);
                    good = false;
                } else {
                    Debug.trace("User '" + user + "' is successfully created");
                }
            }
            if (good && !oldDB) {
                message = OntologyServerBuilder.createDatabase(this.superUserConn, on, user);
                if (!JDBCUtils.isOK(message)) {
                    list.add(message);
                    good = false;
                    if (!oldUser) {
                        OntologyServerBuilder.deleteUser(this.superUserConn, user);
                    }
                } else {
                    Debug.trace("Database '" + on + "' is successfully created");
                }
            }
        }
        if (good) {
            this.next = new P04_Initialize(this.parent, on, user, p1);
        }
        return good;
    }

    public WizardPanel next() {
        this.parent.p4_init = this.next;
        return this.next;
    }

    public boolean canFinish() {
        return false;
    }

    public boolean validateFinish(List list) {
        return false;
    }

    public void finish() {
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setText("Step 2: Select ontology server name and public access setting");
        this.add((Component)this.jLabel1, "North");
        this.add((Component)this.myContentPane, "Center");
        this.myContentPane.setBorder(BorderFactory.createEtchedBorder());
        this.myContentPane.addItem("Ontology Server Name", (JComponent)this.ontologyServerName);
        this.myContentPane.addItem(" Use existed database", (JComponent)this.existedDB);
        this.myContentPane.addItem("Public User", (JComponent)this.publicUser);
        this.myContentPane.addItem("Use existed user", (JComponent)this.existedUser);
        this.myContentPane.addItem("", (JComponent)new JLabel("Editor will use this account to access the ontology"));
        this.myContentPane.addItem("Public User Password", (JComponent)this.password1);
        this.myContentPane.addItem("Retype Password", (JComponent)this.password2);
    }

    public boolean isExistedDB() {
        return this.existedDB.isSelected();
    }

    public boolean isExistedUser() {
        return this.existedUser.isSelected();
    }

    public String getUser() {
        return this.publicUser.getText();
    }

    public String getOntDB() {
        return this.ontologyServerName.getText();
    }
}

