/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.wizard;

import edu.iastate.ato.gui.wizard.P05_Publish;
import edu.iastate.ato.gui.wizard.SeverBuilder;
import edu.iastate.ato.po.OntologyServerBuilder;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.wizard.WizardPanel;
import edu.iastate.utils.sql.JDBCUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class P04_Initialize
extends WizardPanel {
    SeverBuilder parent;
    String dbName;
    String user;
    String pass;
    public Connection db = null;
    P05_Publish next;
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel title = new JLabel();
    JLabel info = new JLabel();
    JCheckBox checkBoxSkip = new JCheckBox();
    JPanel jPanel1 = new JPanel();

    public P04_Initialize(SeverBuilder parent, String dbName, String user, String pass) {
        try {
            this.parent = parent;
            this.dbName = dbName;
            this.user = user;
            this.pass = pass;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        this.parent.wizard.enableNext(false);
        try {
            String url = "jdbc:postgresql://" + this.parent.p2_host.getHost() + "/" + this.dbName;
            Class.forName("org.postgresql.Driver");
            this.db = DriverManager.getConnection(url, this.user, this.pass);
        }
        catch (SQLException ex) {
            list.add(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            list.add(ex.getMessage());
        }
        if (this.db == null) {
            String str = "Cannot create connection to the ontology database\n";
            str = str + "\nYou may need to change the database configuration to enable internet visiting\nof new created database. Please Do: \n1. Go to PostgreSQL data folder, e.g. C:\\PostgreSQL8.0\\data\n2. Open pg_hba.conf, add a line as \n   host    " + this.dbName + "       all          0.0.0.0          0.0.0.0           trust\n" + "3. Reload the PostgreSQL server\n\n" + "Contact your database administrator if the database is not local";
            Debug.trace(str);
            this.parent.wizard.enableNext(true);
            return false;
        }
        if (this.checkBoxSkip.isSelected()) {
            this.parent.wizard.enableNext(true);
            this.next = new P05_Publish(this.parent, this.db);
            return true;
        }
        String msg = OntologyServerBuilder.createTables(this.db, this.user);
        if (!JDBCUtils.isOK(msg)) {
            list.add(msg);
            this.parent.wizard.enableNext(true);
            return false;
        }
        msg = OntologyServerBuilder.createFunctions(this.db, this.user);
        if (!JDBCUtils.isOK(msg)) {
            list.add(msg);
            this.parent.wizard.enableNext(true);
            return false;
        }
        OntologyServerBuilder.initData(this.db);
        this.parent.wizard.enableNext(true);
        this.info.setText("Ontology Server Initialized");
        Debug.trace("Ontology Server Initialized");
        this.next = new P05_Publish(this.parent, this.db);
        return true;
    }

    public WizardPanel next() {
        this.parent.p5_publish = this.next;
        return this.next;
    }

    public boolean canFinish() {
        return false;
    }

    public boolean validateFinish(List list) {
        return false;
    }

    public void finish() {
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.title.setText("Step 3: Initialize the ontology database server");
        this.info.setFont(new Font("Dialog", 0, 15));
        this.info.setHorizontalAlignment(0);
        this.info.setText("Click Next to create all tables and funtions");
        this.checkBoxSkip.setHorizontalAlignment(0);
        this.checkBoxSkip.setText("Skip");
        this.add((Component)this.info, "Center");
        this.jPanel1.add(this.checkBoxSkip);
        this.add((Component)this.jPanel1, "South");
        this.add((Component)this.title, "North");
    }
}

