/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.po.Stanza;
import edu.iastate.ato.po.TagValuePair;
import edu.iastate.ato.shared.LongTask;
import edu.iastate.utils.sql.JDBCUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBO2DB
extends LongTask {
    Connection db;
    String user;
    Map<String, String> packageOidCache = new HashMap<String, String>();
    Set<String> unknownLabels = new HashSet<String>();
    String global_oid;
    String tempUser = "$tempuser!!!$";
    String prefix = null;

    public OBO2DB(Connection db2, String user) {
        this.db = db2;
        this.user = user;
        this.global_oid = this.getPackageOid("Global");
        System.out.println(new StringBuffer().append("global_oid: ").append(this.global_oid).toString());
    }

    public boolean importOBO(String fileName, boolean filterPrefix) {
        DecimalFormat precent = new DecimalFormat("00.00");
        try {
            this.packageOidCache.clear();
            this.unknownLabels.clear();
            this.prefix = null;
            OntologySchema.initOBOSchema(this.db);
            File theFile = new File(fileName);
            long fileSize = theFile.length();
            System.out.println(new StringBuffer().append("File size ").append(fileSize).toString());
            long totalRead = 0L;
            BufferedReader in = new BufferedReader(new FileReader(theFile));
            String default_namespace = "Unknown";
            Stanza section = Stanza.readStanza(in);
            totalRead += (long)section.totalSize;
            System.err.println(section.stanza);
            if (section == null || section.getType() != 2) {
                return false;
            }
            for (String str : section.stanza) {
                TagValuePair tagvalue = TagValuePair.parseTagValuePair(str);
                if (tagvalue.tag.compareTo("default_namespace") != 0) continue;
                default_namespace = tagvalue.value;
            }
            section = Stanza.readStanza(in);
            totalRead += (long)section.totalSize;
            while (section != null) {
                System.err.println(section.stanza);
                if (section.getType() == 3) {
                    for (String str : section.stanza) {
                        int leading = "![schema]".length();
                        if (!str.startsWith("![schema]")) continue;
                        str = str.substring(leading);
                        TagValuePair t2 = TagValuePair.parseTagValuePair(str);
                        OntologySchema.addPredicate(this.db, t2.tag, t2.value);
                        if (!t2.tag.equals(OntologySchema.PREFIX)) continue;
                        this.prefix = t2.value;
                    }
                    if (!filterPrefix) {
                        this.prefix = null;
                    }
                } else if (section.getType() == 4) {
                    this.addPackageEntry(section.stanza);
                } else if (section.getType() == 5) {
                    this.addTermEntry(section.stanza, default_namespace);
                } else if (section.getType() == 6) {
                    this.addTypedefEntry(section.stanza);
                }
                totalRead = (section = Stanza.readStanza(in)) == null ? fileSize : totalRead + (long)section.totalSize;
                String info = new StringBuffer().append(fileName).append(" ").append(precent.format(100.0 * (double)totalRead / (double)fileSize)).append("% finished (").append(totalRead).append("/").append(fileSize).append(")").toString();
                this.updateProgress(info);
            }
            Vector<String> v2 = OntologySchema.getTermProperties(this.db);
            this.unknownLabels.removeAll(v2);
            for (String label : this.unknownLabels) {
                OntologySchema.addPredicate(this.db, OntologySchema.TERM_PROPERTY, label);
            }
            in.close();
            String sql = new StringBuffer().append("UPDATE relation SET pid = term.oid  WHERE relation.pid = term.id AND  relation.author = '").append(this.tempUser).append("';").toString();
            sql = new StringBuffer().append(sql).append("UPDATE relation SET author = '").append(this.user).append("' WHERE author = '").append(this.tempUser).append("'").toString();
            JDBCUtils.updateDatabase(this.db, sql);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    boolean addTypedefEntry(Vector strings) {
        String id = null;
        String name = null;
        String domain = "";
        String range = "";
        String is_cyclic = "false";
        String is_transitive = "false";
        String is_symmetric = "false";
        for (String str : strings) {
            TagValuePair tagvalue = TagValuePair.parseTagValuePair(str);
            if (tagvalue.tag.compareTo("id") == 0) {
                id = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("name") == 0) {
                name = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("is_transitive") == 0) {
                is_transitive = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("is_symmetric") == 0) {
                is_symmetric = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("is_cyclic") == 0) {
                is_cyclic = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("domain") == 0) {
                domain = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("range") != 0) continue;
            range = tagvalue.value;
        }
        return OntologySchema.addPartialOrders(this.db, id);
    }

    boolean addPackageEntry(Vector<String> strings) {
        String package_id = null;
        String name = null;
        String author = null;
        String modified = null;
        Vector<TagValuePair> pkgRelations = new Vector<TagValuePair>();
        for (String str : strings) {
            String[] s2;
            TagValuePair tagvalue = TagValuePair.parseTagValuePair(str);
            if (tagvalue.tag.compareTo("id") == 0) {
                package_id = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("name") == 0) {
                name = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("author") == 0) {
                author = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("modified") == 0) {
                modified = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("relationship") != 0 || (s2 = tagvalue.value.split("\\s")).length != 2) continue;
            pkgRelations.add(new TagValuePair(s2[0], s2[1]));
        }
        if (package_id == null) {
            return false;
        }
        String oid = this.getPackageOid(package_id);
        DbPackage ppp = new DbPackage(oid, package_id, name, author, modified);
        boolean suc = ppp.write(this.db, author, true);
        if (suc) {
            for (TagValuePair pair : pkgRelations) {
                String relation = pair.tag;
                String parent_id = pair.value;
                String parent_oid = this.getPackageOid(parent_id);
                OntologyEdit.addPackageRelation(this.db, oid, relation, parent_oid, this.user);
            }
        }
        return suc;
    }

    boolean addTermEntry(Vector strings, String default_namespace) {
        String pkg_oid;
        Iterator it = strings.iterator();
        String term_id = null;
        String name = null;
        String namespace = default_namespace;
        String def = null;
        String def_xref = null;
        String comment = null;
        String is_obsolete = "false";
        Vector<String> alt_id = new Vector<String>();
        Vector<String> subset = new Vector<String>();
        Vector<TagValuePair> synonym = new Vector<TagValuePair>();
        Vector<TagValuePair> related_synonym = new Vector<TagValuePair>();
        Vector<TagValuePair> exact_synonym = new Vector<TagValuePair>();
        Vector<TagValuePair> broad_synonym = new Vector<TagValuePair>();
        Vector<TagValuePair> narrow_synonym = new Vector<TagValuePair>();
        Vector<String> xref_analog = new Vector<String>();
        Vector<String> xref_unknown = new Vector<String>();
        Vector<TagValuePair> is_a = new Vector<TagValuePair>();
        Vector<TagValuePair> relationship = new Vector<TagValuePair>();
        Vector<TagValuePair> use_term = new Vector<TagValuePair>();
        Vector<TagValuePair> unknown_tag = new Vector<TagValuePair>();
        String author = this.user;
        String modified = "";
        String package_id = null;
        String slm = "public";
        while (it.hasNext()) {
            TagValuePair t2;
            String str = (String)it.next();
            TagValuePair tagvalue = TagValuePair.parseTagValuePair(str);
            if (tagvalue.tag.compareTo("id") == 0) {
                term_id = this.filterID(tagvalue.value);
                continue;
            }
            if (tagvalue.tag.compareTo("name") == 0) {
                name = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("alt_id") == 0) {
                alt_id.add(this.filterID(tagvalue.value));
                continue;
            }
            if (tagvalue.tag.compareTo("namespace") == 0) {
                namespace = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("def") == 0) {
                t2 = TagValuePair.parseXref(tagvalue.value);
                def = t2.tag;
                def_xref = t2.value;
                continue;
            }
            if (tagvalue.tag.compareTo("comment") == 0) {
                comment = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("subset") == 0) {
                subset.add(tagvalue.value);
                continue;
            }
            if (tagvalue.tag.compareTo("synonym") == 0) {
                t2 = TagValuePair.parseXref(tagvalue.value);
                synonym.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("related_synonym") == 0) {
                t2 = TagValuePair.parseXref(tagvalue.value);
                related_synonym.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("exact_synonym") == 0) {
                t2 = TagValuePair.parseXref(tagvalue.value);
                exact_synonym.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("broad_synonym") == 0) {
                t2 = TagValuePair.parseXref(tagvalue.value);
                broad_synonym.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("narrow_synonym") == 0) {
                t2 = TagValuePair.parseXref(tagvalue.value);
                narrow_synonym.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("xref_analog") == 0) {
                xref_analog.add(tagvalue.value);
                continue;
            }
            if (tagvalue.tag.compareTo("xref_unknown") == 0) {
                xref_unknown.add(tagvalue.value);
                continue;
            }
            if (tagvalue.tag.compareTo("is_a") == 0) {
                t2 = new TagValuePair("is_a", this.filterID(tagvalue.value));
                is_a.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("relationship") == 0) {
                String[] s2 = tagvalue.value.split("\\s");
                if (s2.length != 2) continue;
                relationship.add(new TagValuePair(s2[0], this.filterID(s2[1])));
                continue;
            }
            if (tagvalue.tag.compareTo("is_obsolete") == 0) {
                is_obsolete = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("use_term") == 0) {
                t2 = new TagValuePair("use_term", this.filterID(tagvalue.value));
                use_term.add(t2);
                continue;
            }
            if (tagvalue.tag.compareTo("author") == 0) {
                author = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("modified") == 0) {
                modified = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("package") == 0) {
                package_id = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("slm") == 0) {
                slm = tagvalue.value;
                continue;
            }
            if (tagvalue.tag.compareTo("[Term]") == 0 || tagvalue.tag.trim().length() == 0) continue;
            this.unknownLabels.add(tagvalue.tag);
            unknown_tag.add(tagvalue);
        }
        if (term_id == null || name == null) {
            return false;
        }
        if (package_id == null) {
            package_id = namespace;
        }
        if ((pkg_oid = this.getPackageOid(package_id)) == null) {
            return false;
        }
        String term_oid = OntologyEdit.addTerm(this.db, term_id, name, pkg_oid, slm, is_obsolete, author, modified);
        if (term_oid == null) {
            return false;
        }
        OntologyEdit.addTermProperty(this.db, term_oid, "def", def, this.user);
        OntologyEdit.addTermProperty(this.db, term_oid, "def_xref", def_xref, this.user);
        OntologyEdit.addTermProperty(this.db, term_oid, "comment", comment, this.user);
        for (String item : alt_id) {
            OntologyEdit.addTermProperty(this.db, term_oid, "alt_id", item, this.user);
        }
        for (String item : subset) {
            OntologyEdit.addTermProperty(this.db, term_oid, "subset", item, this.user);
        }
        this.addSynonym(term_oid, "synonym", synonym);
        this.addSynonym(term_oid, "related_synonym", related_synonym);
        this.addSynonym(term_oid, "exact_synonym", exact_synonym);
        this.addSynonym(term_oid, "broad_synonym", broad_synonym);
        this.addSynonym(term_oid, "narrow_synonym", narrow_synonym);
        for (String item : xref_analog) {
            OntologyEdit.addTermProperty(this.db, term_oid, "xref_analog", item, this.user);
        }
        for (String item : xref_unknown) {
            OntologyEdit.addTermProperty(this.db, term_oid, "xref_unknown", item, this.user);
        }
        this.addRelationship(term_oid, is_a);
        this.addRelationship(term_oid, relationship);
        for (TagValuePair t3 : use_term) {
            OntologyEdit.addTermProperty(this.db, term_oid, t3.tag, t3.value, this.user);
        }
        for (TagValuePair t3 : unknown_tag) {
            OntologyEdit.addTermProperty(this.db, term_oid, t3.tag, t3.value, this.user);
        }
        return true;
    }

    private String getPackageOid(String namespace) {
        String oid = this.packageOidCache.get(namespace);
        if (oid == null) {
            oid = OntologyQuerier.getPackageOid(this.db, namespace);
            if (oid == null) {
                oid = OntologyEdit.addPackage(this.db, namespace, namespace, this.user);
                OntologyEdit.addPackageNesting(this.db, oid, this.global_oid, this.user);
            }
            this.packageOidCache.put(namespace, oid);
        }
        return oid;
    }

    void addRelationship(String term_oid, Vector<TagValuePair> source_id) {
        for (TagValuePair t2 : source_id) {
            OntologyEdit.addTermRelation(this.db, term_oid, t2.tag, t2.value, this.tempUser);
        }
    }

    void addSynonym(String term_oid, String type, Vector<TagValuePair> source) {
        for (int i2 = 0; i2 < source.size(); ++i2) {
            TagValuePair t2 = source.elementAt(i2);
            OntologyEdit.addTermProperty(this.db, term_oid, type, t2.toXref(), this.user);
        }
    }

    String filterID(String id) {
        if (this.prefix == null) {
            return id;
        }
        return id.replaceAll(new StringBuffer().append(this.prefix).append(":").toString(), "");
    }
}

