/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.shared.AtoConstent;
import edu.iastate.utils.sql.JDBCUtils;
import edu.iastate.utils.sql.LocalDBConnection;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyEdit
implements AtoConstent {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    public static void main(String[] args) {
        LocalDBConnection ds = MOEditor.getConnection(OntologyServerInfo.getAtoOntology());
        ds.connect();
        OntologyEdit dmo = new OntologyEdit();
    }

    public static boolean addTermProperty(Connection db2, String term_oid, String property, String value, String user) {
        if (property == null || value == null) {
            return false;
        }
        HashMap<String, String> field_value = new HashMap<String, String>();
        field_value.put("term", term_oid);
        field_value.put("attribute", property);
        field_value.put("value", value);
        field_value.put("author", user);
        field_value.put("modified", OntologyEdit.getTime());
        Vector<String> pks = new Vector<String>();
        pks.add("term");
        pks.add("attribute");
        return JDBCUtils.insertOrUpdateDatabase(db2, "details", field_value, pks);
    }

    public static String getTime() {
        return dateFormat.format(new Date());
    }

    public static String addTerm(Connection db2, String id, String comment, String pkg, String slm, String is_obsolete, String author) {
        return OntologyEdit.addTerm(db2, id, comment, pkg, slm, is_obsolete, author, OntologyEdit.getTime());
    }

    public static String addTerm(Connection db2, String id, String comment, String pkg, String slm, String is_obsolete, String author, String modified) {
        HashMap<String, String> field_value = new HashMap<String, String>();
        field_value.put("id", id);
        field_value.put("name", comment);
        field_value.put("slm", slm);
        field_value.put("is_obsolete", is_obsolete);
        field_value.put("package", pkg);
        field_value.put("author", author);
        field_value.put("modified", modified);
        JDBCUtils.insertOrUpdateDatabase(db2, "term", field_value, "id");
        return OntologyQuerier.getTermOid(db2, id);
    }

    public static String addPackage(Connection db2, String pid, String comment, String author) {
        return OntologyEdit.addPackage(db2, pid, comment, author, OntologyEdit.getTime());
    }

    public static String addPackage(Connection db2, String pid, String comment, String author, String modified) {
        HashMap<String, String> field_value = new HashMap<String, String>();
        field_value.put("pid", pid);
        field_value.put("comment", comment);
        field_value.put("author", author);
        field_value.put("modified", modified);
        JDBCUtils.insertOrUpdateDatabase(db2, "package", field_value, "pid");
        return OntologyQuerier.getPackageOid(db2, pid);
    }

    public static boolean addPackageRelation(Connection db2, String p1_oid, String r2, String p2_oid, String author) {
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("p1", p1_oid);
        m2.put("relation", r2);
        m2.put("p2", p2_oid);
        m2.put("author", author);
        m2.put("modified", OntologyEdit.getTime());
        return JDBCUtils.insertOrDoNothing(db2, "pkg_relation", m2, new String[]{"p1", "relation", "p2"});
    }

    public static boolean addTermRelation(Connection db2, String id, String relation, String pid, String author) {
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("id", id);
        m2.put("relation", relation);
        m2.put("pid", pid);
        m2.put("author", author);
        m2.put("modified", OntologyEdit.getTime());
        return JDBCUtils.insertOrDoNothing(db2, "relation", m2, new String[]{"id", "relation", "pid"});
    }

    public static boolean addPackageNesting(Connection db2, String p1_oid, String p2_oid, String author) {
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("p1", p1_oid);
        m2.put("relation", "nested_in");
        m2.put("p2", p2_oid);
        m2.put("author", author);
        m2.put("modified", OntologyEdit.getTime());
        return JDBCUtils.insertOrUpdateDatabase(db2, "pkg_relation", m2, new String[]{"p1", "relation"});
    }

    public static void deletePackageRelation(Connection db2, String p1_oid, String r2, String p2_oid) {
        String sql = new StringBuffer().append("DELETE FROM pkg_relation WHERE p1 = '").append(p1_oid).append("' AND p2 = '").append(p2_oid).append("' AND relation = '").append(r2).append("';").toString();
        JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean deletePackage(Connection db2, String pkg_oid, String user) {
        if (OntologyQuerier.getTermCount(db2, pkg_oid) > 0) {
            OntologyEdit.obsoletePackage(db2, pkg_oid, user);
            return false;
        }
        String sql = new StringBuffer().append("DELETE FROM package WHERE oid = '").append(pkg_oid).append("';").toString();
        JDBCUtils.updateDatabase(db2, sql);
        sql = new StringBuffer().append("DELETE FROM pkg_relation WHERE p1 = '").append(pkg_oid).append("';").toString();
        JDBCUtils.updateDatabase(db2, sql);
        return true;
    }

    public static boolean destroyTerm(Connection db2, String term_oid) {
        String sql = new StringBuffer().append("DELETE FROM term WHERE oid = '").append(term_oid).append("';").toString();
        sql = new StringBuffer().append(sql).append("DELETE FROM relation WHERE id = '").append(term_oid).append("' OR pid = '").append(term_oid).append("'").toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static void obsoleteTerm(Connection db2, String term_oid, String user) {
        String sql = new StringBuffer().append("UPDATE term SET is_obsolete = 'true', author = '").append(user).append("', modified = '").append(OntologyEdit.getTime()).append("' ").append("WHERE oid = '").append(term_oid).append("';").toString();
        sql = new StringBuffer().append(sql).append("DELETE FROM relation WHERE id = '").append(term_oid).append("' OR pid = '").append(term_oid).append("';").toString();
        sql = new StringBuffer().append(sql).append("DELETE FROM details WHERE term ='").append(term_oid).append("';").toString();
        JDBCUtils.updateDatabase(db2, sql);
    }

    public static void obsoletePackage(Connection db2, String package_oid, String user) {
        String localTerms = new StringBuffer().append("(SELECT id FROM term WHERE package = '").append(package_oid).append("')").toString();
        String sql = new StringBuffer().append("UPDATE term SET is_obsolete = 'true', author = '").append(user).append("', modified = '").append(OntologyEdit.getTime()).append("' ").append("WHERE is_obsolete <> 'true' AND package = '").append(package_oid).append("';\n").toString();
        sql = new StringBuffer().append(sql).append("DELETE FROM relation WHERE id IN ").append(localTerms).append(";\n").toString();
        sql = new StringBuffer().append(sql).append("DELETE FROM relation WHERE pid IN ").append(localTerms).append(";\n").toString();
        sql = new StringBuffer().append(sql).append("DELETE FROM details WHERE term IN ").append(localTerms).append(";").toString();
        String msg = JDBCUtils.updateDatabaseM(db2, sql);
        System.out.println(msg);
    }

    public static boolean deleteTermRelation(Connection db2, String id, String parent, String relation) {
        String sql = new StringBuffer().append("DELETE FROM relation WHERE id = '").append(id).append("' AND pid = '").append(parent).append("'").append(" AND relation = '").append(relation).append("'").toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean moveTerm(Connection db2, String term_oid, String pkg1, String pkg2) {
        String sql = new StringBuffer().append("UPDATE term SET package = '").append(pkg2).append("' WHERE oid = '").append(term_oid).append("' AND package = '").append(pkg1).append("'").append(";").toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean moveTerm(Connection db2, Vector<String> oids, String pkg1, String pkg2) {
        String sql = new StringBuffer().append("UPDATE term SET package = '").append(pkg2).append("' WHERE package = '").append(pkg1).append("' AND id IN (").toString();
        String ID = "";
        for (String term : oids) {
            ID = new StringBuffer().append(ID).append("'").append(term).append("',").toString();
        }
        ID = ID.substring(0, ID.length() - 1);
        sql = new StringBuffer().append(sql).append(ID).append(")").toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static void mergeTerm(Connection db2, String oid_killed, String oid_leave, String user) {
        String sql = new StringBuffer().append(" UPDATE relation SET id = '").append(oid_leave).append("' , author = '").append(user).append("', modified = '").append(OntologyEdit.getTime()).append("' WHERE id = '").append(oid_killed).append("'").toString();
        JDBCUtils.updateDatabase(db2, sql);
        sql = new StringBuffer().append(" UPDATE relation SET pid = '").append(oid_leave).append("' , author = '").append(user).append("', modified = '").append(OntologyEdit.getTime()).append("' WHERE pid = '").append(oid_killed).append("'").toString();
        JDBCUtils.updateDatabase(db2, sql);
        sql = new StringBuffer().append("DELETE FROM details WHERE term =  '").append(oid_killed).append("'").toString();
        JDBCUtils.updateDatabase(db2, sql);
        sql = new StringBuffer().append("DELETE FROM term WHERE oid = '").append(oid_killed).append("'").toString();
        JDBCUtils.updateDatabase(db2, sql);
    }

    public static String applyID(Connection db2, String term_oid) {
        String sql = new StringBuffer().append("INSERT INTO auto_id (term_oid) VALUES ('").append(term_oid).append("')").toString();
        boolean suc = JDBCUtils.updateDatabase(db2, sql);
        if (suc) {
            sql = new StringBuffer().append("SELECT id FROM auto_id WHERE term_oid = '").append(term_oid).append("'").toString();
            return JDBCUtils.getFirstValue(db2, sql);
        }
        return null;
    }
}

