/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.po.naming.NamingPolicy;
import edu.iastate.utils.Utility;
import edu.iastate.utils.sql.JDBCUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologySchema {
    public static String PARTIAL_ORDER = "partial-order";
    public static String TERM_PROPERTY = "term-property";
    public static String NAMING_POLICY = "naming-policy";
    public static String PREFIX = "prefix";
    Vector<String> allPartialOrders = new Vector();
    Vector<String> allTermProperties = new Vector();
    NamingPolicy namingPolicy;
    String prefix;
    public static String[] obo_properties = new String[]{"alt_id", "namespace", "def", "def_xref", "comment", "subset", "synonym", "related_synonym", "exact_synonym", "broad_synonym", "narrow_synonym", "xref_analog", "xref_unknown", "use_term"};

    public static String clear(Connection db2, String type) {
        String sql = "DELETE FROM schema ";
        if (type != null) {
            sql = new StringBuffer().append(sql).append("WHERE type = '").append(type).append("'").toString();
        }
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static Vector getPredicate(Connection db2, String name) {
        String sql = new StringBuffer().append("SELECT name FROM schema WHERE type = '").append(name).append("' ORDER BY name").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static Vector getPartialOrders(Connection db2) {
        return OntologySchema.getPredicate(db2, PARTIAL_ORDER);
    }

    public static boolean addPartialOrders(Connection db2, String relation) {
        HashMap<String, String> field_value = new HashMap<String, String>();
        field_value.put("type", PARTIAL_ORDER);
        field_value.put("name", relation);
        return JDBCUtils.insertOrDoNothing(db2, "schema", field_value, new String[]{"type", "name"});
    }

    public static boolean addPredicate(Connection db2, String type, String name) {
        HashMap<String, String> field_value = new HashMap<String, String>();
        field_value.put("type", type);
        field_value.put("name", name);
        return JDBCUtils.insertOrDoNothing(db2, "schema", field_value, new String[]{"type", "name"});
    }

    public static Vector<String> getTermProperties(Connection db2) {
        return OntologySchema.getPredicate(db2, TERM_PROPERTY);
    }

    public static String getNamingPolicy(Connection db2) {
        String sql = new StringBuffer().append("SELECT name FROM schema WHERE type = '").append(NAMING_POLICY).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getPrefix(Connection db2) {
        String sql = new StringBuffer().append("SELECT name FROM schema WHERE type = '").append(PREFIX).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static void setPrefix(Connection db2, String prefix) {
        HashMap<String, String> field_value = new HashMap<String, String>();
        field_value.put("type", PREFIX);
        field_value.put("name", prefix);
        JDBCUtils.insertOrUpdateDatabase(db2, "schema", field_value, new String[]{"type"});
    }

    public static void initOBOSchema(Connection db2) {
        String sql = "";
        for (int i2 = 0; i2 < obo_properties.length; ++i2) {
            sql = new StringBuffer().append(sql).append("DELETE FROM schema WHERE type = '").append(TERM_PROPERTY).append("' AND name = '").append(obo_properties[i2]).append("';\n").toString();
            sql = new StringBuffer().append(sql).append("INSERT INTO schema (type, name) VALUES ( '").append(TERM_PROPERTY).append("', '").append(obo_properties[i2]).append("');\n").toString();
        }
        JDBCUtils.updateDatabase(db2, sql);
    }

    static boolean isOBOProperty(String prop) {
        Object[] sys = new String[]{"alt_id", "namespace", "def", "def_xref", "comment", "subset", "synonym", "related_synonym", "exact_synonym", "broad_synonym", "narrow_synonym", "xref_analog", "xref_unknown", "relationship", "is_obsolete", "use_term", "is_a"};
        return Utility.Array2Vector(sys).contains(prop);
    }
}

