/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.utils.string.ParserUtils;

public class TagValuePair {
    public String tag;
    public String value;

    public TagValuePair(String tag, String value) {
        this.tag = tag;
        this.value = value;
    }

    public String toString() {
        return this.tag + (this.value == null ? "" : ":" + this.value);
    }

    public String toXref() {
        if (this.value == null) {
            return this.tag;
        }
        return this.tag + " \"" + this.value + "\"";
    }

    static TagValuePair parseXref(String xref) {
        String def_xref;
        String def = ParserUtils.findFirst("\\\".*\\\"", xref);
        if (def != null) {
            def = def.substring(1, def.length() - 1);
        }
        if ((def_xref = ParserUtils.findFirst("\\[.*?\\]", xref)) != null) {
            def_xref = def_xref.substring(1, def_xref.length() - 1);
        }
        return new TagValuePair(def, def_xref);
    }

    static TagValuePair parseTagValuePair(String str) {
        int limiter;
        int comments;
        if (str.startsWith("![attribute]")) {
            str = str.substring("![attribute]".length());
        }
        if ((comments = str.indexOf("!")) > 0) {
            str = str.substring(0, comments);
        }
        if ((limiter = (str = str.replaceAll("'", "\"")).indexOf(":")) > 0) {
            String tag = str.substring(0, limiter).trim();
            String value = str.substring(limiter + 1).trim();
            return new TagValuePair(tag, value);
        }
        return new TagValuePair(str, "");
    }
}

