/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.tree;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.po.DbTerm;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.shared.IconLib;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.PackageNode;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;

public class DbTermNode
extends ATOTreeNode {
    public DbTerm thisTerm;
    private PackageNode homePackageNode;
    public DbTermNode mergedWith;
    public boolean showPackageInformation = false;
    public boolean hasMore = false;
    public HashSet<DBTermCloneNode> cloned = new HashSet();

    public DbTermNode(DbTerm thisTerm, PackageNode homePackageNode) {
        super((Object)thisTerm.id, thisTerm.name, DbTermNode.slm2type(thisTerm.slm));
        this.thisTerm = thisTerm;
        this.homePackageNode = homePackageNode;
        if (homePackageNode != null && homePackageNode.status == 2) {
            this.status = (short)2;
        }
    }

    public String toString() {
        String str = "";
        if (this.showPackageInformation) {
            String more = this.comment == null ? "" : (String)this.comment;
            more = this.homePackageNode != null ? "@" + this.homePackageNode.getLocalName() + " : " + more : " : " + more;
            str = this.getUserObject() + more;
        } else {
            str = super.toString();
        }
        if (this.mergedWith != null) {
            String m2 = "[-> " + this.mergedWith.getUserObject() + "]";
            str = m2 + str;
        }
        return str;
    }

    public void addCloned(DBTermCloneNode n2) {
        this.cloned.add(n2);
    }

    public void removeCloned(DBTermCloneNode n2) {
        this.cloned.remove(n2);
    }

    public void setType(short t2) {
        super.setType(t2);
        if (this.cloned != null) {
            Iterator<DBTermCloneNode> i$ = this.cloned.iterator();
            while (i$.hasNext()) {
                DBTermCloneNode c2 = i$.next();
                c2.setType(t2);
            }
        }
        if (this.thisTerm != null) {
            this.thisTerm.slm = DbTermNode.type2slm(t2);
        }
    }

    public Icon getIcon() {
        if (this.hasMore) {
            if (this.getType() == 1006) {
                return IconLib.iconPublicPlus;
            }
            if (this.getType() == 1007) {
                return IconLib.iconProtectedPlus;
            }
            if (this.getType() == 1007) {
                return IconLib.iconPrivatePlus;
            }
        }
        return null;
    }

    public void setUserObject(Object obj) {
        super.setUserObject(obj);
        Iterator<DBTermCloneNode> i$ = this.cloned.iterator();
        while (i$.hasNext()) {
            DBTermCloneNode c2 = i$.next();
            c2.setUserObject(obj);
        }
        this.thisTerm.id = (String)obj;
    }

    public void setComment(Object obj) {
        super.setComment(obj);
        Iterator<DBTermCloneNode> i$ = this.cloned.iterator();
        while (i$.hasNext()) {
            DBTermCloneNode c2 = i$.next();
            c2.setComment(obj);
        }
        this.thisTerm.name = (String)obj;
    }

    public boolean isObsolete() {
        return this.thisTerm.is_obsolete.equalsIgnoreCase("true");
    }

    public boolean isReadOnly() {
        return this.homePackageNode.isReadOnly() || this.isObsolete();
    }

    public String getViewMode() {
        return this.homePackageNode.getViewMode();
    }

    public void save(Connection db2) {
        if (this.thisTerm.package_oid == null || this.thisTerm.package_oid.length() == 0) {
            this.thisTerm.package_oid = this.homePackageNode.getOid();
        }
        this.thisTerm.write(db2);
        this.setUserObject(this.thisTerm.id);
    }

    public void markDeleted() {
        this.status = (short)2;
        Iterator<DBTermCloneNode> i$ = this.cloned.iterator();
        while (i$.hasNext()) {
            DBTermCloneNode c2 = i$.next();
            c2.status = (short)2;
        }
    }

    public void merge(Connection db2) {
        if (this.mergedWith != null) {
            String oid_killed = this.thisTerm.oid;
            String oid_leave = this.mergedWith.getOid();
            String user = MOEditor.user.name;
            OntologyEdit.mergeTerm(db2, oid_killed, oid_leave, user);
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                this.mergedWith.add((DbTermNode)this.getChildAt(i2));
            }
            Iterator<DBTermCloneNode> i$ = this.cloned.iterator();
            while (i$.hasNext()) {
                DBTermCloneNode c2 = i$.next();
                c2.updateSourceNode(this.mergedWith);
            }
            this.removeFromParent();
        }
    }

    public String getOid() {
        return this.thisTerm.oid;
    }

    public PackageNode getHomePackageNode() {
        return this.homePackageNode;
    }

    public DbTerm getThisTerm() {
        return this.thisTerm;
    }

    public void setHomePackageNode(PackageNode homePackageNode) {
        this.homePackageNode = homePackageNode;
        this.thisTerm.package_oid = homePackageNode.getOid();
    }

    public void setMergedWith(DbTermNode mergedWith) throws Exception {
        if (mergedWith != null) {
            if (mergedWith.getHomePackageNode() != this.homePackageNode) {
                throw new Exception("Term can only be merged inside a package!");
            }
            this.status = (short)4;
            this.mergedWith = mergedWith;
        }
    }

    public String getLocalName() {
        return this.getUserObject().toString();
    }

    public String status2string() {
        if (this.isObsolete()) {
            return "Obsolete";
        }
        if (this.mergedWith != null) {
            return "Merged with " + this.mergedWith.getUserObject() + "";
        }
        if (this.getOid() == null) {
            return "New Created and not Saved";
        }
        return super.status2string();
    }
}

