/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.tree;

import edu.iastate.anthill.indus.iterator.DBTreeNode;
import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.DbTerm;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.shared.LongTask;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Term2Tree
extends LongTask {
    protected Connection db;
    String relation;
    boolean topdown;
    public boolean showPackageInformation = false;
    Map<String, TypedNode> representatives = new HashMap<String, TypedNode>();

    public Term2Tree(Connection db2, String relation, boolean topdown) {
        this.db = db2;
        this.relation = relation;
        this.topdown = topdown;
    }

    public void addIsolatedTerms(TypedNode parent) {
        Vector terms = OntologyQuerier.getIsolatedTerms(this.db, this.relation);
        int number = terms.size();
        for (int i2 = 0; i2 < number; ++i2) {
            String t2 = (String)terms.elementAt(i2);
            DbTermNode node = this.createNode(t2, (PackageNode)null);
            parent.add(node);
            this.updateProgress(new StringBuffer().append("Read isolated node (").append(i2).append(" of ").append(number).append(")").append(node.getLocalName()).toString());
        }
    }

    public void addObsoleteTerms(TypedNode parent, PackageNode hp) {
        try {
            String pkg_oid = null;
            if (hp != null) {
                pkg_oid = hp.getOid();
            }
            Vector obo = OntologyQuerier.getObsoleteTerm(this.db, pkg_oid);
            int number = obo.size();
            for (int i2 = 0; i2 < number; ++i2) {
                String term_oid = (String)obo.elementAt(i2);
                DbTermNode newNode = this.createNode(term_oid, hp);
                newNode.showPackageInformation = false;
                parent.add(newNode);
                this.updateProgress(new StringBuffer().append("Read obsolete node (").append(i2).append(" of ").append(number).append(")").append(newNode.getLocalName()).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void makeDagFromRoots(TypedNode parent, int cutoff, boolean includeIsolatedTerm, PackageNode homePackage) {
        Vector<String> root_oids = OntologyQuerier.getRootTerms(this.db, this.relation, this.topdown, includeIsolatedTerm, homePackage);
        System.out.println(new StringBuffer().append("roots : ").append(root_oids).toString());
        this.representatives.clear();
        int number = root_oids.size();
        for (int i2 = 0; i2 < number; ++i2) {
            String oneRoot = root_oids.elementAt(i2);
            TypedNode node = this.makeDagFromTerm(oneRoot, cutoff, homePackage);
            parent.add(node);
            System.out.println(node);
            this.updateProgress(new StringBuffer().append("Find top node (").append(i2).append(" of ").append(number).append(")").append(node.getLocalName()).toString());
        }
    }

    public void makeDagFromRootsQuick(TypedNode parent, int cutoff, boolean includeIsolatedTerm, PackageNode homePackage) {
        String termConditionSQL = OntologyQuerier.getRootTermsSQL(this.db, this.relation, this.topdown, includeIsolatedTerm, homePackage);
        this.representatives.clear();
        Vector<DbTermNode> roots = this.batchCreateNode(termConditionSQL, homePackage);
        int number = roots.size();
        for (int i2 = 0; i2 < number; ++i2) {
            DbTermNode node = roots.elementAt(i2);
            DbTermNode oldNode = (DbTermNode)this.representatives.get(node.getOid());
            if (oldNode != null) {
                parent.add(new DBTermCloneNode(node));
            } else {
                this.representatives.put(node.getOid(), node);
                this.buildDAG(cutoff, node, homePackage);
                parent.add(node);
            }
            this.updateProgress(new StringBuffer().append("Find top node (").append(i2).append(" of ").append(number).append(")").append(node.getLocalName()).toString());
        }
    }

    public TypedNode makeDagFromTerm(String from_oid, int cutoff, PackageNode homePackage) {
        if (from_oid == null) {
            return null;
        }
        DbTermNode node = (DbTermNode)this.representatives.get(from_oid);
        if (node == null) {
            node = this.createNode(from_oid, homePackage);
            this.representatives.put(from_oid, node);
            this.buildDAG(cutoff, node, homePackage);
            return node;
        }
        return new DBTermCloneNode(node);
    }

    public void buildDAG(int cutoff, DbTermNode from, PackageNode homePackage) {
        from.getThisTerm().print();
        if (from == null) {
            return;
        }
        if (cutoff != 0) {
            boolean inHomePackageOnly = homePackage != null;
            String oid = from.getOid();
            String package_oid = inHomePackageOnly ? homePackage.getOid() : null;
            Vector newNodes = this.topdown ? OntologyQuerier.getChildrenTerm(this.db, oid, this.relation, inHomePackageOnly, package_oid) : OntologyQuerier.getParentTerm(this.db, oid, this.relation, inHomePackageOnly, package_oid);
            System.out.println(new StringBuffer().append(oid).append(" -> ").append(newNodes).toString());
            for (int i2 = 0; i2 < newNodes.size(); ++i2) {
                String oneNode = (String)newNodes.elementAt(i2);
                DbTermNode node = (DbTermNode)this.representatives.get(oneNode);
                if (node == null) {
                    node = this.createNode(oneNode, homePackage);
                    this.representatives.put(oneNode, node);
                    from.add(node);
                    this.buildDAG(cutoff - 1, node, homePackage);
                    continue;
                }
                node = new DBTermCloneNode(node);
                from.add(node);
            }
        }
    }

    public Vector<DbTermNode> batchCreateNode(String sqlCondition, PackageNode homePackage) {
        if (homePackage == null) {
            return null;
        }
        Vector<DbTermNode> nodes = new Vector<DbTermNode>();
        Vector<DbTerm> terms = DbTerm.batchRead(this.db, sqlCondition);
        Map<String, Integer> counts = OntologyQuerier.getBatchNeighborCount(this.db, this.topdown, sqlCondition, this.relation, homePackage.getOid());
        for (DbTerm thisTerm : terms) {
            DbTermNode newNode = new DbTermNode(thisTerm, homePackage);
            newNode.showPackageInformation = this.showPackageInformation;
            Integer childCount = counts.get(thisTerm.oid);
            newNode.hasMore = childCount == null ? false : childCount > 0;
            nodes.add(newNode);
        }
        return nodes;
    }

    public DbTermNode createNode(String oid, PackageNode homePackage) {
        if (homePackage != null) {
            DbTermNode node = (DbTermNode)this.createNode(oid, homePackage.getOid());
            node.setHomePackageNode(homePackage);
            return node;
        }
        DbTermNode node = (DbTermNode)this.createNode(oid, (String)null);
        String pkg_oid = OntologyQuerier.getHomePackage(this.db, oid);
        PackageNode hp = new PackageNode(DbPackage.read(this.db, pkg_oid));
        hp.setReadOnly(false);
        node.setHomePackageNode(hp);
        return node;
    }

    private DBTreeNode createNode(String oid, String package_oid) {
        try {
            DbTerm thisTerm = DbTerm.read(this.db, oid);
            DbTermNode newNode = new DbTermNode(thisTerm, null);
            newNode.showPackageInformation = this.showPackageInformation;
            int childCount = OntologyQuerier.getNeighborTermCount(this.db, this.topdown, oid, this.relation, package_oid);
            newNode.hasMore = childCount > 0;
            return newNode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

