/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Debug {
    static boolean debugMode = true;

    public Debug(boolean mode) {
        debugMode = mode;
    }

    public Debug() {
        debugMode = true;
    }

    public void setDebugMode(boolean mode) {
        debugMode = mode;
    }

    public boolean getDebugMode() {
        return debugMode;
    }

    public static void trace(Object obj, Object str) {
        if (!debugMode) {
            return;
        }
        String location = "";
        if (obj != null) {
            location = obj.getClass().getName() + ": ";
        }
        JOptionPane.showMessageDialog(null, location + str);
    }

    public static void trace(Object str) {
        if (!debugMode) {
            return;
        }
        JOptionPane.showMessageDialog(null, str);
    }

    public static void trace(int i2) {
        JOptionPane.showMessageDialog(null, i2 + "");
    }

    public static void trace(boolean i2) {
        JOptionPane.showMessageDialog(null, i2 + "");
    }

    public static void trace(float i2) {
        JOptionPane.showMessageDialog(null, i2 + "");
    }

    public static void traceWin(Object obj, String str) {
        if (!debugMode) {
            return;
        }
        String location = "";
        if (obj != null) {
            location = obj.getClass().getName() + ": ";
        }
        JTextArea text = new JTextArea(20, 40);
        text.setText(location + "\n\n" + str);
        text.setLineWrap(true);
        Debug.showControl(new JScrollPane(text));
    }

    public static void systrace(Object obj, String str) {
        if (!debugMode) {
            return;
        }
        String location = "";
        if (obj != null) {
            location = obj.getClass().getName() + ": ";
        }
        System.out.println(location + str);
    }

    public static void exitError(Window frame, String errormsg, int errorcode) {
        if (frame != null) {
            JOptionPane.showMessageDialog(frame, errormsg, "Fatal Error", 2);
        }
        System.err.println(errormsg);
        System.exit(errorcode);
    }

    public static void showControl(Component control) {
        if (!debugMode) {
            return;
        }
        JFrame frame = new JFrame();
        frame.getContentPane().add(control, "Center");
        System.out.println("width = " + control.getWidth() + " height = " + control.getHeight());
        frame.pack();
        frame.setVisible(true);
    }

    public static void pause() {
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

