/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils;

import edu.iastate.utils.Debug;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utility {
    private Utility() {
    }

    public static String formatSize(long longSize) {
        return Utility.formatSize(longSize, -1);
    }

    public static String formatSize(long longSize, int decimalPos) {
        double size;
        double val;
        NumberFormat fmt = NumberFormat.getNumberInstance();
        if (decimalPos >= 0) {
            fmt.setMaximumFractionDigits(decimalPos);
        }
        if ((val = (size = (double)longSize) / 1048576.0) > 1.0) {
            return fmt.format(val).concat(" MB");
        }
        val = size / 1024.0;
        if (val > 1.0) {
            return fmt.format(val).concat(" KB");
        }
        return fmt.format(size).concat(" bytes");
    }

    public static char[] subBuffer(char[] buffer, int start, int offset) {
        char[] result = null;
        if (buffer != null && start > -1 && offset > 0) {
            int t_iEnd = start + offset >= buffer.length ? buffer.length : start + offset;
            result = new char[t_iEnd - start];
            for (int t_iCharIndex = start; t_iCharIndex < t_iEnd; ++t_iCharIndex) {
                result[t_iCharIndex - start] = buffer[t_iCharIndex];
            }
        }
        return result;
    }

    public static char[] subBuffer(char[] buffer, int start) {
        char[] result = null;
        if (buffer != null) {
            result = Utility.subBuffer(buffer, start, buffer.length);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("check begin");
        long i2 = 2633L;
        Debug.trace(null, Utility.formatSize(i2));
        System.out.println("check finished");
    }

    public static boolean isNumeric(Object object) {
        boolean result = false;
        if (object != null) {
            String t_strValue = object.toString();
            StringTokenizer t_strtokFigures = new StringTokenizer(t_strValue, "0123456789.,", false);
            result = !t_strtokFigures.hasMoreTokens();
        }
        return result;
    }

    public static int getMax(int[] numbers) {
        int result = 0;
        if (numbers != null) {
            for (int t_iIndex = 0; t_iIndex < numbers.length; ++t_iIndex) {
                result = Math.max(result, numbers[t_iIndex]);
            }
        }
        return result;
    }

    public static double getMax(double[] numbers) {
        double result = 0.0;
        if (numbers != null) {
            for (int t_iIndex = 0; t_iIndex < numbers.length; ++t_iIndex) {
                result = Math.max(result, numbers[t_iIndex]);
            }
        }
        return result;
    }

    public static Vector Array2Vector(Object[] data) {
        return new Vector<Object>(Arrays.asList(data));
    }
}

