/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui;

import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.gui.SampleDesktopMgr;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HolderPanel
extends JDesktopPane {
    private JDesktopPane desk = this;
    private IconPolice iconPolice = new IconPolice();

    public HolderPanel() {
        this.desk.setDesktopManager(new SampleDesktopMgr());
    }

    public JInternalFrame addPane(JPanel p2, String title) {
        Dimension ss = this.desk.getSize();
        boolean resizable = true;
        boolean closeable = false;
        boolean maximizable = true;
        boolean iconifiable = true;
        JInternalFrame iframe = new JInternalFrame(title, resizable, closeable, maximizable, iconifiable);
        iframe.addVetoableChangeListener(this.iconPolice);
        int width = 200;
        int height = 50;
        iframe.setSize(width, height);
        iframe.setVisible(true);
        iframe.setContentPane(p2);
        this.desk.add((Component)iframe, new Integer(1));
        this.desk.setSize(ss);
        return iframe;
    }

    int getPanelCount(boolean normalOnly) {
        JInternalFrame[] allframes = this.desk.getAllFrames();
        int count = 0;
        if (normalOnly) {
            for (int i2 = 0; i2 < allframes.length; ++i2) {
                JInternalFrame f2 = allframes[i2];
                if (f2.isIcon()) continue;
                ++count;
            }
        }
        return count;
    }

    private void arrange(int rows, int cols, int count) {
        Dimension size = this.desk.getSize();
        int w2 = size.width / cols;
        int h2 = size.height / rows;
        int x2 = 0;
        int y2 = 0;
        JInternalFrame[] allframes = this.desk.getAllFrames();
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j2 = 0; j2 < cols && i2 * cols + j2 < count; ++j2) {
                JInternalFrame f2 = allframes[i2 * cols + j2];
                if (f2.isIcon()) continue;
                this.desk.getDesktopManager().resizeFrame(f2, x2, y2, w2, h2);
                x2 += w2;
            }
            y2 += h2;
            x2 = 0;
        }
    }

    public void tile() {
        int cols;
        int count = this.getPanelCount(true);
        if (count == 0) {
            return;
        }
        int sqrt = (int)Math.sqrt(count);
        int rows = sqrt;
        if (rows * (cols = sqrt) < count && rows * ++cols < count) {
            ++rows;
        }
        this.arrange(rows, cols, count);
    }

    public void line() {
        int count = this.getPanelCount(true);
        if (count == 0) {
            return;
        }
        int rows = count;
        int cols = 1;
        this.arrange(rows, cols, count);
    }

    public void showAll() {
        JInternalFrame[] allframes = this.desk.getAllFrames();
        int count = allframes.length;
        for (int i2 = 0; i2 < count; ++i2) {
            JInternalFrame f2 = allframes[i2];
            if (f2.isClosed() || !f2.isIcon()) continue;
            try {
                f2.setIcon(false);
                continue;
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        HolderPanel td = new HolderPanel();
        JFrame frame = new JFrame();
        frame.setVisible(true);
        frame.setContentPane(td);
        frame.setSize(300, 200);
        td.setSize(GUIUtils.getClientRegionSize(frame));
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        p1.add(new JLabel("111"));
        p2.add(new JButton("222"));
        td.addPane(p1, "1");
        td.addPane(p2, "2");
        td.addPane(new JPanel(), "3");
        td.line();
        frame.validate();
    }

    class IconPolice
    implements VetoableChangeListener {
        IconPolice() {
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            String name = ev.getPropertyName();
            if (name.equals("icon") && ev.getNewValue() == Boolean.TRUE) {
                JInternalFrame[] frames = HolderPanel.this.desk.getAllFrames();
                int count = frames.length;
                int nonicons = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    if (frames[i2].isIcon()) continue;
                    ++nonicons;
                }
                if (nonicons <= 1) {
                    throw new PropertyVetoException("Invalid Iconification!", ev);
                }
            }
        }
    }
}

