/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.sql;

import edu.iastate.utils.Utility;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCUtils {
    public static final String OK = "ok";
    static Map jdbcTypeName;
    static /* synthetic */ Class class$java$sql$Types;

    public static boolean insertDatabase(Connection db2, String tableName, Map field_value) {
        String header = new StringBuffer().append("INSERT INTO ").append(tableName).append(" (").toString();
        String field = "";
        String value = ") VALUES (";
        for (String key : field_value.keySet()) {
            String val = (String)field_value.get(key);
            if (val == null) {
                System.err.println(new StringBuffer().append(key).append(" has null value!").toString());
            }
            field = new StringBuffer().append(field).append(key).append(",").toString();
            value = new StringBuffer().append(value).append(JDBCUtils.toDBString(val)).append(",").toString();
        }
        String sql = new StringBuffer().append(header).append(field.substring(0, field.length() - 1)).append(value.substring(0, value.length() - 1)).append(") ").toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean isTableExist(Connection db2, String tableName, boolean caseSensitive) {
        try {
            Vector allTable = JDBCUtils.getAllTable(db2);
            if (caseSensitive) {
                return allTable.contains(tableName);
            }
            for (String str : allTable) {
                if (!str.equalsIgnoreCase(tableName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getColumnNoNull(ResultSet rs, int index) {
        try {
            String col = rs.getString(index);
            if (col == null) {
                col = "";
            }
            return col.trim();
        }
        catch (SQLException ex) {
            return "";
        }
    }

    public static String getColumnNoNull(ResultSet rs, String field) {
        try {
            String col = rs.getString(field);
            if (col == null) {
                col = "";
            }
            return col.trim();
        }
        catch (SQLException ex) {
            return "";
        }
    }

    public static Vector getAllTable(Connection db2) {
        try {
            DatabaseMetaData dbmd = db2.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet resultSet = dbmd.getTables(null, null, "%", types);
            Vector<String> vec = new Vector<String>();
            while (resultSet.next()) {
                String tableName = resultSet.getString(3);
                vec.add(tableName);
            }
            return vec;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static boolean clearTable(Connection db2, String tableName) {
        return JDBCUtils.updateDatabase(db2, new StringBuffer().append("DELETE FROM ").append(tableName).toString());
    }

    public static boolean updateDatabase(Connection db2, String sql) {
        try {
            System.out.println(new StringBuffer().append("     ").append(sql).toString());
            PreparedStatement updatest = db2.prepareStatement(sql);
            updatest.executeUpdate();
            updatest.close();
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            return false;
        }
    }

    public static String updateDatabaseM(Connection db2, String sql) {
        try {
            System.out.println(new StringBuffer().append("     ").append(sql).toString());
            PreparedStatement updatest = db2.prepareStatement(sql);
            updatest.executeUpdate();
            updatest.close();
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
        return OK;
    }

    public static boolean isOK(String message) {
        if (message == null) {
            return false;
        }
        return OK.equals(message);
    }

    public static String replaceDatabaseDangerousCharacters(String str) {
        if (str == null) {
            return "";
        }
        String values = str;
        values = values.replaceAll("\\(", "[");
        values = values.replaceAll("\\)", "]");
        values = values.replaceAll("\\'", "\\\\'");
        return values;
    }

    public static String toDBString(String s2) {
        if (s2 == null) {
            return "null";
        }
        return new StringBuffer().append("'").append(JDBCUtils.replaceDatabaseDangerousCharacters(s2)).append("'").toString();
    }

    public static String getFirstValue(Connection db2, String sql) {
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            if (resultSet.next()) {
                String value = resultSet.getString(1);
                return value;
            }
        }
        catch (SQLException e2) {
            System.err.println(sql);
            e2.printStackTrace();
        }
        return null;
    }

    public static Vector<String[]> getValues(Connection db2, String sql, int colNumber) {
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            Vector<String[]> v2 = new Vector<String[]>();
            while (resultSet.next()) {
                String[] values = new String[colNumber];
                for (int i2 = 0; i2 < colNumber; ++i2) {
                    values[i2] = resultSet.getString(i2 + 1);
                }
                v2.add(values);
            }
            return v2;
        }
        catch (SQLException e2) {
            System.err.println(sql);
            e2.printStackTrace();
            return null;
        }
    }

    public static Vector getValues(Connection db2, String sql) {
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            Vector<String> v2 = new Vector<String>();
            while (resultSet.next()) {
                v2.add(resultSet.getString(1));
            }
            return v2;
        }
        catch (SQLException e2) {
            System.err.println(sql);
            e2.printStackTrace();
            return null;
        }
    }

    public static int getCount(Connection db2, String sql) {
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            if (resultSet.next()) {
                int rowcount = resultSet.getInt(1);
                System.out.println(new StringBuffer().append("    ==>").append(rowcount).toString());
                return rowcount;
            }
            return 0;
        }
        catch (SQLException e2) {
            System.err.println(sql);
            e2.printStackTrace();
            return -1;
        }
    }

    public static int getCount(Connection db2, String tableName, String where) {
        String sql = new StringBuffer().append("SELECT COUNT(*) FROM ").append(tableName).toString();
        if (where != null && where.length() > 0) {
            sql = new StringBuffer().append(sql).append(" WHERE ").append(where).append(";").toString();
        }
        System.out.println(sql);
        return JDBCUtils.getCount(db2, sql);
    }

    public static void printQeury(Connection db2, String sql) {
        try {
            Statement stmt = db2.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            String tables = "\t";
            String columns = "\t";
            for (int i2 = 1; i2 < numColumns + 1; ++i2) {
                String columnName = rsmd.getColumnName(i2);
                columns = new StringBuffer().append(columns).append(columnName).append(" |\t").toString();
            }
            System.out.println(columns);
            int count = 1;
            while (rs.next()) {
                String row = new StringBuffer().append(count++).append("\t").toString();
                for (int i3 = 1; i3 < numColumns + 1; ++i3) {
                    String s2 = rs.getString(i3).trim();
                    row = new StringBuffer().append(row).append(s2).append(" |\t").toString();
                }
                System.out.println(row);
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public static boolean insertDatabase(Connection db2, String tableName, String[] fields, String[] values) {
        String sql = new StringBuffer().append("INSERT INTO ").append(tableName).append(" (").toString();
        for (int i2 = 0; i2 < fields.length - 1; ++i2) {
            sql = new StringBuffer().append(sql).append(fields[i2]).append(" , ").toString();
        }
        sql = new StringBuffer().append(sql).append(fields[fields.length - 1]).append(") VALUES (").toString();
        for (int j2 = 0; j2 < values.length - 1; ++j2) {
            sql = new StringBuffer().append(sql).append(JDBCUtils.toDBString(values[j2])).append(" , ").toString();
        }
        sql = new StringBuffer().append(sql).append(JDBCUtils.toDBString(values[values.length - 1])).append(") ").toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean updateDatabase(Connection db2, String tableName, Map field_value, String where) {
        String sql = new StringBuffer().append("UPDATE ").append(tableName).append(" SET ").toString();
        for (String key : field_value.keySet()) {
            String val = (String)field_value.get(key);
            sql = new StringBuffer().append(sql).append(key).append(" = ").append(JDBCUtils.toDBString(val)).append(",").toString();
        }
        sql = sql.substring(0, sql.length() - 1);
        if (where != null) {
            sql = new StringBuffer().append(sql).append(" WHERE ").append(where).toString();
        }
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean updateDatabase(Connection db2, String tableName, String[] fields, String[] values, String where) {
        if (fields.length != values.length) {
            return false;
        }
        String sql = new StringBuffer().append("UPDATE ").append(tableName).append(" SET ").toString();
        for (int i2 = 0; i2 < fields.length - 1; ++i2) {
            sql = new StringBuffer().append(sql).append(fields[i2]).append(" = ").append(JDBCUtils.toDBString(values[i2])).append(", ").toString();
        }
        sql = new StringBuffer().append(sql).append(fields[fields.length - 1]).append(" = ").append(JDBCUtils.toDBString(values[fields.length - 1])).toString();
        if (where != null) {
            sql = new StringBuffer().append(sql).append(" WHERE ").append(where).toString();
        }
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean insertOrUpdateDatabase(Connection db2, String tableName, Map field_value, String Pk) {
        String pkValue = (String)field_value.get(Pk);
        if (pkValue != null) {
            String where = new StringBuffer().append(Pk).append(" = ").append(JDBCUtils.toDBString(pkValue)).toString();
            int count = JDBCUtils.getCount(db2, tableName, where);
            if (count == 0) {
                return JDBCUtils.insertDatabase(db2, tableName, field_value);
            }
            if (count > 0) {
                return JDBCUtils.updateDatabase(db2, tableName, field_value, where);
            }
        }
        return false;
    }

    public static boolean insertOrUpdateDatabase(Connection db2, String tableName, Map field_value, Vector<String> Pks) {
        if (Pks == null) {
            System.out.println("JDBCUtils:insertOrUpdateDatabase() -  no primary key is provided");
            return false;
        }
        String where = "";
        for (String pk : Pks) {
            String pkValue = (String)field_value.get(pk);
            if (pkValue == null) {
                System.out.println("JDBCUtils:insertOrUpdateDatabase() -  insert with null primary key");
                return false;
            }
            where = new StringBuffer().append(where).append(pk).append("=").append(JDBCUtils.toDBString(pkValue)).append(" AND ").toString();
        }
        int count = JDBCUtils.getCount(db2, tableName, where = where.substring(0, where.length() - 5));
        if (count <= 0) {
            return JDBCUtils.insertDatabase(db2, tableName, field_value);
        }
        return JDBCUtils.updateDatabase(db2, tableName, field_value, where);
    }

    public static boolean delete(Connection db2, String tableName, Map<String, String> field_value) {
        String header = new StringBuffer().append("DELETE FROM ").append(tableName).append(" ").toString();
        String where = " WHERE ";
        for (String pk : field_value.keySet()) {
            String pkValue = field_value.get(pk);
            if (pkValue == null) {
                System.out.println("JDBCUtils:delete() -  insert with null primary key");
                return false;
            }
            where = new StringBuffer().append(where).append(pk).append("=").append(JDBCUtils.toDBString(pkValue)).append(" AND ").toString();
        }
        where = where.substring(0, where.length() - " AND ".length());
        String sql = new StringBuffer().append(header).append(where).toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }

    public static boolean insertOrDoNothing(Connection db2, String tableName, Map field_value, Vector<String> Pks) {
        if (Pks == null) {
            System.err.println("JDBCUtils:insertOrUpdateDatabase() -  no primary key is provided");
            return false;
        }
        String where = "";
        for (String pk : Pks) {
            String pkValue = (String)field_value.get(pk);
            if (pkValue == null) {
                System.err.println("JDBCUtils:insertOrDoNothing() -  insert with null primary key");
                return false;
            }
            where = new StringBuffer().append(where).append(pk).append("=").append(JDBCUtils.toDBString(pkValue)).append(" AND ").toString();
        }
        int count = JDBCUtils.getCount(db2, tableName, where = where.substring(0, where.length() - 5));
        if (count <= 0) {
            return JDBCUtils.insertDatabase(db2, tableName, field_value);
        }
        return true;
    }

    public static boolean insertOrDoNothing(Connection db2, String tableName, Map field_value, String[] pks) {
        return JDBCUtils.insertOrDoNothing(db2, tableName, field_value, Utility.Array2Vector(pks));
    }

    public static boolean insertOrUpdateDatabase(Connection db2, String tableName, Map field_value, String[] pks) {
        return JDBCUtils.insertOrUpdateDatabase(db2, tableName, field_value, Utility.Array2Vector(pks));
    }

    public static String getJdbcTypeName(int jdbcType) {
        if (jdbcTypeName == null) {
            jdbcTypeName = new HashMap();
            Field[] fields = (class$java$sql$Types == null ? (class$java$sql$Types = JDBCUtils.class$("java.sql.Types")) : class$java$sql$Types).getFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                try {
                    String name = fields[i2].getName();
                    Integer value = (Integer)fields[i2].get(null);
                    jdbcTypeName.put(value, name);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return (String)jdbcTypeName.get(new Integer(jdbcType));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

