/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class LocalDBConnection {
    protected String url;
    protected String user;
    protected String password;
    protected String driver;
    public Connection db;

    protected void finalize() {
    }

    public boolean connect() {
        try {
            Class.forName(this.driver);
            if (this.db == null || this.db.isClosed()) {
                this.db = DriverManager.getConnection(this.url, this.user, this.password);
            }
            return true;
        }
        catch (SQLException ex) {
            System.out.println("Cannot connect to the data source");
        }
        catch (ClassNotFoundException ex) {
            System.out.println("'" + this.driver + "' not found!");
        }
        return false;
    }

    public void connect(String driver, String dburl, String user, String passwd) {
        this.url = dburl;
        this.driver = driver;
        this.user = user;
        this.password = passwd;
        this.connect();
    }

    public void disconnect() {
        if (this.db != null) {
            try {
                if (!this.db.isClosed()) {
                    this.db.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        String str = "Url : " + this.url + ", User:  " + this.user + ", Password: " + this.password + ", Driver: " + this.driver;
        return str;
    }
}

