/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.string;

import edu.iastate.utils.string.PatternEx;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ParserUtils
extends PatternEx {
    protected ParserUtils() {
    }

    public static CharSequence fromFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        return cbuf;
    }

    public static boolean isFound(String patternStr, CharSequence inputStr) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.matches();
    }

    public static CharSequence removeDuplicateBlanks(CharSequence inputStr) {
        String patternStr = BLANKS;
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    public static String findFirst(String patternStr, CharSequence input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String findFirst(String head, String tail, CharSequence input, boolean greedy) {
        String mid = greedy ? ".*" : ".*?";
        return ParserUtils.findFirst(head + mid + tail, input);
    }

    public static Vector findAll(String patternStr, CharSequence input) {
        Vector<String> list = new Vector<String>();
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static Vector findAll(String head, String tail, CharSequence input, boolean greedy) {
        String mid = greedy ? ".*" : ".*?";
        return ParserUtils.findAll(head + mid + tail, input);
    }

    public static String replaceAll(String patternStr, String replacementStr, CharSequence input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replacementStr);
    }

    public static String[] getLinks(String uriStr) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL url = new URI(uriStr).toURL();
            URLConnection conn = url.openConnection();
            InputStreamReader rd = new InputStreamReader(conn.getInputStream());
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = (HTMLDocument)((EditorKit)kit).createDefaultDocument();
            ((EditorKit)kit).read(rd, (Document)doc, 0);
            HTMLDocument.Iterator it = doc.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                SimpleAttributeSet s2 = (SimpleAttributeSet)it.getAttributes();
                String link = (String)s2.getAttribute(HTML.Attribute.HREF);
                if (link != null) {
                    result.add(link);
                }
                it.next();
            }
        }
        catch (MalformedURLException e2) {
        }
        catch (URISyntaxException e3) {
        }
        catch (BadLocationException e4) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getTextFromHTML(String uriStr) {
        final StringBuffer buf = new StringBuffer(1000);
        try {
            HTMLDocument doc = new HTMLDocument(){

                public HTMLEditorKit.ParserCallback getReader(int pos) {
                    return new HTMLEditorKit.ParserCallback(){

                        public void handleText(char[] data, int pos) {
                            buf.append(data);
                            buf.append('\n');
                        }
                    };
                }
            };
            URL url = new URI(uriStr).toURL();
            URLConnection conn = url.openConnection();
            InputStreamReader rd = new InputStreamReader(conn.getInputStream());
            HTMLEditorKit kit = new HTMLEditorKit();
            ((EditorKit)kit).read(rd, (Document)doc, 0);
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
            e2.printStackTrace(System.err);
        }
        return buf.toString();
    }

    public static String escapeRE(String str) {
        Pattern escaper = Pattern.compile("([^a-zA-z0-9])");
        return escaper.matcher(str).replaceAll("\\\\$1");
    }

    public static Vector readLines(CharSequence inputStr, boolean keepLineTerminator) {
        Vector<String> list = new Vector<String>();
        String patternStr = "^(.*)$";
        Pattern pattern = Pattern.compile(patternStr, 8);
        Matcher matcher = pattern.matcher(inputStr);
        while (matcher.find()) {
            if (keepLineTerminator) {
                list.add(matcher.group(0));
                continue;
            }
            list.add(matcher.group(1));
        }
        return list;
    }

    public static CharSequence removeLineTerminators(CharSequence inputStr) {
        String patternStr = "(?m)$^|[\\r\\n]+\\z";
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    public static CharSequence removeCRLF(CharSequence inputStr) {
        String str = ((Object)inputStr).toString();
        return str.replaceAll("[\\r|\\n]", " ");
    }

    public static Vector convertToParagraphs(CharSequence inputStr) {
        Vector<String> list = new Vector<String>();
        String patternStr = "(?<=(\r\n|\r|\n))([ \\t]*$)+";
        String[] paras = Pattern.compile(patternStr, 8).split(inputStr);
        for (int i2 = 0; i2 < paras.length; ++i2) {
            list.add(paras[i2]);
        }
        return list;
    }

    public static Vector getNestedBlock(String head, String tail, CharSequence input, boolean greedy) {
        String mid = greedy ? "(.*)" : "(.*?)";
        String patternStr = head + mid + tail;
        Vector<String> list = new Vector<String>();
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    public static String getFirstNestedBlock(String head, String tail, CharSequence input, boolean greedy) {
        String mid = greedy ? "(.*)" : "(.*?)";
        String patternStr = head + mid + tail;
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Vector getNestedBlock(String tag, CharSequence input, boolean greedy) {
        String head = "<" + tag + ".*?>";
        String tail = "</" + tag + ">";
        return ParserUtils.getNestedBlock(head, tail, input, greedy);
    }
}

