/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.string;

import edu.iastate.utils.string.ParserUtils;
import edu.iastate.utils.string.TaggedText;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleXMLParser
extends ParserUtils {
    public static Vector getTopNestedBlock(CharSequence inputStr) {
        String patternStr = "(?s)<(\\S+?).*?>(.*)</\\1>";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        boolean matchFound = matcher.find();
        if (matchFound) {
            Vector<String> list = new Vector<String>();
            list.add(matcher.group(1));
            list.add(matcher.group(2));
            return list;
        }
        return null;
    }

    public static CharSequence printXMLSkeleton(CharSequence inputStr) {
        String str = (String)SimpleXMLParser.removeCRLF(inputStr);
        TaggedText tt = new TaggedText();
        tt.fromXML(str);
        return tt.print(0);
    }

    public static int parseSingleValueInt(Node doc, String xpath) throws Exception {
        try {
            NodeList nodelist = XPathAPI.selectNodeList(doc, xpath);
            Text elem = (Text)nodelist.item(0).getFirstChild();
            int i2 = Integer.parseInt(elem.getData());
            return i2;
        }
        catch (DOMException ex) {
            throw new DOMException(ex.code, ex.getMessage());
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(ex.getMessage());
        }
        catch (TransformerException ex) {
            throw new TransformerException(ex.getMessage());
        }
    }

    public static String parseSingleValueString(Node doc, String xpath) throws Exception {
        try {
            NodeList nodelist = XPathAPI.selectNodeList(doc, xpath);
            Text elem = (Text)nodelist.item(0).getFirstChild();
            String result = elem.getData().toString();
            return result;
        }
        catch (DOMException ex) {
            System.err.println(ex);
            throw new DOMException(ex.code, ex.getMessage());
        }
        catch (NumberFormatException ex) {
            System.err.println(ex);
            throw new NumberFormatException(ex.getMessage());
        }
        catch (TransformerException ex) {
            System.err.println(ex);
            throw new TransformerException(ex.getMessage());
        }
    }

    public static Document parseXmlString(String fragment) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(fragment)));
            return doc;
        }
        catch (SAXException e2) {
        }
        catch (ParserConfigurationException e3) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            file.createNewFile();
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static String documentToString(Document doc, String charset) {
        try {
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("encoding", charset);
            xformer.transform(source, result);
            String str = writer.toString();
            return str.replaceAll("[\\n|\\r|\\f]", "");
        }
        catch (TransformerException ex) {
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            // empty catch block
        }
        return null;
    }

    public static Document parseXmlFile(String filename, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            Document doc = factory.newDocumentBuilder().parse(new File(filename));
            return doc;
        }
        catch (SAXException e2) {
        }
        catch (ParserConfigurationException e3) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean find(Node doc, String xpath) {
        try {
            NodeList nodelist = XPathAPI.selectNodeList(doc, xpath);
            return nodelist.getLength() != 0;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

