/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.string;

public class Validator {
    public static boolean isAddress(String address) {
        if (Validator.isNull(address)) {
            return false;
        }
        char[] c2 = address.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (Validator.isChar(c2[i2]) || Validator.isDigit(c2[i2]) || Character.isWhitespace(c2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isChar(char c2) {
        return Character.isLetter(c2);
    }

    public static boolean isChar(String s2) {
        if (Validator.isNull(s2)) {
            return false;
        }
        char[] c2 = s2.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (Validator.isChar(c2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(char c2) {
        char x2 = c2;
        return x2 >= '0' && x2 <= '9';
    }

    public static boolean isDigit(String s2) {
        if (Validator.isNull(s2)) {
            return false;
        }
        char[] c2 = s2.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (Validator.isDigit(c2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(String s2) {
        return !Validator.isNull(s2);
    }

    public static boolean isHTML(String s2) {
        if (Validator.isNull(s2)) {
            return false;
        }
        return !(s2.indexOf("<html>") == -1 && s2.indexOf("<HTML>") == -1 || s2.indexOf("</html>") == -1 && s2.indexOf("</HTML>") == -1);
    }

    public static boolean isName(String name) {
        if (Validator.isNull(name)) {
            return false;
        }
        char[] c2 = name.trim().toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if ((Validator.isChar(c2[i2]) || Character.isWhitespace(c2[i2])) && c2[i2] != ',') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String number) {
        if (Validator.isNull(number)) {
            return false;
        }
        char[] c2 = number.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (Validator.isDigit(c2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(String s2) {
        if (s2 == null) {
            return true;
        }
        return (s2 = s2.trim()).equals("null") || s2.equals("");
    }

    public static boolean isNotNull(String s2) {
        return !Validator.isNull(s2);
    }

    public static boolean isPassword(String password) {
        if (Validator.isNull(password)) {
            return false;
        }
        if (password.length() < 4) {
            return false;
        }
        char[] c2 = password.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (Validator.isChar(c2[i2]) || Validator.isDigit(c2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmailAddress(String ea) {
        if (Validator.isNull(ea)) {
            return false;
        }
        int eaLength = ea.length();
        if (eaLength < 6) {
            return false;
        }
        int at = (ea = ea.toLowerCase()).indexOf(64);
        if (at > 24 || at == -1 || at == 0 || at <= eaLength && at > eaLength - 5) {
            return false;
        }
        int dot = ea.lastIndexOf(46);
        if (dot == -1 || dot < at || dot > eaLength - 3) {
            return false;
        }
        if (ea.indexOf("..") != -1) {
            return false;
        }
        char[] name = ea.substring(0, at).toCharArray();
        for (int i2 = 0; i2 < name.length; ++i2) {
            if (Validator.isChar(name[i2]) || Validator.isDigit(name[i2]) || name[i2] == '.' || name[i2] == '-' || name[i2] == '_') continue;
            return false;
        }
        if (name[0] == '.' || name[name.length - 1] == '.' || name[0] == '-' || name[name.length - 1] == '-' || name[0] == '_') {
            return false;
        }
        char[] host = ea.substring(at + 1, ea.length()).toCharArray();
        for (int i3 = 0; i3 < host.length; ++i3) {
            if (Validator.isChar(host[i3]) || Validator.isDigit(host[i3]) || host[i3] == '.' || host[i3] == '-') continue;
            return false;
        }
        if (host[0] == '.' || host[host.length - 1] == '.' || host[0] == '-' || host[host.length - 1] == '-') {
            return false;
        }
        if (ea.startsWith("postmaster@")) {
            return false;
        }
        return !ea.startsWith("root@");
    }
}

