/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class WalkingIteratorSorted
extends WalkingIterator {
    protected boolean m_inNaturalOrder = false;

    public WalkingIteratorSorted(PrefixResolver nscontext) {
        super(nscontext);
    }

    public WalkingIteratorSorted(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        super(compiler, opPos, analysis, shouldLoadWalkers);
    }

    boolean canBeWalkedInNaturalDocOrder() {
        if (null != this.m_firstWalker) {
            AxesWalker walker = this.m_firstWalker;
            int prevAxis = -1;
            boolean prevIsSimpleDownAxis = true;
            int i2 = 0;
            while (null != walker) {
                boolean isSimpleDownAxis;
                int axis = walker.getAxis();
                boolean bl = isSimpleDownAxis = axis == 3 || axis == 13 || axis == 19;
                if (walker.isDocOrdered()) {
                    if (!isSimpleDownAxis) {
                        boolean isLastWalker;
                        boolean bl2 = isLastWalker = null == walker.getNextWalker();
                        return isLastWalker && (walker.isDocOrdered() && (axis == 4 || axis == 5 || axis == 17 || axis == 18) || axis == 2);
                    }
                } else {
                    return false;
                }
                walker = walker.getNextWalker();
                ++i2;
            }
            return true;
        }
        return false;
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_inNaturalOrder = this.canBeWalkedInNaturalDocOrder();
        if (!this.m_inNaturalOrder) {
            this.setShouldCacheNodes(true);
            this.m_cachedNodes.setLast(0);
            this.m_cachedNodes.reset();
            this.m_cachedNodes.RemoveAllNoClear();
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(context);
            this.m_lastUsedWalker = this.m_firstWalker;
            int nextNode = -1;
            AxesWalker walker = this.getLastUsedWalker();
            XPathContext execContext = (XPathContext)environment;
            execContext.pushCurrentNodeAndExpression(context, context);
            try {
                while (true) {
                    if (null != walker) {
                        nextNode = walker.getNextNode();
                        if (-1 == nextNode) {
                            walker = walker.m_prevWalker;
                            continue;
                        }
                        if (walker.acceptNode(nextNode) != 1) continue;
                        if (null == walker.m_nextWalker) {
                            this.setLastUsedWalker(walker);
                        } else {
                            AxesWalker prev = walker;
                            walker = walker.m_nextWalker;
                            walker.setRoot(nextNode);
                            walker.m_prevWalker = prev;
                            continue;
                        }
                    }
                    if (-1 != nextNode) {
                        this.incrementNextPosition();
                        this.m_cachedNodes.addNodeInDocOrder(nextNode, execContext);
                        walker = this.getLastUsedWalker();
                    }
                    if (-1 == nextNode) break;
                }
                Object var8_7 = null;
                execContext.popCurrentNodeAndExpression();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                execContext.popCurrentNodeAndExpression();
                throw throwable;
            }
            this.setNextPosition(0);
            this.m_last = this.m_cachedNodes.size();
            this.m_lastFetched = -1;
            this.m_currentContextNode = -1;
            this.m_foundLast = true;
        }
    }

    public void reset() {
        if (this.m_inNaturalOrder) {
            super.reset();
        } else {
            this.m_lastFetched = -1;
            this.m_next = 0;
            if (null != this.m_firstWalker) {
                this.m_lastUsedWalker = this.m_firstWalker;
                this.m_firstWalker.setRoot(this.m_context);
            }
        }
    }
}

