/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.SQLException;
import org.postgresql.core.Encoding;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGStream {
    public String host;
    public int port;
    public Socket connection;
    public InputStream pg_input;
    public BufferedOutputStream pg_output;
    private byte[] byte_buf = new byte[8192];

    public PGStream(String p_host, int p_port) throws IOException {
        this.host = p_host;
        this.port = p_port;
        this.connection = new Socket(this.host, this.port);
        this.connection.setTcpNoDelay(true);
        this.pg_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
    }

    public void SendChar(int val) throws IOException {
        this.pg_output.write((byte)val);
    }

    public void SendInteger(int val, int siz) throws IOException {
        byte[] buf = new byte[siz];
        while (siz-- > 0) {
            buf[siz] = (byte)(val & 0xFF);
            val >>= 8;
        }
        this.Send(buf);
    }

    public void SendIntegerR(int val, int siz) throws IOException {
        byte[] buf = new byte[siz];
        for (int i2 = 0; i2 < siz; ++i2) {
            buf[i2] = (byte)(val & 0xFF);
            val >>= 8;
        }
        this.Send(buf);
    }

    public void Send(byte[] buf) throws IOException {
        this.pg_output.write(buf);
    }

    public void Send(byte[] buf, int siz) throws IOException {
        this.Send(buf, 0, siz);
    }

    public void Send(byte[] buf, int off, int siz) throws IOException {
        this.pg_output.write(buf, off, buf.length - off < siz ? buf.length - off : siz);
        if (buf.length - off < siz) {
            for (int i2 = buf.length - off; i2 < siz; ++i2) {
                this.pg_output.write(0);
            }
        }
    }

    public int ReceiveChar() throws SQLException {
        int c2 = 0;
        try {
            c2 = this.pg_input.read();
            if (c2 < 0) {
                throw new PSQLException("postgresql.stream.eof", PSQLState.COMMUNICATION_ERROR);
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.stream.ioerror", PSQLState.COMMUNICATION_ERROR, (Object)e2);
        }
        return c2;
    }

    public int ReceiveInteger(int siz) throws SQLException {
        int n2 = 0;
        try {
            for (int i2 = 0; i2 < siz; ++i2) {
                int b2 = this.pg_input.read();
                if (b2 < 0) {
                    throw new PSQLException("postgresql.stream.eof", PSQLState.COMMUNICATION_ERROR);
                }
                n2 |= b2 << 8 * i2;
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.stream.ioerror", PSQLState.COMMUNICATION_ERROR, (Object)e2);
        }
        return n2;
    }

    public int ReceiveIntegerR(int siz) throws SQLException {
        int n2 = 0;
        try {
            for (int i2 = 0; i2 < siz; ++i2) {
                int b2 = this.pg_input.read();
                if (b2 < 0) {
                    throw new PSQLException("postgresql.stream.eof", PSQLState.COMMUNICATION_ERROR);
                }
                n2 = b2 | n2 << 8;
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.stream.ioerror", PSQLState.COMMUNICATION_ERROR, (Object)e2);
        }
        return n2;
    }

    public String ReceiveString(Encoding encoding) throws SQLException {
        int s2 = 0;
        byte[] rst = this.byte_buf;
        try {
            int buflen = rst.length;
            boolean done = false;
            block2: while (!done) {
                while (s2 < buflen) {
                    int c2 = this.pg_input.read();
                    if (c2 < 0) {
                        throw new PSQLException("postgresql.stream.eof", PSQLState.COMMUNICATION_ERROR);
                    }
                    if (c2 == 0) {
                        rst[s2] = 0;
                        done = true;
                        continue block2;
                    }
                    rst[s2++] = (byte)c2;
                    if (s2 < buflen) continue;
                    byte[] newrst = new byte[buflen *= 2];
                    System.arraycopy(rst, 0, newrst, 0, s2);
                    rst = newrst;
                }
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.stream.ioerror", PSQLState.COMMUNICATION_ERROR, (Object)e2);
        }
        return encoding.decode(rst, 0, s2);
    }

    public byte[][] ReceiveTupleV3(int nf) throws SQLException {
        int l_msgSize = this.ReceiveIntegerR(4);
        int l_nf = this.ReceiveIntegerR(2);
        byte[][] answer = new byte[l_nf][0];
        for (int i2 = 0; i2 < l_nf; ++i2) {
            int l_size = this.ReceiveIntegerR(4);
            boolean isNull = l_size == -1;
            answer[i2] = (byte[])(isNull ? null : this.Receive(l_size));
        }
        return answer;
    }

    public byte[][] ReceiveTupleV2(int nf, boolean bin) throws SQLException {
        int bim = (nf + 7) / 8;
        byte[] bitmask = this.Receive(bim);
        byte[][] answer = new byte[nf][0];
        int whichbit = 128;
        int whichbyte = 0;
        for (int i2 = 0; i2 < nf; ++i2) {
            boolean isNull;
            boolean bl = isNull = (bitmask[whichbyte] & whichbit) == 0;
            if ((whichbit >>= 1) == 0) {
                ++whichbyte;
                whichbit = 128;
            }
            if (isNull) {
                answer[i2] = null;
                continue;
            }
            int len = this.ReceiveIntegerR(4);
            if (!bin) {
                len -= 4;
            }
            if (len < 0) {
                len = 0;
            }
            answer[i2] = this.Receive(len);
        }
        return answer;
    }

    public byte[] Receive(int siz) throws SQLException {
        byte[] answer = new byte[siz];
        this.Receive(answer, 0, siz);
        return answer;
    }

    public void Receive(byte[] b2, int off, int siz) throws SQLException {
        try {
            int w2;
            for (int s2 = 0; s2 < siz; s2 += w2) {
                w2 = this.pg_input.read(b2, off + s2, siz - s2);
                if (w2 >= 0) continue;
                throw new PSQLException("postgresql.stream.eof", PSQLState.COMMUNICATION_ERROR);
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.stream.ioerror", PSQLState.COMMUNICATION_ERROR, (Object)e2);
        }
    }

    public void flush() throws SQLException {
        try {
            this.pg_output.flush();
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.stream.flush", PSQLState.COMMUNICATION_ERROR, (Object)e2);
        }
    }

    public void close() throws IOException {
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }
}

