/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.io.IOException;
import org.postgresql.core.PGStream;

public class FastpathArg {
    public boolean type;
    public int value;
    public byte[] bytes;

    public FastpathArg(int value) {
        this.type = true;
        this.value = value;
    }

    public FastpathArg(byte[] bytes) {
        this.type = false;
        this.bytes = bytes;
    }

    public FastpathArg(byte[] buf, int off, int len) {
        this.type = false;
        this.bytes = new byte[len];
        System.arraycopy(buf, off, this.bytes, 0, len);
    }

    public FastpathArg(String s2) {
        this(s2.getBytes());
    }

    protected void send(PGStream s2) throws IOException {
        if (this.type) {
            s2.SendInteger(4, 4);
            s2.SendInteger(this.value, 4);
        } else {
            s2.SendInteger(this.bytes.length, 4);
            s2.Send(this.bytes);
        }
    }

    protected int sendSize() {
        if (this.type) {
            return 8;
        }
        return 4 + this.bytes.length;
    }
}

