/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGpoint
extends PGobject
implements Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint(double x2, double y2) {
        this();
        this.x = x2;
        this.y = y2;
    }

    public PGpoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGpoint() {
        this.setType("point");
    }

    public void setValue(String s2) throws SQLException {
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removePara(s2), ',');
        try {
            this.x = Double.valueOf(t2.getToken(0));
            this.y = Double.valueOf(t2.getToken(1));
        }
        catch (NumberFormatException e2) {
            throw new PSQLException("postgresql.geo.point", PSQLState.DATA_TYPE_MISMATCH, e2.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpoint) {
            PGpoint p2 = (PGpoint)obj;
            return this.x == p2.x && this.y == p2.y;
        }
        return false;
    }

    public Object clone() {
        return new PGpoint(this.x, this.y);
    }

    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void translate(int x2, int y2) {
        this.translate((double)x2, (double)y2);
    }

    public void translate(double x2, double y2) {
        this.x += x2;
        this.y += y2;
    }

    public void move(int x2, int y2) {
        this.setLocation(x2, y2);
    }

    public void move(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public void setLocation(int x2, int y2) {
        this.move((double)x2, (double)y2);
    }

    public void setLocation(Point p2) {
        this.setLocation(p2.x, p2.y);
    }
}

