/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    public void setValue(String s2) throws SQLException {
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removePara(s2), ',');
        int npoints = t2.getSize();
        this.points = new PGpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new PGpoint(t2.getToken(p2));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p2 = (PGpolygon)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (this.points[i2].equals(p2.points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        PGpoint[] ary = new PGpoint[this.points.length];
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            ary[i2] = (PGpoint)this.points[i2].clone();
        }
        return new PGpolygon(ary);
    }

    public String getValue() {
        StringBuffer b2 = new StringBuffer();
        b2.append("(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b2.append(",");
            }
            b2.append(this.points[p2].toString());
        }
        b2.append(")");
        return b2.toString();
    }
}

