/*=============================================================
This class creates the menubar that appears at the top of the
user interface.

Author: Eric Fritz
=============================================================*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.awt.print.*;
import java.awt.image.BufferedImage;
import java.util.*;

public class BeapMenuBar extends JMenuBar
{
    private displayPanel displaypanel;
    private PageFormat pageFormat;
    private mainWindow mainWin;
    private imageClass printImage;
    private iClass2 pImage2;
    private dPanel2 dpanel2;
    private dPanelp dpanelp;
    volatile static PageFormat pf;

    //This is the constructor.
    public BeapMenuBar(displayPanel dp, mainWindow mW, imageClass iC, iClass2 ic2, dPanel2 dp2, dPanelp dpp)
    {
        displaypanel = dp;
        mainWin = mW;
        printImage = iC;
        pImage2 = ic2;
        dpanel2 = dp2;
        dpanelp = dpp;
    
        JMenu fileMenu = new JMenu("File");//Creates the File menu and options.
        JMenuItem saveOption = new JMenuItem("Save...");
        saveOption.addActionListener(new saveListener());
        JMenuItem printOption = new JMenuItem("Print...");
        printOption.addActionListener(new printListener());
        JMenuItem quitOption = new JMenuItem("Quit");
        quitOption.addActionListener(new quitListener());
        fileMenu.add(saveOption);
        fileMenu.add(printOption);
        fileMenu.addSeparator();
        fileMenu.add(quitOption);
        add(fileMenu);
        
        JMenu viewMenu = new JMenu("View");//Creates the View menu and options.
        JMenuItem generalViewOption = new JMenuItem("General View");
        generalViewOption.addActionListener(new generalViewListener());
        JMenuItem nucleotideViewOption = new JMenuItem("Nucleotide View");
        nucleotideViewOption.addActionListener(new nucleotideViewListener());
        JMenuItem noColorOption = new JMenuItem("No Color Differentiation");
        noColorOption.addActionListener(new noColorListener());
        JMenuItem colorOption = new JMenuItem("Color Differentiation");
        colorOption.addActionListener(new colorListener());
        JMenuItem allbaseOption = new JMenuItem("View all bases");
        allbaseOption.addActionListener(new allbaseListener());
        JMenuItem diffbaseOption = new JMenuItem("Hide correct bases");
        diffbaseOption.addActionListener(new diffbaseListener());
        viewMenu.add(generalViewOption);
        viewMenu.add(nucleotideViewOption);
        viewMenu.addSeparator();
        viewMenu.add(noColorOption);
        viewMenu.add(colorOption);
        viewMenu.addSeparator();
        viewMenu.add(allbaseOption);
        viewMenu.add(diffbaseOption);
        add(viewMenu);
        
        JMenu helpMenu = new JMenu("Help");//Creates the Help menu and options.
        JMenuItem guideOption = new JMenuItem("BEAP GUI userguide...");
        guideOption.addActionListener(new guideListener());
        JMenuItem aboutOption = new JMenuItem("About...");
        aboutOption.addActionListener(new aboutListener());
        JMenuItem bugOption = new JMenuItem("Report bug...");
        bugOption.addActionListener(new bugListener());
        helpMenu.add(guideOption);
        helpMenu.add(aboutOption);
        helpMenu.add(bugOption);
        add(helpMenu);
    }
    
    //This class causes the program to quit when Quit is selected from the menu.
    private class quitListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            System.exit(1);
        }
    }
    
    //This class prints the displaypanel when Print is selected from the menu.
    private class printListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            int testNum = mainWin.getDisplayNum();
            
            if(testNum == 1)
            {
                dpanelp.createImage();
                dpanelp.PrintPanel();
                
                contigListPrint contigLP = new contigListPrint(displaypanel.getRectArray());
                contigLP.createImage();
                contigLP.setPrinterJob(dpanelp.getPrinterJob());
                contigLP.PrintPanel();
            }
        }
    }
    
    //This class initiates saving the display when Save is selected from the menu.
    private class saveListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            int testNum = mainWin.getDisplayNum();
            
            if(testNum == 1)//This saves the bar view of the contig.
            {
                printImage.createImage();
        
                JFileChooser fileChoiceWindow = new JFileChooser();
                fileChoiceWindow.setCurrentDirectory(new File("."));
            
                boolean done = false;
                while (!done)
                {
                    String fName = displaypanel.getContigName();
                
                    File namefile = new File(fName+".jpg");
                    fileChoiceWindow.setSelectedFile(namefile);
        
                    int choiceResult = fileChoiceWindow.showSaveDialog(mainWin);
                    if (choiceResult == JFileChooser.CANCEL_OPTION)
                    {
                        done = true;
                    }
                    if (choiceResult == JFileChooser.APPROVE_OPTION)
                    {
                        File filePicked = fileChoiceWindow.getSelectedFile();
                        printImage.save(filePicked);
                        done = true;
                    }
                }
            }
            else//This saves the nucleotide view of the contig.
            {
                pImage2.createImage();
        
                JFileChooser fileChoiceWindow = new JFileChooser();
                fileChoiceWindow.setCurrentDirectory(new File("."));
            
                boolean done = false;
                while (!done)
                {
                    String fName = dpanel2.getContigName()+" Contig Sequence";
                
                    File namefile = new File(fName+".jpg");
                    fileChoiceWindow.setSelectedFile(namefile);
        
                    int choiceResult = fileChoiceWindow.showSaveDialog(mainWin);
                    if (choiceResult == JFileChooser.CANCEL_OPTION)
                    {
                        done = true;
                    }
                    if (choiceResult == JFileChooser.APPROVE_OPTION)
                    {
                        File filePicked = fileChoiceWindow.getSelectedFile();
                        pImage2.save(filePicked);
                        done = true;
                    }
                }
            }
        }
    }
    
    //This class displays the pertinent information when About is selected from the menu.
    private class aboutListener implements ActionListener
    {
        private String helpInfo = "";
    
        public void actionPerformed(ActionEvent e)
        {
            helpInfo = "The creator of BEAP Graphics:\nEric Fritz\n"+
                        "ercfrtz@gmail.com\nAcknowledgements: Dr. James Reecy,"+
                        " Dr. Zhiliang Hu, and Dr. James Koltes\n"+
                        "Iowa State University of Science and Technology";
            JOptionPane.showMessageDialog(mainWin, helpInfo);
        }
    }
    
    //This class switches the view displayed to lines/bars when General View is
    //selected from the menu.
    private class generalViewListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            mainWin.setDisplayNum(1);
            mainWin.removeDPanel2();
            mainWin.setDisplayPanel(displaypanel);
        }
    }
    
    //This class switches the view displayed to nucleotides when the Nucleotide
    //view is selected from the menubar.
    private class nucleotideViewListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            mainWin.setDisplayNum(-1);
            mainWin.removeDisplayPanel();
            mainWin.setDPanel2(dpanel2);
        }
    }
    
    //This class displays the pertinent information when BEAP GUI userguide is
    //selected from the menubar.
    private class guideListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            String guideInfo = 
            "This program is designed to view the output from the main BEAP\n"+
            " program. To start click on the UploadFile and pick the file to\n"+
            " upload. If there are multiple contigs, you can switch views with\n"+
            " the box beside the upload button. You can also switch between\n"+
            " the general view and a nucleotide view with the view menu. In the\n"+
            " general view if you click on a line, it will bring up a window with\n"+
            " sequence in it and on that window you can save or print the\n"+
            " sequence or click to go to NCBI. When printing it will give you a\n"+
            " prompt window 2 times, make sure you click print on both. If you\n"+
            " have any other questions feel free to contact the author.";
            JOptionPane.showMessageDialog(mainWin, guideInfo);
        }
    }
    
    //This class displays the pertinent information when Report Bug is selected
    //from the menu.
    private class bugListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            String bugInfo = "If you are experiencing problems email the author at:\n"+
            "ercfrtz@gmail.com";
            JOptionPane.showMessageDialog(mainWin, bugInfo);
        }
    }
    
    //This class switches the nucleotide view to have no color differentiation when No Color Differentiation is selected from the view menu.
    private class noColorListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            dpanel2.setColorNum(0);
            dpanel2.revalidate();
            dpanel2.repaint();
        }
    }
    
    //This class switches the nucleotide view to have color differentiation when Color Differentation is selected from the view menu.
    private class colorListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            dpanel2.setColorNum(1);
            dpanel2.revalidate();
            dpanel2.repaint();
        }
    }
    
    //This class switches the nucleotide view to show all the bases in the sequences
    private class allbaseListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            dpanel2.setBaseNum(0);
            dpanel2.revalidate();
            dpanel2.repaint();
        }
    }
    
    //This class switches the nucleotide view to show just the bases different from the contig.
    private class diffbaseListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            dpanel2.setBaseNum(1);
            dpanel2.revalidate();
            dpanel2.repaint();
        }
    }
}