/*=================================================================
This class is designed to hold all the relative information for a
specific contig, including the different BACs, etc that were used
to create it.

Author: Eric Fritz
==================================================================*/
import javax.swing.*;
import java.awt.*;

public class Contig
{
	private interactiveRectangle[] rectArray = new interactiveRectangle[10];
	private String contigName, contigSeq;
	private int[] scoresArray;
	private int contigLength, lengthTester;
	private int lengthMeasure = 0;
	private int lengthTest = 0;
	private int yValue = 0;
	
	//These methods set and retrieve the name of the contig.
	public void setContigName(String scn)
	{contigName = scn;}
	public String getContigName()
	{return contigName;}
	
	//These methods set and retrieve the sequence of the contig.
	public void setContigSeq(String scs)
	{contigSeq = scs;}
	public String getContigSeq()
	{return contigSeq;}
	
	//These methods set and retrieve the number of bases in the contig.
	public void setContigLength(int scl)
	{contigLength = scl;}
	public int getContigLength()
	{return contigLength;}
	
	//These methods set and retrieve the scores of the bases and while not
	//utilized at this time, may be used in the future.
	public void setScoresArray(int[] ssa)
	{scoresArray = ssa;}
	public int[] getScoresArray()
	{return scoresArray;}
	
	//This method creates an interactiveRectangle (BAC) with all the pertinent info.
	public void createRect(int x, int y, int w, int h, int num, String cN,
									int tL, int soc, int sour, int eour, String cS)
	{
		if(num+1 >= rectArray.length)
		{
			interactiveRectangle[] temp = new interactiveRectangle[rectArray.length+5];
			for(int i = 0; i < rectArray.length; i++)
				temp[i] = rectArray[i];
			rectArray = temp;
		}
		
		rectArray[num] = new interactiveRectangle(x,y,w,h);
		rectArray[num].setContigName(cN);
		rectArray[num].setTotalLength(tL);
		rectArray[num].setStartOfContig(soc);
		rectArray[num].setStartOfUsedRegion(sour);
		rectArray[num].setEndOfUsedRegion(eour);
		rectArray[num].setContigSeq(cS);
	}
	
	//These methods set and retrieve the array containing the interactiveRectangles.
	public void setRectArray(interactiveRectangle[] sra)
	{rectArray = sra;}
	public interactiveRectangle[] getRectArray()
	{return rectArray;}
	
	//These methods set and retrieve the y-value.
	public void setYValue(int syv)
	{yValue = syv;}
	public int getYValue()
	{return yValue;}
}