/*============================================================
This class parses through the file that contains the contig(s)
and pulls out the appropriate info. and sends it to/utilizes
other classes where necessary.

Author: Eric Fritz
=============================================================*/
import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import java.lang.*;

public class ReadTextFile
{
    private Scanner input;
    private displayPanel displaypanel;
    private fileUploadPanel uploadpanel;
    private imageClass printImage;
    private dPanel2 dpanel2;
    private iClass2 pImage2;
    private dPanelp dpanelp;
    
    //This method uploads the file for use.
    public void openFile(String uploadFile)
    {
        try
        {
            input = new Scanner(new File(uploadFile));
        }
    
        catch(FileNotFoundException fileNotFoundException)
        {
            System.err.println("Error opening file.");
            System.exit(1);
        }
    }
    
    //This method reads through the file and does the parsing of info.
    public void readRecords(displayPanel dp, fileUploadPanel fup, imageClass iC, dPanel2 dp2, iClass2 ic2, dPanelp dpp)
    {
        displaypanel = dp;
        uploadpanel = fup;
        printImage = iC;
        dpanel2 = dp2;
        pImage2 = ic2;
        dpanelp = dpp;
        
        try
        {
            Contig[] contigArray = new Contig[1];
            int contigNum = 0;
            int scoreNum = 0;
            int lengthNum = 0;
            int rectNum = 0;
            int contigLength = 0;
            int rectY = 0;
            int[] scoreArray = new int[200];
            int[] lengthArray = new int[1];
        
            while(input.hasNext())
            {       
                String inputTest = input.next();
                        
                if(inputTest.equals("CO"))
                {
                    int[] sat = new int[200];
                    scoreArray = sat;
                    int[] lat = new int[1];
                    lengthArray = lat;
                    rectY = 98;
                    scoreNum = 0;
                    lengthNum = 0;
                    rectNum = 0;
                    
                    if(contigNum+1 > contigArray.length)
                    {
                        Contig[] tempCA = new Contig[contigArray.length+1];
                        for(int i = 0; i < contigArray.length; i++)
                            tempCA[i] = contigArray[i];
                        contigArray = tempCA;
                    }//Lengthens the array of contigs when needed.
                
                    String contigName = input.next();
                    contigLength = Integer.parseInt(input.next());
                    input.next();
                    input.next();
                    input.next();
                    String seqTest = input.next();
                    String contigSeq = "";
                    while(!seqTest.equals("BQ"))
                    {
                        contigSeq = (contigSeq + seqTest);
                        seqTest = input.next();
                    }
                    if(seqTest.equals("BQ"))
                    {
                        for(int q = 0; q < contigLength; q++)
                        {
                            String scoreTest = input.next();
                        
                            for(int j = 0; j < 100; j+=5)
                            {
                                if(scoreTest.equals(String.valueOf(j)))
                                {
                                    if(scoreNum+1 > scoreArray.length)
                                    {
                                        int[] tempSA = new int[scoreArray.length+200];
                                        for(int k = 0; k < scoreArray.length; k++)
                                            tempSA[k] = scoreArray[k];
                                        scoreArray = tempSA;
                                    }
                                    scoreArray[scoreNum] = Integer.parseInt(scoreTest);
                                    scoreNum++;
                                }
                            }
                            if(scoreTest.equals("AF"))
                            {
                                if(lengthNum+1 > lengthArray.length)
                                {
                                    int[] tempLA = new int[lengthArray.length+1];
                                    for(int l = 0; l < lengthArray.length; l++)
                                        tempLA[l] = lengthArray[l];
                                    lengthArray = tempLA;
                                }
                                input.next();
                                input.next();
                                lengthArray[lengthNum] = Integer.parseInt(input.next());
                                lengthNum++;
                            }
                        }
                    }//The previous scans through and pulls out important info.
                    contigArray[contigNum] = new Contig();
                    contigArray[contigNum].setContigName(contigName);
                    contigSeq = contigSeq.replace('*','N');
                    contigArray[contigNum].setContigSeq(contigSeq);
                    contigArray[contigNum].setContigLength(contigLength);
                    contigArray[contigNum].setScoresArray(scoreArray);
                    contigNum++;//The previous stores the info. with the appropriate contig.
                }
                
                if(inputTest.equals("AF"))
                {
                    if(lengthNum+1 > lengthArray.length)
                    {
                        int[] tempLA = new int[lengthArray.length+1];
                        for(int l = 0; l < lengthArray.length; l++)
                            tempLA[l] = lengthArray[l];
                        lengthArray = tempLA;
                    }//Lengthens the array of lengths of contigs when needed.
                    input.next();
                    input.next();
                    lengthArray[lengthNum] = Integer.parseInt(input.next());
                    lengthNum++;
                }   
                
                if(inputTest.equals("RD"))
                {
                    String rectName = input.next();
                    int totalLength = Integer.parseInt(input.next());
                    input.next();
                    input.next();
                    String rectSeqTest = input.next();
                    String rectSeq = "";
                    while(!rectSeqTest.equals("QA"))
                    {
                        rectSeq = (rectSeq + rectSeqTest);
                        rectSeqTest = input.next();
                    }
                    int startUsedRegion = Integer.parseInt(input.next());
                    int endUsedRegion = Integer.parseInt(input.next());
                    
                    rectSeq = rectSeq.replace('*','N');
                    contigArray[contigNum-1].createRect(((startUsedRegion-1)+(lengthArray[rectNum]-1)+40),
                                                                    rectY, (endUsedRegion - startUsedRegion +1),
                                                                    7, rectNum, rectName, totalLength,
                                                                    lengthArray[rectNum], startUsedRegion,
                                                                    endUsedRegion, rectSeq);
                    rectY += 23;
                    contigArray[contigNum-1].setYValue(rectY);
                    rectNum++;
                }//The previous creats instances of BACs(interactiveRectangles and stores
                //the info with the appropriate coting.                 
            }
            
            displaypanel.setContigArray(contigArray);
            displaypanel.setContigValues();
            displaypanel.revalidate();
            displaypanel.repaint();
            printImage.setContigArray(contigArray);
            printImage.setValues();
            uploadpanel.removeComboBox();
            uploadpanel.setContigArray(contigArray);
            uploadpanel.setContigValues();
            uploadpanel.revalidate();
            dpanel2.setContigArray(contigArray);
            dpanel2.setContigValues();
            dpanel2.revalidate();
            pImage2.setContigArray(contigArray);
            pImage2.setValues();
            dpanelp.setContigArray(contigArray);
            dpanelp.setContigValues();
            //The previous sends the contig array to the appropriate classes for use.
        }
        
        catch(NoSuchElementException elementException)
        {
            System.err.println("File improperly formed.");
            input.close();
            System.exit(1);
        }
        
        catch(IllegalStateException stateException)
        {
            System.err.println("Error reading from file.");
            System.exit(1);
        }
    }
    
    //This method closes the file when it is done reading it.
    public void closeFile()
    {
        if(input!= null)
            input.close();
    }
}