/*======================================================
This class is the panel that actually displays the info
in the seqDisplayFrame. While it is a text area, which
usually allows editting, editting has been locked to
ensure the accurracy of the text displayed.

Author: Eric Fritz
======================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.io.*;

public class SeqTextArea extends JTextArea implements Scrollable
{
	private SeqTextArea stArea;
	private String seq;
	
	//This is the constructor.
	public SeqTextArea(String n)
	{
		super(n);
		seq = n;
		stArea = this;
	}
	
	//These methods allow for the implementation of Scrollable but are unused.
	public boolean getScrollableTracksViewportHeight()
	{return false;}
	public boolean getScrollableTracksViewportWidth()
	{return false;}
	public int getScrollableBlockIncrement(Rectangle rect, int a, int b)
	{return 0;}
	public int getScrollableUnitIncrement(Rectangle rect, int a, int b)
	{return 0;}
	public Dimension getPreferredScrollableViewportSize()
	{return getPreferredSize();}
	
	//This method allows for the text to be saved.
	public void save(File f) throws IOException
	{
	    PrintWriter outputFile = new PrintWriter(new FileWriter(f));
	    outputFile.println(stArea.getText());
	    outputFile.close();
	}
}