/*=========================================================
This class allows for the printing of the name of the
BACs, etc on the displaypanel, since resizing issued don't
allow the text to be printed with it.

Author: Eric Fritz
==========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.lang.Double.*;
import java.awt.print.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class contigListPrint extends JPanel implements Printable
{
	private contigListPrint contigLP;
	volatile static PageFormat pf;
	private int width;
	private int height;
	private BufferedImage bimage;
	private interactiveRectangle[] rectArray;
	private PrinterJob pj;
	
	//This is the constructor.
	public contigListPrint(interactiveRectangle[] ira)
	{
		rectArray = ira;
		contigLP = this;
		width = 605;
		height = ((rectArray.length+2)*14);
		setPreferredSize(new Dimension(width, height));
	}
	
	//This method creates the buffered image.
	public void createImage()
	{
		bimage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = bimage.createGraphics();
		
		try
		{
			g2.setColor(Color.WHITE);
			g2.fillRect(0,0,width,height);
			g2.setColor(Color.BLACK);
			int xVal = 30;
			int yVal = 20;
			for(int i = 0; i < rectArray.length; i++)
			{
				String numList = (i+1)+")";
				g2.drawString(numList, 10, yVal);
				g2.drawString(rectArray[i].getContigName(), xVal, yVal);
				yVal = yVal+14;
			}
		}
		catch(NullPointerException npe){}
	}
	
	//This method sets the graphics.
	void render(Graphics2D g2, boolean printerFlag)
	{
		if(printerFlag)
			g2.drawImage(bimage, (int)pf.getImageableX(), (int)pf.getImageableY(),
			width, height, null);
		else
			g2.drawImage(bimage,0,0,width,height,null);
	}
	
	//This method allows the graphics to be viewed but is not used right now.
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		render(g2, false);
	}
	
	//The following methods implement and make the image printable.
	public int print(Graphics g, PageFormat pageFormat, int pageIndex)
	{
		Graphics2D g2 = (Graphics2D)g;
		int retcod = Printable.PAGE_EXISTS;
		if(pageIndex == 0)
			render(g2, true);
		else
			retcod = Printable.NO_SUCH_PAGE;
			
		return retcod;
	}
	public void PrintPanel()
	{
		pf = pj.defaultPage();
		pj.setPrintable(contigLP);
		PageFormat pf = pj.pageDialog(pj.defaultPage());
		try
		{
			pj.print();
		}
		catch(PrinterException pe){}
	}
	
	//This method allows other classes to set the printjob.
	public void setPrinterJob(PrinterJob pjob)
	{
		pj = pjob;
	}
}