/*===========================================================
This class creates the panel which houses the graphics
displayed when the nucleotide view option is selected. It is
very simiilar to displaypanel, but unlike the displaypanel
this panel is not interactive.

Author: Eric Fritz
===========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.lang.Double.*;
import java.io.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class dPanel2 extends JPanel implements Scrollable
{   
    private mainWindow mainWin;
    private int contigNum = 0;
    private Contig[] contigArray;
    private interactiveRectangle[] rectArray;
    private dPanel2 dpanel2;
    private String contigName;
    private Graphics2D g2;
    private iClass2 pImage2;
    private int[] scoresArray;
    private int colorNum;
    private int baseNum;
    private displayPanel displaypanel;
    private imageClass printImage;
    private fileUploadPanel uploadpanel;
    private dPanelp dpanelp;

    //This is the constructor.
    public dPanel2(mainWindow mw, displayPanel dp, imageClass iC, fileUploadPanel fup, iClass2 ic2, dPanelp dpp)
    {
        mainWin = mw;
        displaypanel = dp;
        printImage = iC;
        uploadpanel = fup;
        pImage2 = ic2;
        dpanelp = dpp;
        dpanel2 = this;
        setPreferredSize(new Dimension(1000,500));
        setBackground(Color.WHITE);
        
        displaypanelMListener clickListener = new displaypanelMListener();
        addMouseListener(clickListener);
    }
    
    //This method creates the graphics to be seen.
    public void paintComponent(Graphics g)
    {
        super.paintComponent(g);
        g2 = (Graphics2D)g;
        
        try
        {
            g2.setColor(Color.BLACK);
            g2.drawString(contigName, 40, 35);
            String backbone = contigArray[contigNum].getContigSeq();
            int BDist = 40;
            for(int i = 0; i < backbone.length(); i++)
            {
                g2.drawString(String.valueOf(backbone.charAt(i)), BDist, 60);
                BDist += 8;
            }//This creates the contig.
        
            for(int i = 0; i < rectArray.length; i++)
            {
                int temp1 = rectArray[i].getRX();
                int temp2 = rectArray[i].getRY();
                int temp3 = temp2-5;
                Color darkGreen =  new Color(0, 185, 0);
                int temp4 = rectArray[i].getStartOfUsedRegion();
                int temp5 = rectArray[i].getEndOfUsedRegion();
                int XDist = ((temp1-40)*8)+40;
                g2.setColor(Color.BLACK);
                g2.drawString(rectArray[i].getContigName(), XDist, temp3);
                String rectSeq = rectArray[i].getContigSeq();
                
                for(int j = temp4-1; j < temp5; j++)
                {
                    if(colorNum == 1)
                    {
                        g2.setColor(Color.BLUE);
                        String tempChar;
                        if(baseNum == 1)
                        {
                            if(!String.valueOf(rectSeq.charAt(j)).toUpperCase().equals(String.valueOf(backbone.charAt(j+rectArray[i].getStartOfContig()-1))) &&
                                scoresArray[j+rectArray[i].getStartOfContig()-1] < 50)
                            {
                                g2.setColor(darkGreen);
                                tempChar = String.valueOf(rectSeq.charAt(j));
                            }
                            else if(!String.valueOf(rectSeq.charAt(j)).toUpperCase().equals(String.valueOf(backbone.charAt(j+rectArray[i].getStartOfContig()-1))))
                            {
                                g2.setColor(Color.RED);
                                tempChar = String.valueOf(rectSeq.charAt(j));
                            }
                            else
                            {
                                tempChar = "-";
                            }
                            g2.drawString(tempChar, XDist, temp2+7);
                            XDist += 8;
                        }
                        else
                        {
                            if(!String.valueOf(rectSeq.charAt(j)).toUpperCase().equals(String.valueOf(backbone.charAt(j+rectArray[i].getStartOfContig()-1))) &&
                            scoresArray[j+rectArray[i].getStartOfContig()-1] < 50)
                            {
                                g2.setColor(darkGreen);
                            }
                            else if(!String.valueOf(rectSeq.charAt(j)).toUpperCase().equals(String.valueOf(backbone.charAt(j+rectArray[i].getStartOfContig()-1))))
                            {
                                g2.setColor(Color.RED);
                            }
                            g2.drawString(String.valueOf(rectSeq.charAt(j)), XDist, temp2+7);
                            XDist += 8;
                        }
                    }
                    else
                    {
                        if(baseNum == 1 && String.valueOf(rectSeq.charAt(j)).toUpperCase().equals(String.valueOf(backbone.charAt(j+rectArray[i].getStartOfContig()-1))))
                        {
                            g2.setColor(Color.BLUE);
                            g2.drawString("-", XDist, temp2+7);
                            XDist += 8;
                        }
                        else
                        {
                            g2.setColor(Color.BLUE);
                            g2.drawString(String.valueOf(rectSeq.charAt(j)), XDist, temp2+7);
                            XDist += 8;
                        }
                    }
                }
            }//This creates the BACs, etc.
        }
        catch(NullPointerException nullPointerException){}
    }
    
    //These methods set the important values like in displaypanel.
    public void setContigArray(Contig[] sca)
    {contigArray = sca;}
    public void setContigNum(int scn)
    {contigNum = scn;}
    public void setContigValues()
    {
        contigName = contigArray[contigNum].getContigName();
        rectArray = contigArray[contigNum].getRectArray();
        scoresArray = contigArray[contigNum].getScoresArray();
        int tempXV = (contigArray[contigNum].getContigLength()*8)+50;
        int tempYV = contigArray[contigNum].getYValue()+25;
        if(tempXV > 1000 && tempYV > 500)
        {
            dpanel2.setPreferredSize(new Dimension(tempXV , tempYV));
            pImage2.setWidth(tempXV);
            pImage2.setHeight(tempYV);
        }
        else if(tempXV > 1000)
        {
            dpanel2.setPreferredSize(new Dimension(tempXV , 500));
            pImage2.setWidth(tempXV);
            pImage2.setHeight(500);
        }
        else if(tempYV > 500)
        {
            dpanel2.setPreferredSize(new Dimension(1000, tempYV));
            pImage2.setWidth(1000);
            pImage2.setHeight(tempYV);
        }
    }
    public void setColorNum(int scn)
    {colorNum = scn;}
    public void setBaseNum(int sbn)
    {baseNum = sbn;}
    
    //This method is utilized when clearing the template so a new file can be uploaded.
    public void clearContigValues()
    {
        contigName = "";
        rectArray = new interactiveRectangle[0];
        scoresArray = new int[0];
        dpanel2.setPreferredSize(new Dimension(1000, 500));
        pImage2.setWidth(1000);
        pImage2.setHeight(500);
    }
    
    //These methods allow for the retreival of important info.
    public String getContigName()
    {return contigName;}
    public Graphics2D getGraphics()
    {return g2;}
    
    //These methods are initiated because of implementing Scrollable but are unused.
    public boolean getScrollableTracksViewportHeight()
    {return false;}
    public boolean getScrollableTracksViewportWidth()
    {return false;}
    public int getScrollableBlockIncrement(Rectangle rect, int a, int b)
    {return 0;}
    public int getScrollableUnitIncrement(Rectangle rect, int a, int b)
    {return 0;}
    public Dimension getPreferredScrollableViewportSize()
    {return getPreferredSize();}
    
    //This class is what causes the BACs, etc (lines/bars) to be interactive
    //and clickable.
    private class displaypanelMListener implements MouseListener
    {
        public void mouseClicked(MouseEvent e){}
        public void mousePressed(MouseEvent e)
        {
            try
            {
                int mod = e.getModifiersEx();
                
                if(((mod & e.CTRL_DOWN_MASK) != 0) && ((mod & e.BUTTON1_DOWN_MASK) != 1))
                {
                     for(int i = 0; i < rectArray.length; i++)
                    {
                        int tempX = rectArray[i].getRX();
                        int tempY = rectArray[i].getRY();
                        int tempW = rectArray[i].getRW();
                        Rectangle tempRect = new Rectangle(tempX, tempY, tempW*8, 8);
                        if(tempRect.contains(e.getX(), e.getY()))
                        {
                            
                        }
                    } 
                }
                else if((mod & e.BUTTON1_DOWN_MASK) != 0)
                {
                    int bW = contigArray[contigNum].getContigSeq().length();
                    Rectangle tempBackbone = new Rectangle(40, 60, bW*8, 8);
                    if(tempBackbone.contains(e.getX(), e.getY()))
                    {
                        seqDisplayFrame sdFrame = new seqDisplayFrame(contigArray[contigNum].getContigName(), contigArray[contigNum].getContigSeq(), mainWin, displaypanel, 
                                                                      printImage, uploadpanel, dpanel2, pImage2, dpanelp, contigArray, 0, contigNum, 2);
                        sdFrame.setVisible(true);
                    }
                    for(int i = 0; i < rectArray.length; i++)
                    {
                        int tempX = rectArray[i].getRX();
                        tempX = tempX-40;
                        tempX = tempX*8;
                        tempX = tempX+40;
                        int tempY = rectArray[i].getRY();
                        int tempW = rectArray[i].getRW();
                        Rectangle tempRect = new Rectangle(tempX, tempY, tempW*8, 8);
                        if(tempRect.contains(e.getX(), e.getY()))
                        {
                            seqDisplayFrame sdFrame = new seqDisplayFrame(rectArray[i].getContigName(), rectArray[i].getContigSeq(), mainWin, displaypanel, printImage,
                                                                          uploadpanel, dpanel2, pImage2, dpanelp, contigArray, i, contigNum, 2);
                            sdFrame.setVisible(true);
                        }
                    }   
                 }
                 else if((mod & e.BUTTON3_DOWN_MASK) != 0)
                 {
                    for(int i = 0; i < rectArray.length; i++)
                    {
                        int tempX = rectArray[i].getRX();
                        int tempY = rectArray[i].getRY();
                        int tempW = rectArray[i].getRW();
                        Rectangle tempRect = new Rectangle(tempX, tempY, tempW*8, 8);
                        if(tempRect.contains(e.getX(), e.getY()))
                        {
                            
                        }
                    } 
                 }
            }
            catch(NullPointerException nullPointerException){}
        }
        public void mouseReleased(MouseEvent e){}
        public void mouseExited(MouseEvent e){}
        public void mouseEntered(MouseEvent e){}
    }
}