/*========================================================
This class allows for the printing of the displaypanel
only. the nucleotide view is not printable.

Author: Eric Fritz
========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.lang.Double.*;
import java.awt.print.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class dPanelp extends JPanel implements Printable
{
    private int contigNum=0;
    private Contig[] contigArray;
    private interactiveRectangle[] rectArray;
    private dPanelp dpanelp;
    private Rectangle backbone;
    private String contigName;
    private int q = 2;
    volatile static PageFormat pf;
    private int Iwidth = 0;
    private int Iheight = 0;
    private BufferedImage bimage;
    private PrinterJob pj;
    
    //This is the constructor.
    public dPanelp()
    {
        dpanelp = this;
        setPreferredSize(new Dimension(1000/q,500/q));
        setBackground(Color.WHITE);
    }
    
    //This method creates the image to be printed.
    public void createImage()
    {
        bimage = new BufferedImage(Iwidth, Iheight, BufferedImage.TYPE_INT_RGB);
        Graphics2D g2 = bimage.createGraphics();
        
        try
        {
            g2.setColor(Color.WHITE);
            g2.fillRect(0,0,Iwidth,Iheight);
            g2.setColor(Color.BLACK);
            g2.fill(backbone);
            for(int j = 40; j < contigArray[contigNum].getContigLength()+40; j += 100)
            {
                g2.drawString(String.valueOf(j-40), j , 50);
                g2.drawLine(j, 55, j, 80);
            }
            
            for(int i = 0; i < rectArray.length; i++)
            {
                String numList = (i+1)+")";
                Rectangle tempRect = rectArray[i];
                g2.setColor(Color.BLACK);
                g2.drawString(numList, 20, rectArray[i].getYVal());
                g2.setColor(Color.BLUE);
                g2.fill(tempRect);
            }
        }
        catch(NullPointerException npe){}
    }
    
    //This method sets the graphics and scales them to fit on 1 page.
    void render(Graphics2D g2, boolean printerFlag)
    {
        if(printerFlag)
            g2.drawImage(bimage, (int)pf.getImageableX(), (int)pf.getImageableY(),
            (int)(pf.getImageableWidth()*9/6),
            (int)(pf.getImageableHeight()*(pf.getImageableWidth()/Iwidth)*9/6), null);
        else
            g2.drawImage(bimage,0,0,Iwidth,Iheight,null);
    }
    
    //This method allows the graphics to be viewed but is not used right now.
    public void paintComponent(Graphics g)
    {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        render(g2, false);
    }
    
    //The following methods allow for the setting of important info.
    public void setContigArray(Contig[] sca)
    {contigArray = sca;}
    public void setContigNum(int scn)
    {contigNum = scn;}
    public void setContigValues()
    {
        backbone = new Rectangle(40, 60, contigArray[contigNum].getContigLength(), 15);
        contigName = contigArray[contigNum].getContigName();
        rectArray = contigArray[contigNum].getRectArray();
        int tempXV = contigArray[contigNum].getContigLength() + 50;
        int tempYV = contigArray[contigNum].getYValue() + 25;
        if(tempXV > 1000 && tempYV > 500)
        {
            Iwidth = tempXV;
            Iheight = tempYV;
        }
        else if(tempXV > 1000)
        {
            Iwidth = tempXV;
            Iheight = 500;
        }
        else if(tempYV > 500)
        {
            Iwidth = 1000;
            Iheight = tempYV;
        }
    }
    
    //This method is utilized when clearing the template so a new file can be uploaded.
    public void clearContigValues()
    {
        backbone = new Rectangle(0,0,0,0);
        contigName = "";
        rectArray = new interactiveRectangle[0];
        Iwidth = 1000;
        Iheight = 500;
    }
    
    //The following methods implement and make the image printable.
    public int print(Graphics g, PageFormat pageFormat, int pageIndex)
    {
        Graphics2D g2 = (Graphics2D)g;
        int retcod = Printable.PAGE_EXISTS;
        if(pageIndex == 0)
            render(g2, true);
        else
            retcod = Printable.NO_SUCH_PAGE;
            
        return retcod;
    }
    public void PrintPanel()
    {
        pj = PrinterJob.getPrinterJob();
        pf = pj.defaultPage();
        pj.setPrintable(dpanelp);
        PageFormat pf = pj.pageDialog(pj.defaultPage());
        try
        {
            pj.print();
        }
        catch(PrinterException pe){}
    }
    
    //This methods sends the printerjob to another class.
    public PrinterJob getPrinterJob()
    {return pj;}
}