/*===========================================================
This class creates the panel which displays the contig and
the BACS, etc that it is created from (as lines/bars) as well
as pertinent information and is interactive in which you can
click on the lines/bars and a window will open with info.

Author: Eric Fritz
===========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.lang.Double.*;
import java.io.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class displayPanel extends JPanel implements Scrollable
{   
    private mainWindow mainWin;
    private int contigNum = 0;
    private Contig[] contigArray;
    private interactiveRectangle[] rectArray;
    private displayPanel displaypanel;
    private Rectangle backbone;
    private String contigName;
    private Graphics2D g2;
    private imageClass printImage;
    private fileUploadPanel uploadpanel;
    private dPanel2 dpanel2;
    private iClass2 pImage2;
    private dPanelp dpanelp;
    private int removeNum;

    //This is the constructor.
    public displayPanel(mainWindow mw, imageClass iC, fileUploadPanel fup, dPanel2 dp2, iClass2 ic2, dPanelp dpp)
    {
        mainWin = mw;
        printImage = iC;
        uploadpanel = fup;
        dpanel2 = dp2;
        pImage2 = ic2;
        dpanelp = dpp;
        displaypanel = this;
        setPreferredSize(new Dimension(1000,500));
        setBackground(Color.WHITE);
        
        displaypanelMListener clickListener = new displaypanelMListener();
        addMouseListener(clickListener);
    }
    
    //This class creates the graphics to be viewed.
    public void paintComponent(Graphics g)
    {
        super.paintComponent(g);
        g2 = (Graphics2D)g;
        
        try
        {
            g2.setColor(Color.BLACK);
            g2.drawString(contigName, 40, 35);
            g2.fill(backbone);
            for(int j = 40; j < contigArray[contigNum].getContigLength()+40; j += 100)
            {
                g2.drawString(String.valueOf(j-40)+" bps", j , 50);
                g2.drawLine(j, 55, j, 80);
            }//The previous draws the contig.
            
            for(int i = 0; i < rectArray.length; i++)
            {
                Rectangle tempRect = new Rectangle(rectArray[i].getRX(), rectArray[i].getRY(), rectArray[i].getRW(), rectArray[i].getRH());
                g2.setColor(Color.BLUE);
                g2.fill(tempRect);
                int temp1 = rectArray[i].getRX();
                int temp2 = rectArray[i].getRY()-4;
                g2.setColor(Color.BLACK);
                g2.drawString(rectArray[i].getContigName(), temp1, temp2);

            }//The previous draws all the BACs, etc.
        }
        catch(NullPointerException nullPointerException){}
    }
    
    //The following methods set variables important to the display panel based
    //on which contig you are viewing.
    public void setContigArray(Contig[] sca)
    {contigArray = sca;}
    public void setContigNum(int scn)
    {contigNum = scn;}
    public void setContigValues()
    {
        backbone = new Rectangle(40, 60, contigArray[contigNum].getContigLength(), 15);
        contigName = contigArray[contigNum].getContigName();
        rectArray = contigArray[contigNum].getRectArray();
        int tempXV = contigArray[contigNum].getContigLength()+50;
        int tempYV = contigArray[contigNum].getYValue()+25;
        if(tempXV > 1000 && tempYV > 500)
        {
            displaypanel.setPreferredSize(new Dimension(tempXV , tempYV));
            printImage.setWidth(tempXV);
            printImage.setHeight(tempYV);
        }
        else if(tempXV > 1000)
        {
            displaypanel.setPreferredSize(new Dimension(tempXV , 500));
            printImage.setWidth(tempXV);
            printImage.setHeight(500);
        }
        else if(tempYV > 500)
        {
            displaypanel.setPreferredSize(new Dimension(1000, tempYV));
            printImage.setWidth(1000);
            printImage.setHeight(tempYV);
        }
    }
    
    //This method is utilized when clearing the template so a new file can be uploaded.
    public void clearContigValues()
    {
        backbone = new Rectangle(0,0,0,0);
        contigName = "";
        rectArray = new interactiveRectangle[0];
        displaypanel.setPreferredSize(new Dimension(1000,500));
        printImage.setWidth(1000);
        printImage.setHeight(500);
    }
    
    //The following methods retrieve information other classes may need access to.
    public String getContigName()
    {return contigName;}
    public Graphics2D getGraphics()
    {return g2;}
    public interactiveRectangle[] getRectArray()
    {return rectArray;}
    public void setRemoveNum(int srn)
    {removeNum = srn;}
    
    //The following methods are initiated because of implementing Scrollable
    //but are not used.
    public boolean getScrollableTracksViewportHeight()
    {return false;}
    public boolean getScrollableTracksViewportWidth()
    {return false;}
    public int getScrollableBlockIncrement(Rectangle rect, int a, int b)
    {return 0;}
    public int getScrollableUnitIncrement(Rectangle rect, int a, int b)
    {return 0;}
    public Dimension getPreferredScrollableViewportSize()
    {return getPreferredSize();}
    
    //This class is what causes the BACs, etc (lines/bars) to be interactive
    //and clickable.
    private class displaypanelMListener implements MouseListener
    {
        public void mouseClicked(MouseEvent e){}
        public void mousePressed(MouseEvent e)
        {
            try
            {
                int mod = e.getModifiersEx();
                
                if(((mod & e.CTRL_DOWN_MASK) != 0) && ((mod & e.BUTTON1_DOWN_MASK) != 1))
                {
                     for(int i = 0; i < rectArray.length; i++)
                    {
                        Rectangle tempRect = new Rectangle(rectArray[i].getRX(), rectArray[i].getRY(), rectArray[i].getRW(), rectArray[i].getRH());
                        int tempX = rectArray[i].getRX();
                        int tempY = rectArray[i].getRY() - 15;
                        int tempL = rectArray[i].getContigName().length();
                        Rectangle tempRect2 = new Rectangle(tempX, tempY, tempL*8, 15);
                        if(tempRect.contains(e.getX(), e.getY()) || tempRect2.contains(e.getX(), e.getY()))
                        {
                            
                        }
                    } 
                }
                else if((mod & e.BUTTON1_DOWN_MASK) != 0)
                {
                    if(backbone.contains(e.getX(), e.getY()))
                    {
                        seqDisplayFrame sdFrame = new seqDisplayFrame(contigArray[contigNum].getContigName(), contigArray[contigNum].getContigSeq(), mainWin, displaypanel, 
                                                                      printImage, uploadpanel, dpanel2, pImage2, dpanelp, contigArray, 0, contigNum, 1);
                        sdFrame.setVisible(true);
                    }
                    for(int i = 0; i < rectArray.length; i++)
                    {
                        Rectangle tempRect = new Rectangle(rectArray[i].getRX(), rectArray[i].getRY(), rectArray[i].getRW(), rectArray[i].getRH());
                        int tempX = rectArray[i].getRX();
                        int tempY = rectArray[i].getRY() - 15;
                        int tempL = rectArray[i].getContigName().length();
                        Rectangle tempRect2 = new Rectangle(tempX, tempY, tempL*8, 15);
                        if(tempRect.contains(e.getX(), e.getY()) || tempRect2.contains(e.getX(), e.getY()))
                        {
                            seqDisplayFrame sdFrame = new seqDisplayFrame(rectArray[i].getContigName(), rectArray[i].getContigSeq(), mainWin, displaypanel, printImage,
                                                                          uploadpanel, dpanel2, pImage2, dpanelp, contigArray, i, contigNum, 1);
                            sdFrame.setVisible(true);
                        }
                    }   
                 }
                 else if((mod & e.BUTTON3_DOWN_MASK) != 0)
                 {
                    for(int i = 0; i < rectArray.length; i++)
                    {
                        Rectangle tempRect = new Rectangle(rectArray[i].getRX(), rectArray[i].getRY(), rectArray[i].getRW(), rectArray[i].getRH());
                        int tempX = rectArray[i].getRX();
                        int tempY = rectArray[i].getRY() - 15;
                        int tempL = rectArray[i].getContigName().length();
                        Rectangle tempRect2 = new Rectangle(tempX, tempY, tempL*8, 15);
                        if(tempRect.contains(e.getX(), e.getY()) || tempRect2.contains(e.getX(), e.getY()))
                        {
                            
                        }
                    } 
                 }
            }
            catch(NullPointerException nullPointerException){}
        }
        public void mouseReleased(MouseEvent e){}
        public void mouseExited(MouseEvent e){}
        public void mouseEntered(MouseEvent e){}
    }
}