/*==========================================================
This class creates the panel that allows you to upload the
file containing the contig(s) and allows you to select
which contig to view (when applicable).

Author: Eric Fritz
===========================================================*/
import javax.swing.*;
import java.awt.*;
import java.io.File;
import javax.swing.border.*;
import java.awt.event.*;

public class fileUploadPanel extends JPanel
{
    private JTextArea outputArea;
    private displayPanel displaypanel;
    private ReadTextFile application;
    private String uploadFileName;
    private imageClass printImage;
    private Contig[] contigArray;
    private fileUploadPanel uploadpanel;
    private JComboBox contigChooser;
    private String[] contigNameArray = {"--------"};
    private mainWindow mainWin;
    private dPanel2 dpanel2;
    private iClass2 pImage2;
    private dPanelp dpanelp;

    //This is the constructor.
    public fileUploadPanel(displayPanel dp, ReadTextFile  app, mainWindow mW, imageClass iC, dPanel2 dp2, iClass2 ic2, dPanelp dpp)
    {
        displaypanel = dp;
        application = app;
        printImage = iC;
        mainWin = mW;
        dpanel2 = dp2;
        pImage2 = ic2;
        dpanelp = dpp;
        uploadpanel = this;
        
        outputArea = new JTextArea("");
        
        JLabel uploadLabel = new JLabel("Choose an .ace file to upload.");
        
        JButton uploadFile = new JButton("Upload .ace File");//Creates the button that starts the upload process.
        uploadFileListener uflistener = new uploadFileListener();
        uploadFile.addActionListener(uflistener);
        
        JLabel clearLabel = new JLabel("Clear the file before uploading a new one.");
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new clearListener());
        
        JLabel selectLabel = new JLabel("Choose the contig to view.");
        contigChooser = new JComboBox(contigNameArray);//Creates the menu for contig selection.
        
        
        add(uploadLabel);
        add(uploadFile);
        add(clearLabel);
        add(clearButton);
        add(selectLabel);
        add(contigChooser);
    }
    
    //This method creates the window that gives you the option of which file
    //to choose.
    private File getFile()
    {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        
        int result = fileChooser.showOpenDialog(this);
        
        if(result == JFileChooser.CANCEL_OPTION)
            System.exit(1);
            
        File fileName = fileChooser.getSelectedFile();
        
        if((fileName == null) || (fileName.getName().equals("")))
        {
            JOptionPane.showMessageDialog(this, "Invalid File Name","Invalid File Name", JOptionPane.ERROR_MESSAGE);
            System.exit(1);
        }
        
        return fileName;
    }
    
    //This method analyzes the chosen file and makes sure it is a correct file.
    public void analyzePath()
    {
        File name = getFile();
        
        if(name.exists())
        {
            outputArea.setText(String.format(name.getPath()));
            
            uploadFileName = name.getPath();
            
            if(name.isDirectory())
            {
                String directory[] = name.list();
                outputArea.append("\n\nDirectory contents:\n");
                
                for(String directoryName : directory)
                    outputArea.append(directoryName + "\n");
            }
        }
        else
        {
            JOptionPane.showMessageDialog(this, name + "does not exist.", "ERROR", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    //This method sets the contig array.
    public void setContigArray(Contig[] sca)
    {
        contigArray = sca;
    }
    
    //This method sets the contig choosing menu when a new file is uploaded.
    public void setContigValues()
    {
        contigNameArray = new String[contigArray.length];
        for(int i = 0; i < contigArray.length; i++)
        {
            String temp = contigArray[i].getContigName();
            contigNameArray[i] = temp;
        }
        contigChooser = new JComboBox(contigNameArray);
        contigChooser.addActionListener(new chooserListener());
        uploadpanel.add(contigChooser);
    }
    //This method is used to remove the current combobox so a new one can be initiated.
    public void removeComboBox()
    {
        uploadpanel.remove(contigChooser);
    }
    
    //This method is used to set the combobox to be blank.
    public void setBlankComboBox()
    {
        String[] tempName = {"--------"};
        contigNameArray = tempName;
        contigChooser = new JComboBox(contigNameArray);
        uploadpanel.add(contigChooser);
    }
    
    //This class utilizes the previous methods when you click the Upload File
    //button and then sends the file to another class (ReadTextFile).
    private class uploadFileListener implements ActionListener
    {
        public uploadFileListener(){}
        
        public void actionPerformed(ActionEvent e)
        {
            analyzePath();
            application.openFile(uploadFileName);
            application.readRecords(displaypanel, uploadpanel, printImage, dpanel2, pImage2, dpanelp);
            application.closeFile();
            displaypanel.repaint();
        }
    }
    
    //This class works with the contig choice menu and makes sure the chosen
    //contig is displayed and properly set for saving/printing. 
    private class chooserListener implements ActionListener
    {
        public chooserListener(){}
        
        public void actionPerformed(ActionEvent e)
        {
            String choice = (String) contigChooser.getSelectedItem();
            
            for(int i = 0; i < contigArray.length; i++)
            {
                if(choice.equals(contigArray[i].getContigName()))
                {
                    displaypanel.setContigNum(i);
                    displaypanel.setContigValues();
                    displaypanel.revalidate();
                    printImage.setContigNum(i);
                    printImage.setValues();
                    dpanel2.setContigNum(i);
                    dpanel2.setContigValues();
                    dpanel2.revalidate();
                    pImage2.setContigNum(i);
                    pImage2.setValues();
                    dpanelp.setContigNum(i);
                    dpanelp.setContigValues();
                    
                    int tester = mainWin.getDisplayNum();
                    if(tester == 1)
                    {
                        mainWin.removeDisplayPanel();
                        mainWin.setDisplayPanel(displaypanel);
                    }
                    else
                    {
                        mainWin.removeDPanel2();
                        mainWin.setDPanel2(dpanel2);
                    }
                }
            }
        }
    }
    
    private class clearListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            Contig[] blankArray = new Contig[0];
            
            displaypanel.setContigNum(0);
            displaypanel.setContigArray(blankArray);
            displaypanel.clearContigValues();
            displaypanel.revalidate();
            displaypanel.repaint();
            printImage.setContigNum(0);
            printImage.setContigArray(blankArray);
            printImage.clearValues();
            uploadpanel.removeComboBox();
            uploadpanel.setContigArray(blankArray);
            uploadpanel.setBlankComboBox();
            uploadpanel.revalidate();
            dpanel2.setContigNum(0);
            dpanel2.setContigArray(blankArray);
            dpanel2.clearContigValues();
            dpanel2.revalidate();
            pImage2.setContigNum(0);
            pImage2.setContigArray(blankArray);
            pImage2.clearValues();
            dpanelp.setContigNum(0);
            dpanelp.setContigArray(blankArray);
            dpanelp.clearContigValues();
        }
    }
}